/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.util.List;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class SubTypeHierarchyViewer
extends TypeHierarchyViewer {
    public SubTypeHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part) {
        super(parent, (IContentProvider)new SubTypeHierarchyContentProvider(lifeCycle), lifeCycle, part);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.getString("SubTypeHierarchyViewer.filtered.title");
        }
        return TypeHierarchyMessages.getString("SubTypeHierarchyViewer.title");
    }

    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            int expandLevel = 2;
            if (this.isMethodFiltering()) {
                ++expandLevel;
            }
            this.expandToLevel(expandLevel);
        }
        this.getTree().setRedraw(true);
    }

    public static class SubTypeHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public SubTypeHierarchyContentProvider(TypeHierarchyLifeCycle lifeCycle) {
            super(lifeCycle);
        }

        protected final void getTypesInHierarchy(ICElement type, List res) {
            ICElement[] types;
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null && (types = hierarchy.getSubtypes(type)) != null) {
                int i = 0;
                while (i < types.length) {
                    res.add(types[i]);
                    ++i;
                }
            }
        }

        protected ICElement[] getParentTypes(ICElement type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSupertypes(type);
            }
            return null;
        }
    }
}

