/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CPathFilterPage
extends WizardPage {
    private final int[] fFilterType;
    private CheckboxTableViewer viewer;
    private IPathEntry fParentEntry;
    private List fPaths;
    private List fExclusions;
    private ViewerFilter filter;
    protected ICElement fCElement;

    protected CPathFilterPage(ICElement cElement, int[] filterType) {
        super("CPathFilterPage");
        this.setTitle(CPathEntryMessages.getString("CPathFilterPage.title"));
        this.setDescription(CPathEntryMessages.getString("CPathFilterPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fFilterType = filterType;
        this.fCElement = cElement;
        this.validatePage();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(CPathEntryMessages.getString("CPathFilterPage.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2816);
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CPElementLabelProvider(false, false));
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CPathFilterPage.this.validatePage();
            }
        });
        gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public void setVisible(boolean visible) {
        if (this.fPaths != null) {
            this.viewer.setInput((Object)this.fPaths);
        }
        super.setVisible(visible);
    }

    public void setParentEntry(IPathEntry entry) {
        this.fParentEntry = entry;
        if (this.fParentEntry.getEntryKind() == 2) {
            IProject project = CUIPlugin.getWorkspace().getRoot().getProject(this.fParentEntry.getPath().segment(0));
            if (project.isAccessible()) {
                ICProject cProject = CoreModel.getDefault().create(project);
                try {
                    this.fPaths = Arrays.asList(cProject.getRawPathEntries());
                }
                catch (CModelException cModelException) {}
            }
        } else if (this.fParentEntry.getEntryKind() == 5) {
            try {
                IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)this.fParentEntry.getPath(), (ICProject)this.fCElement.getCProject());
                if (container != null) {
                    this.fPaths = Arrays.asList(container.getPathEntries());
                }
            }
            catch (CModelException cModelException) {}
        }
        this.createExlusions(this.fParentEntry.getEntryKind() == 2);
    }

    private void createExlusions(boolean showExported) {
        this.fExclusions = new ArrayList();
        if (this.filter != null) {
            this.viewer.removeFilter(this.filter);
        }
        this.filter = new CPElementFilter(this.fExclusions.toArray(), this.fFilterType, showExported, false);
        this.viewer.addFilter(this.filter);
    }

    private void validatePage() {
        this.setPageComplete(this.getSelectedEntries().length > 0);
    }

    public IPathEntry[] getSelectedEntries() {
        if (this.viewer != null) {
            Object[] paths = this.viewer.getCheckedElements();
            IPathEntry[] entries = new IPathEntry[paths.length];
            System.arraycopy(paths, 0, entries, 0, entries.length);
            return entries;
        }
        return new IPathEntry[0];
    }
}

