/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.search.ui.text.Match;

public class NewSearchResultCollector
extends BasicSearchResultCollector {
    public static final int PARENT_LENGTH = 7;
    public static final String PARENT = "PARENT:";
    public static final int NAME_LENGTH = 5;
    public static final String NAME = "NAME:";
    public static final int LOCATION_LENGTH = 9;
    public static final String LOCATION = "LOCATION:";
    public static final int ELEMENTTYPE_LENGTH = 12;
    public static final String ELEMENTTYPE = "ELEMENTTYPE:";
    public static final int VISIBILITY_LENGTH = 11;
    public static final String VISIBILITY = "VISIBILITY:";
    private CSearchResult fSearch;
    private IProgressMonitor fProgressMonitor;
    private int fMatchCount;

    public NewSearchResultCollector(CSearchResult search, IProgressMonitor monitor) {
        this.fSearch = search;
        this.fProgressMonitor = monitor;
        this.fMatchCount = 0;
    }

    public void accept(IResource resource, int start, int end, ICElement enclosingElement, int accuracy) {
        ++this.fMatchCount;
        this.fSearch.addMatch(new Match((Object)enclosingElement, start, end - start));
    }

    public void done() {
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public int getMatchCount() {
        return this.fMatchCount;
    }

    public boolean acceptMatch(IMatch match) throws CoreException {
        BasicSearchMatch searchMatch = (BasicSearchMatch)match;
        if (!super.acceptMatch(match)) {
            return false;
        }
        if (searchMatch.resource == null && searchMatch.path == null) {
            return false;
        }
        if (searchMatch.resource != null) {
            ++this.fMatchCount;
            int start = match.getStartOffset();
            int end = match.getEndOffset();
            String classifier = PARENT + match.getParentName() + NAME + match.getName() + LOCATION + match.getLocation().toOSString() + ELEMENTTYPE + match.getElementType() + VISIBILITY + match.getVisibility();
            this.fSearch.addMatch(new CSearchMatch(classifier, start, end - start, match));
            return true;
        }
        ++this.fMatchCount;
        int start = match.getStartOffset();
        int end = match.getEndOffset();
        String classifier = PARENT + match.getParentName() + NAME + match.getName() + LOCATION + match.getLocation().toOSString() + ELEMENTTYPE + match.getElementType() + VISIBILITY + match.getVisibility();
        this.fSearch.addMatch(new CSearchMatch(classifier, start, end - start, match));
        return true;
    }

    private IFile getUniqueFile(IPath externalMatchLocation, IProject refProject) {
        IFile file = null;
        String fileName = "";
        int segments = externalMatchLocation.segmentCount() - 1;
        int linkNumber = 0;
        while (linkNumber < Integer.MAX_VALUE) {
            file = refProject.getFile(fileName = fileName != "" ? "cdtlnk" + linkNumber + "_" + externalMatchLocation.segment(segments) : externalMatchLocation.segment(segments));
            IPath path = file.getLocation();
            if (externalMatchLocation.equals((Object)path) || !file.exists()) break;
            ++linkNumber;
        }
        return file;
    }
}

