/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IUpdate;

public class OpenDeclarationsAction
extends SelectionParseAction
implements IUpdate {
    SearchEngine searchEngine = null;
    String projectName = "";

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.getString("OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDeclarations.description"));
        this.searchEngine = new SearchEngine();
    }

    protected SelectionParseAction.SelSearchNode getSelectedStringFromEditor() {
        ISelection selection = this.getSelection();
        if (selection == null || !(selection instanceof ITextSelection)) {
            return null;
        }
        return this.getSelection((ITextSelection)selection);
    }

    public void run() {
        final SelectionParseAction.SelSearchNode selNode = this.getSelectedStringFromEditor();
        if (selNode == null) {
            return;
        }
        final Storage storage = new Storage();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) {
                IFile resourceFile = OpenDeclarationsAction.this.fEditor.getInputFile();
                OpenDeclarationsAction.this.projectName = this.findProjectName(resourceFile);
                IParser parser = OpenDeclarationsAction.this.setupParser(resourceFile);
                int selectionStart = selNode.selStart;
                int selectionEnd = selNode.selEnd;
                IParser.ISelectionParseResult result = null;
                IASTOffsetableNamedElement node = null;
                try {
                    try {
                        result = parser.parse(selectionStart, selectionEnd);
                        if (result != null) {
                            node = result.getOffsetableNamedElement();
                        }
                    }
                    catch (ParseError parseError) {
                    }
                    catch (VirtualMachineError vmErr) {
                        if (vmErr instanceof OutOfMemoryError) {
                            Util.log(null, (String)("Open Declarations Out Of Memory error: " + vmErr.getMessage() + " on File: " + resourceFile.getName()), (ICLogConstants.LogConst)ICLogConstants.CDT);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (node == null) {
                        return;
                    }
                    throw throwable;
                }
                {
                    Object var9_11 = null;
                    if (node == null) {
                        return;
                    }
                    storage.setFileName(result.getFilename());
                    storage.setElement(node);
                    storage.setResource(ParserUtil.getResourceForFilename((String)result.getFilename()));
                    return;
                }
            }

            private String findProjectName(IFile resourceFile) {
                if (resourceFile == null) {
                    return "";
                }
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].contains((ISchedulingRule)resourceFile)) {
                        return projects[i].getName();
                    }
                    ++i;
                }
                return "";
            }
        };
        try {
            ProgressMonitorDialog progressMonitor = new ProgressMonitorDialog(this.getShell());
            progressMonitor.run(true, true, runnable);
            IASTOffsetableNamedElement namedElement = storage.getNamedElement();
            if (namedElement == null) {
                this.operationNotAvailable();
                return;
            }
            this.clearStatusLine();
            if (storage.getResource() != null) {
                int nameOffset = 0;
                int nameEndOffset = 0;
                nameOffset = namedElement.getNameOffset();
                nameEndOffset = namedElement.getNameEndOffset();
                this.open(storage.getResource(), nameOffset, nameEndOffset - nameOffset);
                return;
            }
            String fileName = null;
            int nameOffset = 0;
            int nameEndOffset = 0;
            fileName = storage.getFileName();
            nameOffset = namedElement.getNameOffset();
            nameEndOffset = namedElement.getNameEndOffset();
            if (fileName != null) {
                this.open(fileName, nameOffset, nameEndOffset - nameOffset);
            }
        }
        catch (Exception x) {
            CUIPlugin.getDefault().log(x);
        }
    }

    protected boolean open(String filename, int offset, int length) throws PartInitException, CModelException {
        Path path = new Path(filename);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file != null) {
            this.open((IResource)file, offset, length);
            return true;
        }
        ICProject cproject = CoreModel.getDefault().getCModel().getCProject(this.projectName);
        ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, (IPath)path);
        if (unit != null) {
            this.setSelectionAtOffset(EditorUtility.openInEditor(unit), offset, length);
            return true;
        }
        FileStorage storage = new FileStorage(null, (IPath)path);
        IEditorPart part = EditorUtility.openInEditor(storage);
        this.setSelectionAtOffset(part, offset, length);
        return true;
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    protected void open(IMatch element) throws CModelException, PartInitException {
        this.open(element.getResource(), element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
    }

    protected void open(IResource resource, int offset, int length) throws CModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(resource);
        this.setSelectionAtOffset(part, offset, length);
    }

    private void setSelectionAtOffset(IEditorPart part, int offset, int length) {
        if (part instanceof CEditor) {
            CEditor ed = (CEditor)part;
            try {
                ed.selectAndReveal(offset, length);
            }
            catch (Exception exception) {}
        }
    }

    public void update() {
        this.setEnabled(this.getSelectedStringFromEditor() != null);
    }

    private ICSearchConstants.SearchFor getSearchForFromNode(IASTNode node) {
        ICSearchConstants.SearchFor searchFor = null;
        if (node instanceof IASTClassSpecifier) {
            IASTClassSpecifier tempNode = (IASTClassSpecifier)node;
            if (tempNode.getClassKind().equals(ASTClassKind.CLASS)) {
                searchFor = ICSearchConstants.CLASS;
            } else if (tempNode.getClassKind().equals(ASTClassKind.STRUCT)) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (tempNode.getClassKind().equals(ASTClassKind.UNION)) {
                searchFor = ICSearchConstants.UNION;
            }
        } else if (node instanceof IASTMethod) {
            searchFor = ICSearchConstants.METHOD;
        } else if (node instanceof IASTFunction) {
            searchFor = ICSearchConstants.FUNCTION;
        } else if (node instanceof IASTField) {
            searchFor = ICSearchConstants.FIELD;
        } else if (node instanceof IASTVariable) {
            searchFor = ICSearchConstants.VAR;
        } else if (node instanceof IASTEnumerationSpecifier) {
            searchFor = ICSearchConstants.ENUM;
        } else if (node instanceof IASTEnumerator) {
            searchFor = ICSearchConstants.FIELD;
        } else if (node instanceof IASTNamespaceDefinition) {
            searchFor = ICSearchConstants.NAMESPACE;
        }
        return searchFor;
    }

    private static class Storage {
        private IASTOffsetableNamedElement element;
        private IResource resource;
        private String fileName;

        Storage() {
        }

        public IASTOffsetableNamedElement getNamedElement() {
            return this.element;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final IResource getResource() {
            return this.resource;
        }

        public final void setResource(IResource resource) {
            this.resource = resource;
        }

        public final void setElement(IASTOffsetableNamedElement element) {
            this.element = element;
        }
    }
}

