/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.internal.ui.WorkingDirectoryBlock;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariableSelectionDialog;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CArgumentsTab
extends CLaunchConfigurationTab {
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    protected Button fArgumentVariablesButton;
    protected WorkingDirectoryBlock fWorkingDirectoryBlock = new WorkingDirectoryBlock();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.launch.launch_configuration_dialog_arguments_tab");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createArgumentComponent(comp, 1);
        this.createVerticalSpacer(comp, 1);
        this.fWorkingDirectoryBlock.createControl(comp);
    }

    protected void createArgumentComponent(Composite comp, int i) {
        Composite argsComp = new Composite(comp, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 1;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        argsComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = i;
        argsComp.setLayoutData((Object)gd);
        this.fPrgmArgumentsLabel = new Label(argsComp, 0);
        this.fPrgmArgumentsLabel.setText(LaunchMessages.getString("CArgumentsTab.C/C++_Program_Arguments"));
        this.fPrgmArgumentsText = new Text(argsComp, 2626);
        gd = new GridData(768);
        gd.heightHint = 40;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fArgumentVariablesButton = this.createPushButton(argsComp, LaunchMessages.getString("CArgumentsTab.Variables"), null);
        gd = new GridData(128);
        this.fArgumentVariablesButton.setLayoutData((Object)gd);
        this.fArgumentVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CArgumentsTab.this.handleVariablesButtonSelected(CArgumentsTab.this.fPrgmArgumentsText);
            }
        });
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.append(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        config.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", ""));
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchMessages.getFormattedString("Launch.common.Exception_occurred_reading_configuration_EXCEPTION", e.getStatus().getMessage()));
            LaunchUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", this.getAttributeValueFrom(this.fPrgmArgumentsText));
        this.fWorkingDirectoryBlock.performApply(configuration);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return LaunchMessages.getString("CArgumentsTab.Arguments");
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_ARGUMENTS_TAB);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }
}

