/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.model;

import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public abstract class AbstractProblemLocation
implements IProblemLocation {
    protected IResource file;
    protected int line;
    protected int posStart;
    protected int posEnd;
    protected Object extra;

    protected AbstractProblemLocation(IFile file, int line) {
        this((IResource)file, line);
    }

    protected AbstractProblemLocation(IResource file, int line) {
        this.file = file;
        this.line = line;
        this.posStart = -1;
        this.posEnd = -1;
    }

    protected AbstractProblemLocation(IFile file, int startChar, int endChar) {
        this((IResource)file, startChar, endChar);
    }

    protected AbstractProblemLocation(IResource file, int startChar, int endChar) {
        this.file = file;
        this.line = -1;
        this.posStart = startChar;
        this.posEnd = endChar;
    }

    public Object getData() {
        return this.extra;
    }

    public void setData(Object data) {
        this.extra = data;
    }

    public IResource getFile() {
        return this.file;
    }

    public IResource getResource() {
        return this.file;
    }

    public int getLineNumber() {
        return this.getStartingLineNumber();
    }

    public int getStartingLineNumber() {
        return this.line;
    }

    public int getStartingChar() {
        return this.posStart;
    }

    public int getEndingChar() {
        return this.posEnd;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.extra == null ? 0 : this.extra.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + this.line;
        result = 31 * result + this.posEnd;
        result = 31 * result + this.posStart;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractProblemLocation)) {
            return false;
        }
        AbstractProblemLocation other = (AbstractProblemLocation)obj;
        if (this.line != other.line) {
            return false;
        }
        if (this.posEnd != other.posEnd) {
            return false;
        }
        if (this.posStart != other.posStart) {
            return false;
        }
        if (this.extra == null ? other.extra != null : !this.extra.equals(other.extra)) {
            return false;
        }
        return !(this.file == null ? other.file != null : !this.file.equals((Object)other.file));
    }
}

