/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.codan.core.param.FileScopeProblemPreference;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.dialogs.ExclusionInclusionEntryDialog;
import org.eclipse.cdt.codan.internal.ui.widgets.BasicElementLabels;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FileScopePreferencePage
extends PreferencePage {
    private ListDialogField fInclusionPatternList;
    private ListDialogField fExclusionPatternList;
    private FileScopeProblemPreference fCurrElement;
    private IProject fCurrProject;
    private IContainer fCurrSourceFolder;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;

    public FileScopePreferencePage(FileScopeProblemPreference entryToEdit) {
        this.setTitle(CodanUIMessages.ExclusionInclusionDialog_title);
        this.setDescription(CodanUIMessages.ExclusionInclusionDialog_description2);
        this.fCurrElement = entryToEdit;
        this.fCurrProject = entryToEdit.getProject();
        IWorkspaceRoot root = this.fCurrProject != null ? this.fCurrProject.getWorkspace().getRoot() : ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(entryToEdit.getPath());
        if (res instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        if (res == null) {
            this.fCurrSourceFolder = root;
        }
        String excLabel = CodanUIMessages.ExclusionInclusionDialog_exclusion_pattern_label;
        String[] stringArray = new String[5];
        stringArray[0] = CodanUIMessages.ExclusionInclusionDialog_exclusion_pattern_add;
        stringArray[1] = CodanUIMessages.ExclusionInclusionDialog_exclusion_pattern_add_multiple;
        stringArray[2] = CodanUIMessages.ExclusionInclusionDialog_exclusion_pattern_edit;
        stringArray[4] = CodanUIMessages.ExclusionInclusionDialog_exclusion_pattern_remove;
        String[] excButtonLabels = stringArray;
        String incLabel = CodanUIMessages.ExclusionInclusionDialog_inclusion_pattern_label;
        String[] stringArray2 = new String[5];
        stringArray2[0] = CodanUIMessages.ExclusionInclusionDialog_inclusion_pattern_add;
        stringArray2[1] = CodanUIMessages.ExclusionInclusionDialog_inclusion_pattern_add_multiple;
        stringArray2[2] = CodanUIMessages.ExclusionInclusionDialog_inclusion_pattern_edit;
        stringArray2[4] = CodanUIMessages.ExclusionInclusionDialog_inclusion_pattern_remove;
        String[] incButtonLabels = stringArray2;
        this.fExclusionPatternList = this.createListContents(entryToEdit, "exclusion", excLabel, null, excButtonLabels);
        this.fInclusionPatternList = this.createListContents(entryToEdit, "inclusion", incLabel, null, incButtonLabels);
    }

    protected Control createContents(Composite parent) {
        Composite inner = new Composite(parent, 0);
        inner.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        this.fInclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fInclusionPatternList.getLabelControl(null), (int)2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fInclusionPatternList.getListControl(null), (boolean)true);
        this.fExclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternList.getLabelControl(null), (int)2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fExclusionPatternList.getListControl(null), (boolean)true);
        this.setControl((Control)inner);
        Dialog.applyDialogFont((Control)inner);
        return inner;
    }

    private ListDialogField createListContents(FileScopeProblemPreference entryToEdit, String key, String label, String descriptor, String[] buttonLabels) {
        ExclusionPatternAdapter adapter = new ExclusionPatternAdapter();
        ListDialogField patternList = new ListDialogField((IListAdapter)adapter, buttonLabels, (IBaseLabelProvider)new ExclusionInclusionLabelProvider(descriptor));
        patternList.setDialogFieldListener((IDialogFieldListener)adapter);
        patternList.setLabelText(label);
        patternList.enableButton(2, false);
        IPath[] pattern = entryToEdit.getAttribute(key);
        ArrayList<String> elements = new ArrayList<String>(pattern.length);
        int i = 0;
        while (i < pattern.length) {
            String patternName = pattern[i].toString();
            if (patternName.length() > 0) {
                elements.add(patternName);
            }
            ++i;
        }
        patternList.setElements(elements);
        patternList.selectFirstElement();
        patternList.enableButton(1, this.fCurrSourceFolder != null);
        patternList.setViewerComparator(new ViewerComparator());
        return patternList;
    }

    protected void doCustomButtonPressed(ListDialogField field, int index) {
        if (index == 0) {
            this.addEntry(field);
        } else if (index == 2) {
            this.editEntry(field);
        } else if (index == 1) {
            this.addMultipleEntries(field);
        } else if (index == 4) {
            field.removeElements(field.getSelectedElements());
        }
        this.updateStatus();
    }

    private void updateStatus() {
        this.fCurrElement.setAttribute("inclusion", this.getInclusionPattern());
        this.fCurrElement.setAttribute("exclusion", this.getExclusionPattern());
    }

    protected void doDoubleClicked(ListDialogField field) {
        this.editEntry(field);
        this.updateStatus();
    }

    protected void doSelectionChanged(ListDialogField field) {
        List selected = field.getSelectedElements();
        field.enableButton(2, this.canEdit(selected));
    }

    private boolean canEdit(List selected) {
        return selected.size() == 1;
    }

    private void editEntry(ListDialogField field) {
        List selElements = field.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        List existing = field.getElements();
        String entry = (String)selElements.get(0);
        ExclusionInclusionEntryDialog dialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(field), entry, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            field.replaceElement((Object)entry, (Object)dialog.getExclusionPattern());
        }
    }

    private boolean isExclusion(ListDialogField field) {
        return field == this.fExclusionPatternList;
    }

    private void addEntry(ListDialogField field) {
        List existing = field.getElements();
        ExclusionInclusionEntryDialog dialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(field), null, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            field.addElement((Object)dialog.getExclusionPattern());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    private IPath[] getPattern(ListDialogField field) {
        Object[] arr = field.getElements().toArray();
        Arrays.sort(arr);
        IPath[] res = new IPath[arr.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new Path((String)arr[i]);
            ++i;
        }
        return res;
    }

    public IPath[] getExclusionPattern() {
        return this.getPattern(this.fExclusionPatternList);
    }

    public IPath[] getInclusionPattern() {
        return this.getPattern(this.fInclusionPatternList);
    }

    protected void configureShell(Shell newShell) {
    }

    private void addMultipleEntries(ListDialogField field) {
        String message;
        String title;
        if (this.isExclusion(field)) {
            title = CodanUIMessages.ExclusionInclusionDialog_ChooseExclusionPattern_title;
            message = CodanUIMessages.ExclusionInclusionDialog_ChooseExclusionPattern_description;
        } else {
            title = CodanUIMessages.ExclusionInclusionDialog_ChooseInclusionPattern_title;
            message = CodanUIMessages.ExclusionInclusionDialog_ChooseInclusionPattern_description;
        }
        IPath[] res = ExclusionInclusionEntryDialog.chooseExclusionPattern(this.getShell(), this.fCurrSourceFolder, title, message, null, true);
        if (res != null) {
            int i = 0;
            while (i < res.length) {
                field.addElement((Object)res[i].toString());
                ++i;
            }
        }
    }

    public void noDefaultAndApplyButton() {
        super.noDefaultAndApplyButton();
    }

    private static class ExclusionInclusionLabelProvider
    extends LabelProvider {
        private Image fElementImage;

        public ExclusionInclusionLabelProvider(String descriptorPath) {
            if (descriptorPath != null) {
                CodanUIActivator.getImageDescriptor(descriptorPath);
            }
            this.fElementImage = null;
        }

        public Image getImage(Object element) {
            return this.fElementImage;
        }

        public String getText(Object element) {
            return BasicElementLabels.getFilePattern((String)element);
        }
    }

    private class ExclusionPatternAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ExclusionPatternAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            FileScopePreferencePage.this.doCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
            FileScopePreferencePage.this.doSelectionChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            FileScopePreferencePage.this.doDoubleClicked(field);
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }
}

