/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.tests.ast2.AST2SelectionParseTest;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.core.resources.IFile;

public class LRSelectionParseTest
extends AST2SelectionParseTest {
    public static TestSuite suite() {
        return new TestSuite(LRSelectionParseTest.class);
    }

    public LRSelectionParseTest() {
    }

    public LRSelectionParseTest(String name) {
        super(name);
    }

    protected IASTNode parse(String code, ParserLanguage lang, int offset, int length) throws ParserException {
        return this.parse(code, lang, false, false, offset, length);
    }

    protected IASTNode parse(IFile file, ParserLanguage lang, int offset, int length) throws ParserException {
        IASTTranslationUnit tu = this.parse(file, lang, false, false);
        return tu.selectNodeForLocation(tu.getFilePath(), offset, length);
    }

    protected IASTNode parse(String code, ParserLanguage lang, int offset, int length, boolean expectedToPass) throws ParserException {
        return this.parse(code, lang, false, expectedToPass, offset, length);
    }

    protected IASTNode parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems, int offset, int length) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckPreprocessorProblems(expectNoProblems);
        options.setCheckSyntaxProblems(expectNoProblems);
        IASTTranslationUnit tu = ParseHelper.parse(code, language, options);
        return tu.selectNodeForLocation(tu.getFilePath(), offset, length);
    }

    protected IASTTranslationUnit parse(IFile file, ParserLanguage lang, IScannerInfo scanInfo, boolean useGNUExtensions, boolean expectNoProblems) {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        String fileName = file.getLocation().toOSString();
        SavedCodeReaderFactory fileCreator = SavedCodeReaderFactory.getInstance();
        CodeReader reader = fileCreator.createCodeReaderForTranslationUnit(fileName);
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckPreprocessorProblems(expectNoProblems);
        options.setCheckSyntaxProblems(expectNoProblems);
        options.setCheckBindings(true);
        return ParseHelper.parse(reader, language, scanInfo, (ICodeReaderFactory)fileCreator, options);
    }

    protected IASTTranslationUnit parse(IFile file, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems) throws ParserException {
        return this.parse(file, lang, (IScannerInfo)new ScannerInfo(), useGNUExtensions, expectNoProblems);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }
}

