/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.TaskParserTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class LRTaskParserTest
extends TaskParserTest {
    public static TestSuite suite() {
        return new TestSuite(LRTaskParserTest.class);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems) throws ParserException {
        return this.parse(code, lang, useGNUExtensions, expectNoProblems, false);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems, boolean skipTrivialInitializers) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(expectNoProblems);
        options.setCheckPreprocessorProblems(expectNoProblems);
        options.setSkipTrivialInitializers(skipTrivialInitializers);
        return ParseHelper.parse(code, language, options);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }
}

