/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.xlc.tests;

import org.eclipse.cdt.core.lrparser.xlc.preferences.XlcLanguagePreferences;
import org.eclipse.cdt.core.lrparser.xlc.preferences.XlcPref;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.xlc.tests.XlcTestBase;

public class XlcExtensionsTest
extends XlcTestBase {
    public XlcExtensionsTest() {
    }

    public XlcExtensionsTest(String name) {
        super(name);
    }

    public void testHexadecimalFloatingPointLiterals() throws Exception {
        String code = "int test() {        \n\t 0x0A2B.0FDp+2f; \n\t 0X12D.p-44F;    \n\t 0xBACP+2L;      \n}\n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testFuncPredefinedIdentifier() {
        String code = "void test() {       \n     __func__;      \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testStringConcatenation() {
        String code = "void test() {       \n     \"hello \" \"there\";   \n     \"hello \" L\"there\";  \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testLongLong() {
        String code = "void test() {       \n     long long x;   \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testComplex() {
        String code = "void test() {       \n     float _Complex x;   \n     double _Complex y;   \n     long double _Complex z;   \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testBool() {
        String code = "_Bool f(int a, int b) { \n    return a==b; \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testTrailingCommaInEnum() {
        String code = "void test() {       \n     enum grain { oats, wheat, barley, corn, rice, };   \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testNonLValueArraySubscript() {
        String code = "struct trio{int a[3];};  \nstruct trio f();         \nfoo (int index)          \n{                        \n   return f().a[index];  \n}  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testStaticArrayIndices() {
        String code = "void test() {       \n     void foo1(int arr [static 10]);       \n     int i = 10;                           \n     void foo2(int arr [static const i]);  \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testFunctionLikeMacrosVariableArguments() {
        String code = "#define debug(...)   fprintf(stderr, __VA_ARGS__) \nint test() { \n    debug(\"flag\");  \n } \n";
        this.parse(code, (ILanguage)this.getCLanguage(), false);
    }

    public void testFunctionLikeMacrosEmptyArgument() {
        String code = "#define SUM(a,b,c) a + b + c \nint test() { \n   SUM(1,,3);  \n } \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testPredefinedMacroNamesC() {
        String code = "void test() {         \n    __DATE__;         \n    __FILE__;         \n    __LINE__;         \n    __STDC_HOSTED__;  \n    __STDC_VERSION__; \n    __TIME__;         \n}  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testPredefinedMacroNamesCpp() {
        String code = "void test() {      \n    __DATE__;      \n    __FILE__;      \n    __LINE__;      \n    __TIME__;      \n}  \n";
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testCompoundLiterals() {
        String code = "void test() {       \n     drawline((struct point){6,7});   \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), false);
    }

    public void testPragma() {
        String code = "void test() {       \n    _Pragma ( \"pack(full)\" )   \n }  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testStandardPragmas() {
        String code = "#pragma STDC FP_CONTRACT ON           \n#pragma STDC FENV_ACCESS OFF          \n#pragma STDC CX_LIMITED_RANGE DEFAULT \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testLineDirective() {
        String code = "#define LINE200 200 \n#line 100           \n#line LINE200       \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testRestrictC() {
        String code = "void foo(int n, int * restrict  a, int * __restrict b, int * __restrict__  c) {} ";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
    }

    public void testRestrictCPPOn() {
        String code = "void foo(int n, int * restrict  a, int * __restrict b, int * __restrict__  c) {} ";
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testRestrictCPPOff() {
        XlcLanguagePreferences.setWorkspacePreference((XlcPref)XlcPref.SUPPORT_RESTRICT_IN_CPP, (String)String.valueOf(false));
        String code = "void restrict(); \n void foo(int n, int * __restrict b, int * __restrict__  c) {} ";
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testUTFLiterals() {
        String code = "void test() { \n   u\"ucs characters \\u1234 and \\u8180 \"; \n   U\"ucs characters \\u1234 and \\u8180 \"; \n   U\"concatenation \\u1234 \"  u\"is allowed \\u8180 \"; \n   u'\\u1234'; \n   U'\\u1234'; \n }";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testFloatingPointTypes() {
        String code = "  _Decimal32 x = 22.2df; \n   _Decimal64 y = 33.3dd; \n   _Decimal128 z = 33.3dl; \n ";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVariableLengthArrays() {
        String code = "double maximum1(int n, int m, double a[n][m]);\ndouble maximum2(int n, int m, double a[*][*]);\ndouble maximum3(int n, int m, double a[ ][*]);\ndouble maximum4(int n, int m, double a[ ][m]);\n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testV11Attributes() {
        String code = "#define __inline__ __inline__ __attribute__((gnu_inline)) \nstatic int w() __attribute__ ((weakref (\"y\")));\nstatic int x() __attribute__ ((weak, weakref, alias (\"y\")));\nstatic int y() __attribute__ ((weakref));\nstatic int z() __attribute__ ((alias (\"y\"))); \nint foo() __attribute__((gnu_inline)); \nstatic inline __attribute__((gnu_inline)) int ins (int *a){ \n   (*a)++; \n} \ninline __attribute__((gnu_inline)) int inc (int *a){ \n   (*a)++; \n} ";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }
}

