/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.upc.tests;

import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.lrparser.BaseExtensibleLanguage;
import org.eclipse.cdt.core.dom.upc.UPCLanguage;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTForallStatement;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTKeywordExpression;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTSynchronizationStatement;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTTypeIdSizeofExpression;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTUnarySizeofExpression;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;

public class UPCLanguageExtensionTests
extends TestCase {
    public UPCLanguageExtensionTests() {
    }

    public UPCLanguageExtensionTests(String name) {
        super(name);
    }

    protected BaseExtensibleLanguage getLanguage() {
        return UPCLanguage.getDefault();
    }

    private IASTTranslationUnit parseAndCheckBindings(String code) {
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(true);
        options.setCheckPreprocessorProblems(true);
        options.setCheckBindings(true);
        return ParseHelper.parse((String)code, (ILanguage)this.getLanguage(), (ParseHelper.Options)options);
    }

    private IASTTranslationUnit parse(String code) {
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(true);
        options.setCheckPreprocessorProblems(true);
        options.setCheckBindings(false);
        return ParseHelper.parse((String)code, (ILanguage)this.getLanguage(), (ParseHelper.Options)options);
    }

    public void testUPCSharedDeclarations1() throws Exception {
        String code = "shared int a [100+THREADS];\nshared [] int b [THREADS];\nshared [90] int c [10];\nshared [*] int d [];\nrelaxed int x;strict int y;";
        IASTTranslationUnit tu = this.parseAndCheckBindings(code);
        IScope globalScope = tu.getScope();
        UPCLanguageExtensionTests.assertNotNull((Object)globalScope);
        IASTDeclaration[] declarations = tu.getDeclarations();
        UPCLanguageExtensionTests.assertNotNull((Object)declarations);
        UPCLanguageExtensionTests.assertEquals((int)6, (int)declarations.length);
        IASTSimpleDeclaration decl_a = (IASTSimpleDeclaration)declarations[0];
        IUPCASTSimpleDeclSpecifier declspec_a = (IUPCASTSimpleDeclSpecifier)decl_a.getDeclSpecifier();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)declspec_a.getReferenceType());
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declspec_a.getSharedQualifier());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)declspec_a.getType());
        UPCLanguageExtensionTests.assertNull((Object)declspec_a.getBlockSizeExpression());
        IASTDeclarator[] declarators = decl_a.getDeclarators();
        UPCLanguageExtensionTests.assertNotNull((Object)declarators);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarators.length);
        IASTArrayDeclarator declarator_a = (IASTArrayDeclarator)declarators[0];
        IASTName name_a = declarator_a.getName();
        UPCLanguageExtensionTests.assertEquals((String)"a", (String)name_a.toString());
        IASTArrayModifier[] array_modifiers = declarator_a.getArrayModifiers();
        UPCLanguageExtensionTests.assertNotNull((Object)array_modifiers);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)array_modifiers.length);
        IASTBinaryExpression expr = (IASTBinaryExpression)array_modifiers[0].getConstantExpression();
        IUPCASTKeywordExpression threads = (IUPCASTKeywordExpression)expr.getOperand2();
        UPCLanguageExtensionTests.assertEquals((int)1, (int)threads.getKeywordKind());
        IASTSimpleDeclaration decl_b = (IASTSimpleDeclaration)declarations[1];
        IUPCASTSimpleDeclSpecifier declspec_b = (IUPCASTSimpleDeclSpecifier)decl_b.getDeclSpecifier();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)declspec_b.getReferenceType());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)declspec_b.getSharedQualifier());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)declspec_b.getType());
        UPCLanguageExtensionTests.assertNull((Object)declspec_b.getBlockSizeExpression());
        declarators = decl_b.getDeclarators();
        UPCLanguageExtensionTests.assertNotNull((Object)declarators);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarators.length);
        IASTArrayDeclarator declarator_b = (IASTArrayDeclarator)declarators[0];
        IASTName name_b = declarator_b.getName();
        UPCLanguageExtensionTests.assertEquals((String)"b", (String)name_b.toString());
        array_modifiers = declarator_b.getArrayModifiers();
        UPCLanguageExtensionTests.assertNotNull((Object)array_modifiers);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)array_modifiers.length);
        threads = (IUPCASTKeywordExpression)array_modifiers[0].getConstantExpression();
        UPCLanguageExtensionTests.assertEquals((int)1, (int)threads.getKeywordKind());
        IASTSimpleDeclaration decl_c = (IASTSimpleDeclaration)declarations[2];
        IUPCASTSimpleDeclSpecifier declspec_c = (IUPCASTSimpleDeclSpecifier)decl_c.getDeclSpecifier();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)declspec_c.getReferenceType());
        UPCLanguageExtensionTests.assertEquals((int)4, (int)declspec_c.getSharedQualifier());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)declspec_c.getType());
        IASTLiteralExpression cfr_ignored_0 = (IASTLiteralExpression)declspec_c.getBlockSizeExpression();
        declarators = decl_c.getDeclarators();
        UPCLanguageExtensionTests.assertNotNull((Object)declarators);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarators.length);
        IASTArrayDeclarator declarator_c = (IASTArrayDeclarator)declarators[0];
        IASTName name_c = declarator_c.getName();
        UPCLanguageExtensionTests.assertEquals((String)"c", (String)name_c.toString());
        array_modifiers = declarator_c.getArrayModifiers();
        UPCLanguageExtensionTests.assertNotNull((Object)array_modifiers);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)array_modifiers.length);
        UPCLanguageExtensionTests.assertNotNull((Object)array_modifiers[0].getConstantExpression());
        IASTSimpleDeclaration decl_d = (IASTSimpleDeclaration)declarations[3];
        IUPCASTSimpleDeclSpecifier declspec_d = (IUPCASTSimpleDeclSpecifier)decl_d.getDeclSpecifier();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)declspec_d.getReferenceType());
        UPCLanguageExtensionTests.assertEquals((int)2, (int)declspec_d.getSharedQualifier());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)declspec_d.getType());
        UPCLanguageExtensionTests.assertNull((Object)declspec_d.getBlockSizeExpression());
        declarators = decl_d.getDeclarators();
        UPCLanguageExtensionTests.assertNotNull((Object)declarators);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarators.length);
        IASTArrayDeclarator declarator_d = (IASTArrayDeclarator)declarators[0];
        IASTName name_d = declarator_d.getName();
        UPCLanguageExtensionTests.assertEquals((String)"d", (String)name_d.toString());
        array_modifiers = declarator_d.getArrayModifiers();
        UPCLanguageExtensionTests.assertNotNull((Object)array_modifiers);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)array_modifiers.length);
        UPCLanguageExtensionTests.assertNull((Object)array_modifiers[0].getConstantExpression());
        IASTSimpleDeclaration decl_x = (IASTSimpleDeclaration)declarations[4];
        IUPCASTSimpleDeclSpecifier declspec_x = (IUPCASTSimpleDeclSpecifier)decl_x.getDeclSpecifier();
        UPCLanguageExtensionTests.assertEquals((int)2, (int)declspec_x.getReferenceType());
        IASTSimpleDeclaration decl_y = (IASTSimpleDeclaration)declarations[5];
        IUPCASTSimpleDeclSpecifier declspec_y = (IUPCASTSimpleDeclSpecifier)decl_y.getDeclSpecifier();
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declspec_y.getReferenceType());
        IVariable binding_a = (IVariable)name_a.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_a);
        UPCLanguageExtensionTests.assertEquals((Object)globalScope, (Object)binding_a.getScope());
        IVariable binding_b = (IVariable)name_a.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_b);
        UPCLanguageExtensionTests.assertEquals((Object)globalScope, (Object)binding_b.getScope());
        IVariable binding_c = (IVariable)name_a.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_c);
        UPCLanguageExtensionTests.assertEquals((Object)globalScope, (Object)binding_c.getScope());
        IVariable binding_d = (IVariable)name_a.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_d);
        UPCLanguageExtensionTests.assertEquals((Object)globalScope, (Object)binding_d.getScope());
    }

    public void testUPCSharedDeclarations2() throws Exception {
        String code = "int x = 10;shared [x] int a [];\n";
        IASTTranslationUnit tu = this.parseAndCheckBindings(code);
        IScope globalScope = tu.getScope();
        UPCLanguageExtensionTests.assertNotNull((Object)globalScope);
        IASTDeclaration[] declarations = tu.getDeclarations();
        UPCLanguageExtensionTests.assertNotNull((Object)declarations);
        UPCLanguageExtensionTests.assertEquals((int)2, (int)declarations.length);
        IASTSimpleDeclaration decl_x = (IASTSimpleDeclaration)declarations[0];
        IASTSimpleDeclaration decl_a = (IASTSimpleDeclaration)declarations[1];
        IUPCASTSimpleDeclSpecifier declspec_a = (IUPCASTSimpleDeclSpecifier)decl_a.getDeclSpecifier();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)declspec_a.getReferenceType());
        UPCLanguageExtensionTests.assertEquals((int)4, (int)declspec_a.getSharedQualifier());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)declspec_a.getType());
        IASTIdExpression expr_x = (IASTIdExpression)declspec_a.getBlockSizeExpression();
        IASTName name_x = expr_x.getName();
        IVariable binding_x = (IVariable)name_x.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_x);
        UPCLanguageExtensionTests.assertEquals((Object)decl_x.getDeclarators()[0].getName().resolveBinding(), (Object)binding_x);
    }

    public void testUPCForall1() throws Exception {
        String code = "int main() {\n    int i;\n    shared float *a;\n    upc_forall(i=0; i<N; i++; &a[i]) { \n        a[i] = 99; \n    } \n}\n";
        IASTTranslationUnit tu = this.parse(code);
        IScope globalScope = tu.getScope();
        UPCLanguageExtensionTests.assertNotNull((Object)globalScope);
        IASTDeclaration[] declarations = tu.getDeclarations();
        UPCLanguageExtensionTests.assertNotNull((Object)declarations);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarations.length);
        IASTFunctionDefinition main = (IASTFunctionDefinition)declarations[0];
        IASTStatement[] body = ((IASTCompoundStatement)main.getBody()).getStatements();
        UPCLanguageExtensionTests.assertEquals((int)3, (int)body.length);
        IASTSimpleDeclaration decl_i = (IASTSimpleDeclaration)((IASTDeclarationStatement)body[0]).getDeclaration();
        IVariable binding_i = (IVariable)decl_i.getDeclarators()[0].getName().resolveBinding();
        IASTSimpleDeclaration decl_a = (IASTSimpleDeclaration)((IASTDeclarationStatement)body[1]).getDeclaration();
        IVariable binding_a = (IVariable)decl_a.getDeclarators()[0].getName().resolveBinding();
        IUPCASTForallStatement forall = (IUPCASTForallStatement)body[2];
        IASTBinaryExpression expr1 = (IASTBinaryExpression)((IASTExpressionStatement)forall.getInitializerStatement()).getExpression();
        IASTName name_i_1 = ((IASTIdExpression)expr1.getOperand1()).getName();
        IASTBinaryExpression expr2 = (IASTBinaryExpression)forall.getConditionExpression();
        IASTName name_i_2 = ((IASTIdExpression)expr2.getOperand1()).getName();
        IASTUnaryExpression expr3 = (IASTUnaryExpression)forall.getIterationExpression();
        IASTName name_i_3 = ((IASTIdExpression)expr3.getOperand()).getName();
        IASTUnaryExpression expr4 = (IASTUnaryExpression)forall.getAffinityExpresiion();
        IASTName name_i_4 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr4.getOperand()).getSubscriptExpression()).getName();
        IASTName name_a_1 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr4.getOperand()).getArrayExpression()).getName();
        IASTBinaryExpression expr5 = (IASTBinaryExpression)((IASTExpressionStatement)((IASTCompoundStatement)forall.getBody()).getStatements()[0]).getExpression();
        IASTName name_i_5 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr5.getOperand1()).getSubscriptExpression()).getName();
        IASTName name_a_2 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr5.getOperand1()).getArrayExpression()).getName();
        IVariable binding_i_1 = (IVariable)name_i_1.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_1);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_1);
        IVariable binding_i_2 = (IVariable)name_i_2.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_2);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_2);
        IVariable binding_i_3 = (IVariable)name_i_3.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_3);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_3);
        IVariable binding_i_4 = (IVariable)name_i_4.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_4);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_4);
        IVariable binding_i_5 = (IVariable)name_i_5.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_5);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_5);
        IVariable binding_a_1 = (IVariable)name_a_1.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_a_1);
        UPCLanguageExtensionTests.assertEquals((Object)binding_a, (Object)binding_a_1);
        IVariable binding_a_2 = (IVariable)name_a_2.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_a_2);
        UPCLanguageExtensionTests.assertEquals((Object)binding_a, (Object)binding_a_2);
    }

    public void testUPCForall2() throws Exception {
        String code = "int main() {\n    shared float *a;\n    upc_forall(int i=0; i<N; i++; &a[i]) { \n        a[i] = 99; \n    } \n}\n";
        IASTTranslationUnit tu = this.parse(code);
        IScope globalScope = tu.getScope();
        UPCLanguageExtensionTests.assertNotNull((Object)globalScope);
        IASTDeclaration[] declarations = tu.getDeclarations();
        UPCLanguageExtensionTests.assertNotNull((Object)declarations);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarations.length);
        IASTFunctionDefinition main = (IASTFunctionDefinition)declarations[0];
        IASTStatement[] body = ((IASTCompoundStatement)main.getBody()).getStatements();
        UPCLanguageExtensionTests.assertEquals((int)2, (int)body.length);
        IASTSimpleDeclaration decl_a = (IASTSimpleDeclaration)((IASTDeclarationStatement)body[0]).getDeclaration();
        IVariable binding_a = (IVariable)decl_a.getDeclarators()[0].getName().resolveBinding();
        IUPCASTForallStatement forall = (IUPCASTForallStatement)body[1];
        IASTSimpleDeclaration decl_i = (IASTSimpleDeclaration)((IASTDeclarationStatement)forall.getInitializerStatement()).getDeclaration();
        IVariable binding_i = (IVariable)decl_i.getDeclarators()[0].getName().resolveBinding();
        IASTBinaryExpression expr2 = (IASTBinaryExpression)forall.getConditionExpression();
        IASTName name_i_2 = ((IASTIdExpression)expr2.getOperand1()).getName();
        IASTUnaryExpression expr3 = (IASTUnaryExpression)forall.getIterationExpression();
        IASTName name_i_3 = ((IASTIdExpression)expr3.getOperand()).getName();
        IASTUnaryExpression expr4 = (IASTUnaryExpression)forall.getAffinityExpresiion();
        IASTName name_i_4 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr4.getOperand()).getSubscriptExpression()).getName();
        IASTName name_a_1 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr4.getOperand()).getArrayExpression()).getName();
        IASTBinaryExpression expr5 = (IASTBinaryExpression)((IASTExpressionStatement)((IASTCompoundStatement)forall.getBody()).getStatements()[0]).getExpression();
        IASTName name_i_5 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr5.getOperand1()).getSubscriptExpression()).getName();
        IASTName name_a_2 = ((IASTIdExpression)((IASTArraySubscriptExpression)expr5.getOperand1()).getArrayExpression()).getName();
        IVariable binding_i_2 = (IVariable)name_i_2.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_2);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_2);
        IVariable binding_i_3 = (IVariable)name_i_3.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_3);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_3);
        IVariable binding_i_4 = (IVariable)name_i_4.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_4);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_4);
        IVariable binding_i_5 = (IVariable)name_i_5.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_i_5);
        UPCLanguageExtensionTests.assertEquals((Object)binding_i, (Object)binding_i_5);
        IVariable binding_a_1 = (IVariable)name_a_1.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_a_1);
        UPCLanguageExtensionTests.assertEquals((Object)binding_a, (Object)binding_a_1);
        IVariable binding_a_2 = (IVariable)name_a_2.resolveBinding();
        UPCLanguageExtensionTests.assertNotNull((Object)binding_a_2);
        UPCLanguageExtensionTests.assertEquals((Object)binding_a, (Object)binding_a_2);
    }

    public void testUPCForall3() throws Exception {
        String code = "int main() {\n    upc_forall(int i=0; i<N; i++; continue) { \n    } \n}\n";
        IASTTranslationUnit tu = this.parse(code);
        IASTDeclaration[] declarations = tu.getDeclarations();
        UPCLanguageExtensionTests.assertNotNull((Object)declarations);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarations.length);
        IASTFunctionDefinition main = (IASTFunctionDefinition)declarations[0];
        IASTStatement[] body = ((IASTCompoundStatement)main.getBody()).getStatements();
        UPCLanguageExtensionTests.assertEquals((int)1, (int)body.length);
        IUPCASTForallStatement forall = (IUPCASTForallStatement)body[0];
        UPCLanguageExtensionTests.assertTrue((boolean)forall.isAffinityContinue());
        UPCLanguageExtensionTests.assertNull((Object)forall.getAffinityExpresiion());
    }

    public void testUPCSynchronizationStatment() throws Exception {
        String code = "int main() {\n    upc_notify 1;\n    upc_notify;\n    upc_wait 1;\n    upc_wait;\n    upc_barrier 1;\n    upc_barrier;\n    upc_fence;\n}\n";
        IASTTranslationUnit tu = this.parse(code);
        IASTDeclaration[] declarations = tu.getDeclarations();
        UPCLanguageExtensionTests.assertNotNull((Object)declarations);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarations.length);
        IASTFunctionDefinition main = (IASTFunctionDefinition)declarations[0];
        IASTStatement[] body = ((IASTCompoundStatement)main.getBody()).getStatements();
        UPCLanguageExtensionTests.assertEquals((int)7, (int)body.length);
        IUPCASTSynchronizationStatement stat = (IUPCASTSynchronizationStatement)body[0];
        UPCLanguageExtensionTests.assertEquals((int)stat.getStatementKind(), (int)1);
        UPCLanguageExtensionTests.assertNotNull((Object)stat.getBarrierExpression());
        stat = (IUPCASTSynchronizationStatement)body[1];
        UPCLanguageExtensionTests.assertEquals((int)stat.getStatementKind(), (int)1);
        UPCLanguageExtensionTests.assertNull((Object)stat.getBarrierExpression());
        stat = (IUPCASTSynchronizationStatement)body[2];
        UPCLanguageExtensionTests.assertEquals((int)stat.getStatementKind(), (int)2);
        UPCLanguageExtensionTests.assertNotNull((Object)stat.getBarrierExpression());
        stat = (IUPCASTSynchronizationStatement)body[3];
        UPCLanguageExtensionTests.assertEquals((int)stat.getStatementKind(), (int)2);
        UPCLanguageExtensionTests.assertNull((Object)stat.getBarrierExpression());
        stat = (IUPCASTSynchronizationStatement)body[4];
        UPCLanguageExtensionTests.assertEquals((int)stat.getStatementKind(), (int)3);
        UPCLanguageExtensionTests.assertNotNull((Object)stat.getBarrierExpression());
        stat = (IUPCASTSynchronizationStatement)body[5];
        UPCLanguageExtensionTests.assertEquals((int)stat.getStatementKind(), (int)3);
        UPCLanguageExtensionTests.assertNull((Object)stat.getBarrierExpression());
        stat = (IUPCASTSynchronizationStatement)body[6];
        UPCLanguageExtensionTests.assertEquals((int)stat.getStatementKind(), (int)4);
        UPCLanguageExtensionTests.assertNull((Object)stat.getBarrierExpression());
    }

    public void testUPCSizeofExpressions() throws Exception {
        String code = "int main() {\n    sizeof(int); \n    sizeof x; \n    upc_localsizeof(int); \n    upc_localsizeof x; \n    upc_blocksizeof(int); \n    upc_blocksizeof x; \n    upc_elemsizeof(int); \n    upc_elemsizeof x; \n}\n";
        IASTTranslationUnit tu = this.parse(code);
        IASTDeclaration[] declarations = tu.getDeclarations();
        UPCLanguageExtensionTests.assertNotNull((Object)declarations);
        UPCLanguageExtensionTests.assertEquals((int)1, (int)declarations.length);
        IASTFunctionDefinition main = (IASTFunctionDefinition)declarations[0];
        IASTStatement[] body = ((IASTCompoundStatement)main.getBody()).getStatements();
        UPCLanguageExtensionTests.assertEquals((int)8, (int)body.length);
        IASTTypeIdExpression cfr_ignored_0 = (IASTTypeIdExpression)((IASTExpressionStatement)body[0]).getExpression();
        IASTUnaryExpression cexpr = (IASTUnaryExpression)((IASTExpressionStatement)body[1]).getExpression();
        UPCLanguageExtensionTests.assertEquals((int)8, (int)cexpr.getOperator());
        IUPCASTTypeIdSizeofExpression idexpr = (IUPCASTTypeIdSizeofExpression)((IASTExpressionStatement)body[2]).getExpression();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)idexpr.getOperator());
        UPCLanguageExtensionTests.assertEquals((int)1, (int)idexpr.getUPCSizeofOperator());
        IUPCASTUnarySizeofExpression expr = (IUPCASTUnarySizeofExpression)((IASTExpressionStatement)body[3]).getExpression();
        UPCLanguageExtensionTests.assertEquals((int)8, (int)expr.getOperator());
        UPCLanguageExtensionTests.assertEquals((int)1, (int)expr.getUPCSizeofOperator());
        idexpr = (IUPCASTTypeIdSizeofExpression)((IASTExpressionStatement)body[4]).getExpression();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)idexpr.getOperator());
        UPCLanguageExtensionTests.assertEquals((int)2, (int)idexpr.getUPCSizeofOperator());
        expr = (IUPCASTUnarySizeofExpression)((IASTExpressionStatement)body[5]).getExpression();
        UPCLanguageExtensionTests.assertEquals((int)8, (int)expr.getOperator());
        UPCLanguageExtensionTests.assertEquals((int)2, (int)expr.getUPCSizeofOperator());
        idexpr = (IUPCASTTypeIdSizeofExpression)((IASTExpressionStatement)body[6]).getExpression();
        UPCLanguageExtensionTests.assertEquals((int)0, (int)idexpr.getOperator());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)idexpr.getUPCSizeofOperator());
        expr = (IUPCASTUnarySizeofExpression)((IASTExpressionStatement)body[7]).getExpression();
        UPCLanguageExtensionTests.assertEquals((int)8, (int)expr.getOperator());
        UPCLanguageExtensionTests.assertEquals((int)3, (int)expr.getUPCSizeofOperator());
    }

    public void testUPCSizeofExpressionsDisambiguate() throws Exception {
        String code = "int foo() {\ttypedef int t;   int x;   upc_blocksizeof(t);   upc_blocksizeof(x);}";
        IASTTranslationUnit tu = this.parse(code);
        IASTDeclaration[] declarations = tu.getDeclarations();
        IASTFunctionDefinition main = (IASTFunctionDefinition)declarations[0];
        IASTStatement[] body = ((IASTCompoundStatement)main.getBody()).getStatements();
        UPCLanguageExtensionTests.assertTrue((boolean)(((IASTExpressionStatement)body[2]).getExpression() instanceof IUPCASTTypeIdSizeofExpression));
        UPCLanguageExtensionTests.assertTrue((boolean)(((IASTExpressionStatement)body[3]).getExpression() instanceof IUPCASTUnarySizeofExpression));
    }
}

