/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.AbstractEntryStorage;
import org.eclipse.cdt.core.settings.model.util.SettingsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserAndDiscoveredEntryStorage
extends AbstractEntryStorage {
    private static final int USER_ENTRIES_LEVEL = 0;
    private static final int DISCOVERY_ENTRIES_LEVEL = 1;

    public UserAndDiscoveredEntryStorage(int kind) {
        super(kind);
    }

    @Override
    protected SettingsSet createEmptySettings() {
        SettingsSet settings = new SettingsSet(2);
        SettingsSet.SettingLevel[] levels = settings.getLevels();
        levels[0].setFlagsToClear(3);
        levels[0].setFlagsToSet(0);
        levels[0].setReadOnly(false);
        levels[0].setOverrideSupported(false);
        boolean override = this.canDisableDiscoveredEntries();
        int readOnlyFlag = override ? 0 : 2;
        levels[1].setFlagsToClear(0);
        levels[1].setFlagsToSet(readOnlyFlag | 1 | 0x10);
        levels[1].setReadOnly(true);
        levels[1].setOverrideSupported(override);
        return settings;
    }

    @Override
    protected void obtainEntriesFromLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                this.setUserEntries(level != null ? level.getEntries() : null);
                break;
            }
            case 1: {
                if (level != null) {
                    Set<String> set = level.getOverrideSet();
                    this.setDisabledDiscoveredNames(set);
                    break;
                }
                this.setDisabledDiscoveredNames(null);
            }
        }
    }

    @Override
    protected void putEntriesToLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                level.addEntries(this.getUserEntries());
                break;
            }
            case 1: {
                HashSet<String> set = new HashSet<String>();
                ICLanguageSettingEntry[] entries = this.getDiscoveredEntries(set);
                level.addEntries(entries);
                if (set.size() == 0) break;
                level.fOverrideSet = set;
            }
        }
    }

    protected boolean canDisableDiscoveredEntries() {
        return false;
    }

    protected abstract void setUserEntries(ICLanguageSettingEntry[] var1);

    protected abstract ICLanguageSettingEntry[] getUserEntries();

    protected abstract void setDisabledDiscoveredNames(Set<String> var1);

    protected abstract ICLanguageSettingEntry[] getDiscoveredEntries(Set<String> var1);
}

