/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCopyLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeWriter {
    protected Scribe scribe;
    protected ASTVisitor visitor;
    protected NodeCommentMap commentMap;
    protected static final String COMMA_SPACE = ", ";
    protected static final String EQUALS = " = ";
    protected static final String RESTRICT = "restrict ";
    protected static final String TYPENAME = "typename ";
    protected static final String PUBLIC = "public";
    protected static final String PRIVATE = "private";
    protected static final String PROTECTED = "protected";
    protected static final String CONST = "const";
    protected static final String VOLATILE = "volatile";
    protected static final String INLINE = "inline ";
    protected static final String EXTERN = "extern ";
    protected static final String STATIC = "static ";
    protected static final String THROW = "throw ";
    protected static final String SPACE_COLON_SPACE = " : ";
    protected static final String TEMPLATE = "template ";
    protected static final String DOUBLE = "double";
    protected static final String FLOAT = "float";
    protected static final String INT = "int";
    protected static final String CHAR = "char";
    protected static final String VOID = "void";
    protected static final String WCHAR_T = "wchar_t";
    protected static final String CPP_BOOL = "bool";
    protected static final String LONG = "long";
    protected static final String SHORT = "short";
    protected static final String UNSIGNED = "unsigned";
    protected static final String SIGNED = "signed";
    protected static final String CLASS_SPACE = "class ";
    protected static final String VAR_ARGS = "...";
    protected static final String COLON_COLON = "::";
    protected static final String COLON_SPACE = ": ";

    public NodeWriter(Scribe scribe, ASTVisitor visitor, NodeCommentMap commentMap) {
        this.scribe = scribe;
        this.visitor = visitor;
        this.commentMap = commentMap;
    }

    protected void writeNodeList(IASTNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept(this.visitor);
            if (i + 1 < nodes.length) {
                this.scribe.print(COMMA_SPACE);
            }
            ++i;
        }
    }

    protected void visitNodeIfNotNull(IASTNode node) {
        if (node != null) {
            node.accept(this.visitor);
        }
    }

    protected void writeTrailingComments(IASTNode node) {
        this.writeTrailingComments(node, true);
    }

    protected boolean hasTrailingComments(IASTNode node) {
        return this.getTrailingComments(node).size() > 0;
    }

    private ArrayList<IASTComment> getTrailingComments(IASTNode node) {
        ArrayList<IASTComment> trailingComments = this.commentMap.getTrailingCommentsForNode(node);
        IASTNodeLocation[] locs = node.getNodeLocations();
        if (locs != null && locs.length > 0 && locs[0] instanceof IASTCopyLocation) {
            IASTCopyLocation loc = (IASTCopyLocation)locs[0];
            trailingComments.addAll(this.commentMap.getTrailingCommentsForNode(loc.getOriginalNode()));
        }
        return trailingComments;
    }

    protected void writeTrailingComments(IASTNode node, boolean newLine) {
        for (IASTComment comment : this.getTrailingComments(node)) {
            this.scribe.printSpace();
            this.scribe.print(comment.getComment());
            if (!newLine) continue;
            this.scribe.newLine();
        }
    }

    protected boolean hasFreestandingComments(IASTNode node) {
        return this.getFreestandingComments(node).size() > 0;
    }

    private ArrayList<IASTComment> getFreestandingComments(IASTNode node) {
        ArrayList<IASTComment> freestandingComments = this.commentMap.getFreestandingCommentsForNode(node);
        IASTNodeLocation[] locs = node.getNodeLocations();
        if (locs != null && locs.length > 0 && locs[0] instanceof IASTCopyLocation) {
            IASTCopyLocation loc = (IASTCopyLocation)locs[0];
            freestandingComments.addAll(this.commentMap.getFreestandingCommentsForNode(loc.getOriginalNode()));
        }
        return freestandingComments;
    }

    protected void writeFreeStandingComments(IASTNode node) {
        for (IASTComment comment : this.getFreestandingComments(node)) {
            this.scribe.print(comment.getComment());
            this.scribe.newLine();
        }
    }
}

