/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PDOMCPPNamespace
extends PDOMCPPBinding
implements ICPPNamespace,
ICPPNamespaceScope,
IIndexScope {
    private static final int INDEX_OFFSET = 28;
    private static final int FIRST_NAMESPACE_CHILD_OFFSET = 32;
    private static final int NEXT_NAMESPACE_SIBBLING_OFFSET = 36;
    private static final int FLAG_OFFSET = 40;
    protected static final int RECORD_SIZE = 41;
    private static int INLINE_FLAG = 1;
    private int fFlag = -1;
    private volatile ICPPNamespaceScope[] fInlineNamespaces;

    public PDOMCPPNamespace(PDOMLinkage linkage, PDOMNode parent, ICPPNamespace namespace) throws CoreException {
        super(linkage, parent, namespace.getNameCharArray());
        this.updateFlag(namespace);
    }

    public PDOMCPPNamespace(PDOMLinkage linkage, long record) throws CoreException {
        super(linkage, record);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        this.updateFlag((ICPPNamespace)newBinding);
    }

    private void updateFlag(ICPPNamespace namespace) throws CoreException {
        int flag = 0;
        if (namespace.isInline()) {
            flag |= INLINE_FLAG;
        }
        this.getDB().putByte(this.record + 40L, (byte)flag);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eNamespace;
    }

    @Override
    protected int getRecordSize() {
        return 41;
    }

    @Override
    public int getNodeType() {
        return 11;
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.getDB(), this.record + 28L, ((PDOMLinkage)this.getLinkage()).getIndexComparator());
    }

    @Override
    public void accept(final IPDOMVisitor visitor) throws CoreException {
        if (visitor instanceof IBTreeVisitor) {
            this.getIndex().accept((IBTreeVisitor)((Object)visitor));
        } else {
            this.getIndex().accept(new IBTreeVisitor(){

                public int compare(long record) throws CoreException {
                    return 0;
                }

                public boolean visit(long record) throws CoreException {
                    PDOMBinding binding = ((PDOMLinkage)PDOMCPPNamespace.this.getLinkage()).getBinding(record);
                    if (binding != null) {
                        if (visitor.visit(binding)) {
                            binding.accept(visitor);
                        }
                        visitor.leave(binding);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void addChild(PDOMNode child) throws CoreException {
        long childRec = child.getRecord();
        this.getIndex().insert(childRec);
        if (child instanceof PDOMCPPNamespace) {
            ((PDOMCPPNamespace)child).addToList(this.record + 32L);
        }
    }

    public void addToList(long listRecord) throws CoreException {
        Database db = this.getDB();
        long nextRec = db.getRecPtr(listRecord);
        db.putRecPtr(this.record + 36L, nextRec);
        db.putRecPtr(listRecord, this.record);
    }

    @Override
    public ICPPNamespaceScope getNamespaceScope() {
        return this;
    }

    @Override
    public ICPPUsingDirective[] getUsingDirectives() {
        return new ICPPUsingDirective[0];
    }

    @Override
    public IBinding[] find(String name) {
        try {
            BindingCollector visitor = new BindingCollector((PDOMLinkage)this.getLinkage(), name.toCharArray(), IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE, false, false, true);
            this.getIndex().accept(visitor);
            return visitor.getBindings();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IIndexBinding.EMPTY_INDEX_BINDING_ARRAY;
        }
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        try {
            Object[] bindings = this.getBindingsViaCache(name.getLookupKey());
            if (fileSet != null) {
                bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
            }
            return CPPSemantics.resolveAmbiguities(name, bindings);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        Object[] result = null;
        try {
            if (!prefixLookup) {
                result = this.getBindingsViaCache(name.getLookupKey());
            } else {
                BindingCollector visitor = new BindingCollector((PDOMLinkage)this.getLinkage(), name.getLookupKey(), IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE, prefixLookup, prefixLookup, !prefixLookup);
                this.getIndex().accept(visitor);
                result = visitor.getBindings();
            }
            if (fileSet != null) {
                result = fileSet.filterFileLocalBindings((IBinding[])result);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    private IBinding[] getBindingsViaCache(char[] name) throws CoreException {
        String key;
        PDOM pdom = this.getPDOM();
        IBinding[] result = (IBinding[])pdom.getCachedResult(key = pdom.createKeyForCache(this.record, name));
        if (result != null) {
            return result;
        }
        BindingCollector visitor = new BindingCollector((PDOMLinkage)this.getLinkage(), name, IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE, false, false, true);
        this.getIndex().accept(visitor);
        result = visitor.getBindings();
        pdom.putCachedResult(key, result);
        return result;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public IBinding[] getMemberBindings() {
        IBinding[] result = null;
        final ArrayList preresult = new ArrayList();
        try {
            this.getIndex().accept(new IBTreeVisitor(){

                public int compare(long record) throws CoreException {
                    return 0;
                }

                public boolean visit(long record) throws CoreException {
                    preresult.add(((PDOMLinkage)PDOMCPPNamespace.this.getLinkage()).getNode(record));
                    return true;
                }
            });
            result = preresult.toArray(new IBinding[preresult.size()]);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return result;
    }

    @Override
    public void addUsingDirective(ICPPUsingDirective directive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIndexBinding getScopeBinding() {
        return this;
    }

    @Override
    protected String toStringBase() {
        String[] names = CPPVisitor.getQualifiedName(this);
        if (names.length == 0) {
            return "<unnamed namespace>";
        }
        return ASTStringUtil.join(names, String.valueOf(Keywords.cpCOLONCOLON));
    }

    @Override
    public ICPPNamespaceScope[] getInlineNamespaces() {
        if (this.fInlineNamespaces == null) {
            List<PDOMCPPNamespace> nslist = PDOMCPPNamespace.collectInlineNamespaces(this.getDB(), (PDOMLinkage)this.getLinkage(), this.record + 32L);
            this.fInlineNamespaces = nslist == null ? new PDOMCPPNamespace[0] : (ICPPNamespaceScope[])nslist.toArray(new PDOMCPPNamespace[nslist.size()]);
        }
        return this.fInlineNamespaces;
    }

    public static List<PDOMCPPNamespace> collectInlineNamespaces(Database db, PDOMLinkage linkage, long listRecord) {
        ArrayList<PDOMCPPNamespace> nslist = null;
        try {
            long rec = db.getRecPtr(listRecord);
            while (rec != 0L) {
                PDOMCPPNamespace ns = new PDOMCPPNamespace(linkage, rec);
                if (ns.isInline()) {
                    if (nslist == null) {
                        nslist = new ArrayList<PDOMCPPNamespace>();
                    }
                    nslist.add(ns);
                }
                rec = db.getRecPtr(rec + 36L);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return nslist;
    }

    @Override
    public boolean isInline() {
        if (this.fFlag == -1) {
            try {
                this.fFlag = this.getDB().getByte(this.record + 40L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fFlag = 0;
            }
        }
        return (this.fFlag & INLINE_FLAG) != 0;
    }
}

