/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingPathEntry;
import org.eclipse.cdt.core.settings.model.ICMacroEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionScannerInfoProvider
implements IScannerInfoProvider,
ICProjectDescriptionListener {
    private IProject fProject;
    private ICProjectDescription fProjDes;
    private ICConfigurationDescription fCfgDes;
    private Map<String, IScannerInfo> fIdToLanguageSettingsMap = Collections.synchronizedMap(new HashMap());
    private String fCurrentFileDescriptionId;
    private IScannerInfo fCurrentFileScannerInfo;
    private static final ScannerInfo INEXISTENT_SCANNER_INFO = new ScannerInfo();
    private boolean fInited;

    DescriptionScannerInfoProvider(IProject project) {
        this.fProject = project;
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this, 5);
    }

    private void updateProjCfgInfo(ICProjectDescription des) {
        this.fInited = true;
        this.fProjDes = des;
        if (this.fProjDes != null) {
            this.fCfgDes = des.getDefaultSettingConfiguration();
        }
        this.fIdToLanguageSettingsMap.clear();
        this.fCurrentFileDescriptionId = null;
        this.fCurrentFileScannerInfo = null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public IScannerInfo getScannerInformation(IResource resource) {
        if (!this.fInited) {
            this.updateProjCfgInfo(CProjectDescriptionManager.getInstance().getProjectDescription(this.fProject, false));
        }
        if (this.fCfgDes == null) {
            return INEXISTENT_SCANNER_INFO;
        }
        ICLanguageSetting setting = null;
        ICResourceDescription rcDes = null;
        if (resource.getType() != 4) {
            IPath rcPath = resource.getProjectRelativePath();
            rcDes = this.fCfgDes.getResourceDescription(rcPath, false);
            if (rcDes.getType() == 8) {
                setting = ((ICFileDescription)rcDes).getLanguageSetting();
            } else if (resource.getType() == 1) {
                setting = ((ICFolderDescription)rcDes).getLanguageSettingForFile(rcPath.lastSegment());
            } else {
                ICLanguageSetting[] settings = ((ICFolderDescription)rcDes).getLanguageSettings();
                if (settings.length > 0) {
                    setting = settings[0];
                }
            }
        }
        return this.getScannerInfo(rcDes, setting);
    }

    private IScannerInfo getScannerInfo(ICResourceDescription rcDes, ICLanguageSetting ls) {
        IScannerInfo info;
        boolean useMap;
        String mapKey = ls != null ? ls.getId() : null;
        boolean bl = useMap = rcDes == null || rcDes.getType() == 4;
        if (useMap) {
            info = this.fIdToLanguageSettingsMap.get(mapKey);
        } else if (this.fCurrentFileScannerInfo != null && rcDes != null) {
            if (rcDes.getId().equals(this.fCurrentFileDescriptionId)) {
                info = this.fCurrentFileScannerInfo;
            } else {
                info = null;
                this.fCurrentFileScannerInfo = null;
                this.fCurrentFileDescriptionId = null;
            }
        } else {
            info = null;
        }
        if (info == null) {
            info = this.createScannerInfo(ls);
            if (useMap) {
                this.fIdToLanguageSettingsMap.put(mapKey, info);
            } else if (rcDes != null) {
                this.fCurrentFileScannerInfo = info;
                this.fCurrentFileDescriptionId = rcDes.getId();
            }
        }
        return info;
    }

    private static ICLanguageSettingPathEntry[] getPathEntries(ICLanguageSetting ls, int kind) {
        ICLanguageSettingEntry[] entries = ls.getResolvedSettingEntries(kind);
        ICLanguageSettingPathEntry[] pathEntries = new ICLanguageSettingPathEntry[entries.length];
        System.arraycopy(entries, 0, pathEntries, 0, entries.length);
        return pathEntries;
    }

    private static ICMacroEntry[] getMacroEntries(ICLanguageSetting ls) {
        ICLanguageSettingEntry[] entries = ls.getResolvedSettingEntries(4);
        ICMacroEntry[] macroEntries = new ICMacroEntry[entries.length];
        System.arraycopy(entries, 0, macroEntries, 0, entries.length);
        return macroEntries;
    }

    private IScannerInfo createProjectScannerInfo() {
        ICFolderDescription foDes = this.fCfgDes.getRootFolderDescription();
        ICLanguageSetting[] lSettings = foDes.getLanguageSettings();
        ICLanguageSettingPathEntry[] pathEntries = this.getPathEntries(lSettings, 1);
        String[] incs = this.getValues(pathEntries);
        pathEntries = this.getPathEntries(lSettings, 2);
        String[] incFiles = this.getValues(pathEntries);
        pathEntries = this.getPathEntries(lSettings, 8);
        String[] macroFiles = this.getValues(pathEntries);
        ICMacroEntry[] macroEntries = this.getMacroEntries(lSettings);
        Map<String, String> macrosMap = this.getValues(macroEntries);
        return new ExtendedScannerInfo(macrosMap, incs, macroFiles, incFiles);
    }

    private ICMacroEntry[] getMacroEntries(ICLanguageSetting[] settings) {
        LinkedHashSet<ICLanguageSettingEntry> set = this.getEntriesSet(4, settings);
        return set.toArray(new ICMacroEntry[set.size()]);
    }

    private ICLanguageSettingPathEntry[] getPathEntries(ICLanguageSetting[] settings, int kind) {
        LinkedHashSet<ICLanguageSettingEntry> set = this.getEntriesSet(kind, settings);
        return set.toArray(new ICLanguageSettingPathEntry[set.size()]);
    }

    private LinkedHashSet<ICLanguageSettingEntry> getEntriesSet(int kind, ICLanguageSetting[] settings) {
        LinkedHashSet<ICLanguageSettingEntry> set = new LinkedHashSet<ICLanguageSettingEntry>();
        ICLanguageSetting[] iCLanguageSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting setting = iCLanguageSettingArray[n2];
            ICLanguageSettingEntry[] langEntries = setting.getResolvedSettingEntries(kind);
            if (langEntries.length != 0) {
                set.addAll(Arrays.asList(langEntries));
            }
            ++n2;
        }
        return set;
    }

    private IScannerInfo createScannerInfo(ICLanguageSetting ls) {
        if (ls == null) {
            return this.createProjectScannerInfo();
        }
        ICLanguageSettingPathEntry[] pathEntries = DescriptionScannerInfoProvider.getPathEntries(ls, 1);
        String[] incs = this.getValues(pathEntries);
        pathEntries = DescriptionScannerInfoProvider.getPathEntries(ls, 2);
        String[] incFiles = this.getValues(pathEntries);
        pathEntries = DescriptionScannerInfoProvider.getPathEntries(ls, 8);
        String[] macroFiles = this.getValues(pathEntries);
        ICMacroEntry[] macroEntries = DescriptionScannerInfoProvider.getMacroEntries(ls);
        Map<String, String> macrosMap = this.getValues(macroEntries);
        return new ExtendedScannerInfo(macrosMap, incs, macroFiles, incFiles);
    }

    private Map<String, String> getValues(ICMacroEntry[] macroEntries) {
        HashMap<String, String> macrosMap = new HashMap<String, String>(macroEntries.length);
        ICMacroEntry[] iCMacroEntryArray = macroEntries;
        int n = macroEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICMacroEntry macroEntry = iCMacroEntryArray[n2];
            String name = macroEntry.getName();
            String value = macroEntry.getValue();
            macrosMap.put(name, value);
            ++n2;
        }
        return macrosMap;
    }

    private String[] getValues(ICLanguageSettingPathEntry[] pathEntries) {
        String[] values = new String[pathEntries.length];
        int num = 0;
        ICLanguageSettingPathEntry[] iCLanguageSettingPathEntryArray = pathEntries;
        int n = pathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSettingPathEntry pathEntry = iCLanguageSettingPathEntryArray[n2];
            String p = pathEntry.getValue();
            if (p != null) {
                Path path = new Path(p);
                if (pathEntry.isValueWorkspacePath()) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource rc = root.findMember((IPath)path);
                    if (rc != null) {
                        path = rc.getLocation();
                    }
                } else if (!path.isAbsolute()) {
                    IPath projLocation;
                    IPath iPath = projLocation = this.fProject != null ? this.fProject.getLocation() : null;
                    if (projLocation != null) {
                        path = projLocation.append((IPath)path);
                    }
                }
                if (path != null) {
                    values[num++] = path.toOSString();
                }
            }
            ++n2;
        }
        if (num < pathEntries.length) {
            String[] tmp = new String[num];
            System.arraycopy(values, 0, tmp, 0, num);
            values = tmp;
        }
        return values;
    }

    @Override
    public void subscribe(IResource resource, IScannerInfoChangeListener listener) {
    }

    @Override
    public void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
    }

    public void close() {
        CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this);
    }

    @Override
    public void handleEvent(CProjectDescriptionEvent event) {
        if (!event.getProject().equals((Object)this.fProject)) {
            return;
        }
        this.updateProjCfgInfo(event.getNewCProjectDescription());
    }
}

