/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextInAgent {
    private final Map<String, Object> properties;
    private List<String> children = new ArrayList<String>();

    public ContextInAgent(Map<String, Object> props) {
        this.properties = props == null ? new HashMap<String, Object>() : new HashMap<String, Object>(props);
    }

    public void addChild(ContextInAgent c) {
        this.children.add(c.getID());
    }

    public void removeChild(ContextInAgent c) {
        this.children.remove(c.getID());
    }

    public void removeChild(String id) {
        this.children.remove(id);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public List<String> getChildren() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.children);
        return ret;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getID() {
        return (String)this.properties.get("ID");
    }

    public String getParentID() {
        return (String)this.properties.get("ParentID");
    }

    public boolean isContainer() {
        Boolean b = (Boolean)this.properties.get("IsContainer");
        return b != null && b != false;
    }

    public boolean hasState() {
        Boolean b = (Boolean)this.properties.get("HasState");
        return b != null && b != false;
    }

    public boolean canResume(int mode) {
        if (this.properties.containsKey("CanResume")) {
            int b = ((Number)this.properties.get("CanResume")).intValue();
            return (b & 1 << mode) != 0;
        }
        return false;
    }

    public boolean canCount(int mode) {
        if (this.properties.containsKey("CanCount")) {
            int b = ((Number)this.properties.get("CanCount")).intValue();
            return (b & 1 << mode) != 0;
        }
        return false;
    }

    public boolean canSuspend() {
        Boolean b = (Boolean)this.properties.get("CanSuspend");
        return b != null && b != false;
    }

    public boolean canTerminate() {
        Boolean b = (Boolean)this.properties.get("CanTerminate");
        return b != null && b != false;
    }

    public String toString() {
        return "[ContextInAgent " + this.properties.toString() + "]";
    }

    public static interface IRegisterOwnerContext {
    }

    public static interface IRunControlContext {
    }
}

