/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import java.util.Collections;
import java.util.Set;
import org.eclipse.cdt.debug.edc.internal.ui.CustomFormatDetailPane;
import org.eclipse.cdt.debug.edc.internal.ui.EDCVariableDetailPane;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDCDetailPaneFactory
implements IDetailPaneFactory {
    public IDetailPane createDetailPane(String paneID) {
        if (paneID.equals("CustomFormatDetailPane")) {
            return new CustomFormatDetailPane();
        }
        if (paneID.equals("EDCDetailPane")) {
            return new EDCVariableDetailPane();
        }
        return null;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IEDCExpression expression = EDCDetailPaneFactory.getExpressionFromSelectedElement(selection.getFirstElement());
            if (EDCDetailPaneFactory.hasCustomProvider(expression)) {
                return "CustomFormatDetailPane";
            }
            if (expression != null) {
                return "EDCDetailPane";
            }
        }
        return null;
    }

    public String getDetailPaneDescription(String paneID) {
        if (paneID.equals("CustomFormatDetailPane")) {
            return "A detail pane to display custom formats";
        }
        if (paneID.equals("EDCDetailPane")) {
            return "EDC detail pane";
        }
        return null;
    }

    public String getDetailPaneName(String paneID) {
        if (paneID.equals("CustomFormatDetailPane")) {
            return "Custom Format Details";
        }
        if (paneID.equals("EDCDetailPane")) {
            return "EDC Variable Details";
        }
        return null;
    }

    public Set<String> getDetailPaneTypes(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IEDCExpression expression = EDCDetailPaneFactory.getExpressionFromSelectedElement(selection.getFirstElement());
            if (EDCDetailPaneFactory.hasCustomProvider(expression)) {
                return Collections.singleton("CustomFormatDetailPane");
            }
            if (expression != null) {
                return Collections.singleton("EDCDetailPane");
            }
        }
        return Collections.emptySet();
    }

    private static boolean hasCustomProvider(IEDCExpression expression) {
        if (expression != null) {
            return CustomFormatDetailPane.getCustomConverter(expression) != null;
        }
        return false;
    }

    public static IEDCExpression getExpressionFromSelectedElement(Object element) {
        IExpressions.IExpressionDMContext expression;
        if (element instanceof IAdaptable && (expression = (IExpressions.IExpressionDMContext)((IAdaptable)element).getAdapter(IExpressions.IExpressionDMContext.class)) instanceof IEDCExpression) {
            return (IEDCExpression)expression;
        }
        return null;
    }
}

