/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.actions;

import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ToggleShowAllVariablesCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean enabled = !HandlerUtil.toggleCommandState((Command)command);
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.edc");
        scope.putBoolean("show_all_variables_enabled", enabled);
        try {
            scope.flush();
        }
        catch (BackingStoreException e) {
            EDCDebugger.getMessageLogger().logError(null, (Throwable)e);
        }
        this.refreshViewer(event);
        return null;
    }

    private void refreshViewer(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractDebugView) {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(window);
            ISelection context = debugContextService.getActiveContext();
            if (context instanceof IStructuredSelection) {
                IVMProvider vmProvider;
                IVMAdapter adapter;
                Object viewerInput = ((IStructuredSelection)context).getFirstElement();
                IPresentationContext presentationContext = ((TreeModelViewer)((AbstractDebugView)activePart).getViewer()).getPresentationContext();
                if (viewerInput instanceof IAdaptable && presentationContext != null && (adapter = (IVMAdapter)((IAdaptable)viewerInput).getAdapter(IVMAdapter.class)) != null && (vmProvider = adapter.getVMProvider(presentationContext)) instanceof ICachingVMProvider) {
                    ((ICachingVMProvider)vmProvider).refresh();
                }
            }
        }
    }
}

