/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.views;

import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SystemRefreshOptionsDialog
extends StatusDialog {
    private static final int MIN_INTERVAL = 3;
    private static final int MAX_INTERVAL = 1800;
    private Label lblInterval;
    private Text intervalText;
    private Image refreshImage;
    private boolean autoRefresh;
    private int refreshInterval;
    private Button btnAutomaticallyRefresh;

    public SystemRefreshOptionsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 2;
        this.btnAutomaticallyRefresh = new Button(container, 32);
        this.btnAutomaticallyRefresh.setText("Automatically Refresh");
        this.btnAutomaticallyRefresh.setSelection(this.isAutoRefresh());
        this.btnAutomaticallyRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SystemRefreshOptionsDialog.this.lblInterval != null) {
                    SystemRefreshOptionsDialog.this.lblInterval.setEnabled(SystemRefreshOptionsDialog.this.btnAutomaticallyRefresh.getSelection());
                }
                if (SystemRefreshOptionsDialog.this.intervalText != null) {
                    SystemRefreshOptionsDialog.this.intervalText.setEnabled(SystemRefreshOptionsDialog.this.btnAutomaticallyRefresh.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new Label(container, 0);
        this.lblInterval = new Label(container, 0);
        this.lblInterval.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblInterval.setText("Interval (seconds):");
        this.lblInterval.setEnabled(this.btnAutomaticallyRefresh.getSelection());
        this.intervalText = new Text(container, 2048);
        this.intervalText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.intervalText.setText(Integer.toString(this.getRefreshInterval()));
        this.intervalText.setEnabled(this.btnAutomaticallyRefresh.getSelection());
        this.intervalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = Status.OK_STATUS;
                try {
                    int value = Integer.parseInt(SystemRefreshOptionsDialog.this.intervalText.getText());
                    if (value < 3 || value > 1800) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    status = new Status(4, "org.eclipse.cdt.debug.edc.ui", "Value must be between 3 and 1800");
                }
                SystemRefreshOptionsDialog.this.updateStatus(status);
            }
        });
        this.getShell().setText("Refresh Options");
        this.refreshImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.edc.ui", (String)"/icons/etool16/refresh.gif").createImage();
        this.getShell().setImage(this.refreshImage);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SystemRefreshOptionsDialog.this.refreshImage != null) {
                    SystemRefreshOptionsDialog.this.refreshImage.dispose();
                }
            }
        });
        return container;
    }

    public boolean close() {
        this.autoRefresh = this.btnAutomaticallyRefresh.getSelection();
        try {
            this.refreshInterval = Integer.parseInt(this.intervalText.getText());
        }
        catch (NumberFormatException e) {
            EDCDebugUI.logError("Invalid interval value", e);
        }
        return super.close();
    }

    protected Point getInitialSize() {
        return new Point(350, 200);
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }
}

