/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.ui.views.ISystemVMContainer;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemDMComparator;
import org.eclipse.cdt.debug.edc.internal.ui.views.SystemDMContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.model.elements.ElementLabelProvider;
import org.eclipse.debug.internal.ui.model.elements.ElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemVMContainer
implements IAdaptable,
ISystemVMContainer {
    private static int nextID = 100;
    protected Map<String, Object> properties = Collections.synchronizedMap(new HashMap());
    private final List<SystemVMContainer> children = Collections.synchronizedList(new ArrayList());
    private ISystemVMContainer parent;
    private SystemDMContainer dmContainer;
    private Image image;
    private IElementMementoProvider elementMementoProvider = new ElementMementoProvider(){

        protected boolean isEqual(Object element, IMemento memento, IPresentationContext context) throws CoreException {
            return memento.getString("Name").equals(((ISystemVMContainer)element).getName());
        }

        protected boolean encodeElement(Object element, IMemento memento, IPresentationContext context) throws CoreException {
            memento.putString("Name", ((ISystemVMContainer)element).getName());
            return true;
        }
    };
    private IElementLabelProvider elementLabelProvider = new ElementLabelProvider(){

        protected String getLabel(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
            Object element = elementPath.getLastSegment();
            Object root = elementPath.getFirstSegment();
            if (element instanceof ISystemVMContainer && root instanceof ISystemVMContainer) {
                if (columnId == null) {
                    return ((ISystemVMContainer)element).getName();
                }
                Object obj = ((ISystemVMContainer)element).getProperties().get(columnId);
                if (obj != null) {
                    return obj.toString();
                }
            }
            return null;
        }
    };
    private IColumnPresentationFactory columnPresentationFactory = new IColumnPresentationFactory(){
        private IColumnPresentation columnPresentation;

        public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
            final String[] columnKeys = (String[])SystemVMContainer.this.getProperties().get("Column_Keys");
            final Map columnNames = (Map)SystemVMContainer.this.getProperties().get("Column_Names");
            if (columnKeys == null) {
                return null;
            }
            if (this.columnPresentation != null) {
                return this.columnPresentation;
            }
            this.columnPresentation = new IColumnPresentation(){

                public void init(IPresentationContext context) {
                }

                public void dispose() {
                }

                public String[] getAvailableColumns() {
                    return columnKeys;
                }

                public String[] getInitialColumns() {
                    return columnKeys;
                }

                public String getHeader(String id) {
                    return (String)columnNames.get(id);
                }

                public ImageDescriptor getImageDescriptor(String id) {
                    return null;
                }

                public String getId() {
                    return (String)SystemVMContainer.this.getProperties().get("ID");
                }

                public boolean isOptional() {
                    return false;
                }
            };
            return this.columnPresentation;
        }

        public String getColumnPresentationId(IPresentationContext context, Object element) {
            if (element instanceof ISystemVMContainer) {
                return (String)SystemVMContainer.this.getProperties().get("ID");
            }
            return null;
        }
    };
    private IElementContentProvider elementContextProvider = new ElementContentProvider(){

        protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
            List<SystemVMContainer> children;
            if (parent instanceof ISystemVMContainer && index < (children = ((ISystemVMContainer)parent).getChildren()).size() && index + length <= children.size()) {
                return children.subList(index, index + length).toArray();
            }
            return null;
        }

        protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
            if (element instanceof ISystemVMContainer) {
                return ((ISystemVMContainer)element).getChildCount();
            }
            return 0;
        }

        protected boolean supportsContextId(String id) {
            return true;
        }
    };

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public List<SystemVMContainer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public SystemVMContainer(Map<String, Object> props) {
        if (props != null) {
            this.properties.putAll(props);
        }
        if ((String)this.properties.get("ID") == null) {
            this.properties.put("ID", this.generateID());
        }
    }

    private String generateID() {
        return Integer.toString(nextID++);
    }

    public SystemVMContainer(SystemVMContainer parent, Map<String, Object> props) {
        this(props);
        if (parent != null) {
            parent.addChild(this);
            this.setParent(parent);
        }
    }

    public SystemVMContainer(SystemVMContainer parent, String name, Map<String, Object> props) {
        this(parent, props);
        this.properties.put("Name", name);
    }

    public SystemVMContainer(SystemVMContainer parent, String name) {
        this(parent, (Map<String, Object>)null);
        this.properties.put("Name", name);
    }

    public SystemVMContainer(SystemVMContainer parent, SystemDMContainer dmContainer) {
        this(parent, dmContainer.getProperties());
        this.setDMContainer(dmContainer);
    }

    private void addChild(SystemVMContainer systemDMC) {
        this.children.add(systemDMC);
    }

    @Override
    public String getName() {
        String name = (String)this.properties.get("Name");
        if (name == null) {
            return "";
        }
        return name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SystemVMContainer) {
            return this.getID().equals(((SystemVMContainer)obj).getID());
        }
        return false;
    }

    public String getID() {
        return (String)this.properties.get("ID");
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        return this.properties.toString();
    }

    public void setParent(ISystemVMContainer parent) {
        this.parent = parent;
    }

    @Override
    public ISystemVMContainer getParent() {
        return this.parent;
    }

    public void setDMContainer(SystemDMContainer dmContainer) {
        this.dmContainer = dmContainer;
    }

    public SystemDMContainer getDMContainer() {
        return this.dmContainer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IElementLabelProvider.class)) {
            return this.elementLabelProvider;
        }
        if (adapter.equals(IElementContentProvider.class)) {
            return this.elementContextProvider;
        }
        if (adapter.equals(IColumnPresentationFactory.class)) {
            return this.columnPresentationFactory;
        }
        if (adapter.equals(IElementMementoProvider.class)) {
            return this.elementMementoProvider;
        }
        return null;
    }

    public void setImage(Image image) {
        if (image == null && this.image != null) {
            this.image.dispose();
        }
        this.image = image;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public void sortDMData(List<SystemDMContainer> dmData) {
        String sortProperty = (String)this.getProperties().get("Sort_Property");
        if (sortProperty != null) {
            Integer sortDirection = (Integer)this.getProperties().get("Sort_Direction");
            assert (sortDirection != null);
            Collections.sort(dmData, new SystemDMComparator(sortProperty, sortDirection));
        }
    }

    public IElementMementoProvider getElementMementoProvider() {
        return this.elementMementoProvider;
    }

    public IElementLabelProvider getElementLabelProvider() {
        return this.elementLabelProvider;
    }

    public IColumnPresentationFactory getColumnPresentationFactory() {
        return this.columnPresentationFactory;
    }

    public IElementContentProvider getElementContextProvider() {
        return this.elementContextProvider;
    }
}

