/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.acpm;

import java.util.List;
import org.eclipse.cdt.debug.edc.acpm.ICacheEntry;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RangeCache;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRangeCache<V>
extends RangeCache<V>
implements ICacheEntry {
    protected final IDsfService fService;
    protected final IDMContext fCtx;
    private Object fMetaData;

    public BaseRangeCache(IDsfService service, IDMContext ctx) {
        super(new ImmediateInDsfExecutor(service.getExecutor()));
        this.fService = service;
        this.fCtx = ctx;
    }

    public IDsfService getService() {
        return this.fService;
    }

    @Override
    public IDMContext getContext() {
        return this.fCtx;
    }

    @Override
    public void setMetaData(Object data) {
        this.fMetaData = data;
    }

    @Override
    public Object getMetaData() {
        return this.fMetaData;
    }

    protected void reset() {
        super.reset();
        this.fService.getSession().removeServiceEventListener((Object)this);
    }

    protected void set(long offset, int count, List<V> data, IStatus status) {
        super.set(offset, count, data, status);
        this.fService.getSession().addServiceEventListener((Object)this, null);
    }

    @Override
    public void dispose() {
        this.reset();
    }

    @DsfServiceEventHandler
    public void resumedEventHandler(IDMEvent<?> e) {
        this.reset();
    }

    @Override
    public RequestMonitor getRequestMonitor() {
        return null;
    }
}

