/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.acpm;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.acpm.BaseRangeCache;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.debug.core.model.MemoryByte;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryRangeCache
extends BaseRangeCache<MemoryByte> {
    private final IAddress fAddress;
    private final int fWordSize;

    public MemoryRangeCache(IMemory service, IDMContext ctx, IAddress address, int wordSize) {
        super((IDsfService)service, ctx);
        this.fAddress = address;
        this.fWordSize = wordSize;
    }

    protected void retrieve(long offset, int count, final DataRequestMonitor<List<MemoryByte>> rm) {
        ((IMemory)this.fService).getMemory((IMemory.IMemoryDMContext)this.fCtx, this.fAddress, offset, this.fWordSize, count, (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)this.fService.getExecutor(), rm){

            public void handleSuccess() {
                rm.setData(Arrays.asList((MemoryByte[])this.getData()));
                rm.done();
            }
        });
    }

    @Override
    @DsfServiceEventHandler
    public void resumedEventHandler(IDMEvent<?> e) {
        super.resumedEventHandler(e);
    }

    public IAddress getAddress() {
        return this.fAddress;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public boolean wasCanceled() {
        return false;
    }
}

