/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.eclipse.cdt.debug.edc.internal.HostOS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathUtils {
    public static String convertPathListToUnix(String env) {
        if (env == null) {
            return null;
        }
        env = env.replaceAll(";", ":");
        env = env.replaceAll("\\\\", "/");
        return env;
    }

    public static String convertPathToUnix(String file) {
        if (file == null) {
            return null;
        }
        file = file.replaceAll("\\\\", "/");
        return file;
    }

    public static String convertPathToWindows(String file) {
        if (file == null) {
            return null;
        }
        file = file.replaceAll("/", "\\\\");
        return file;
    }

    public static String convertPathToWindows(IPath path) {
        return PathUtils.convertPathToWindows(path.toPortableString());
    }

    public static String convertPathToNative(String path) {
        if (path == null) {
            return null;
        }
        if (HostOS.IS_UNIX) {
            return path.replaceAll("\\\\", "/");
        }
        return path.replaceAll("/", "\\\\");
    }

    public static IPath createPath(String path) {
        int idx;
        if (path == null) {
            return null;
        }
        boolean hasWindowsSlashes = path.contains("\\");
        if (hasWindowsSlashes) {
            path = path.replaceAll("\\\\", "/");
        }
        if ((idx = path.indexOf(":")) > 0) {
            String device = path.substring(0, idx + 1);
            path = path.substring(idx + 1);
            return new Path(path).setDevice(device);
        }
        if (path.startsWith("//") && !hasWindowsSlashes) {
            String network;
            idx = path.indexOf("/", 2);
            if (idx > 0) {
                network = path.substring(0, idx);
                path = path.substring(idx);
            } else {
                network = path;
                path = "";
            }
            return new Path(network, path).makeUNC(true);
        }
        return new Path(path);
    }

    public static IPath[] getPathEntries(String pathValue) {
        String pathVar = null;
        if (pathValue != null) {
            pathVar = pathValue;
        } else {
            if (HostOS.IS_WIN32) {
                pathVar = System.getenv("Path");
            }
            if (pathVar == null) {
                pathVar = System.getenv("PATH");
            }
        }
        if (pathVar == null) {
            pathVar = "";
        }
        String pathSeparator = System.getProperty("path.separator");
        String[] pathEntries = pathVar.split(pathSeparator);
        IPath[] paths = new IPath[pathEntries.length];
        int i = 0;
        while (i < pathEntries.length) {
            paths[i] = new Path(pathEntries[i]);
            ++i;
        }
        return paths;
    }

    public static IPath findExistingPathIfCaseSensitive(IPath path) {
        if (HostOS.IS_WIN32) {
            return path;
        }
        if (path == null || !path.isAbsolute()) {
            return path;
        }
        File pathFile = path.toFile();
        if (pathFile.exists()) {
            try {
                return new Path(pathFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                return path;
            }
        }
        Path goodPath = Path.ROOT;
        if (path.getDevice() != null) {
            goodPath = goodPath.setDevice(path.getDevice());
        }
        if (!goodPath.toFile().exists()) {
            return path;
        }
        int seg = path.segmentCount();
        while (seg > 0) {
            IPath prefix = path.uptoSegment(seg - 1);
            if (prefix.toFile().exists()) {
                goodPath = prefix;
                break;
            }
            --seg;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(goodPath.addTrailingSeparator().toOSString());
        boolean failedLookup = false;
        int seg2 = goodPath.segmentCount();
        while (seg2 < path.segmentCount()) {
            String[] names;
            File dir;
            final String segment = path.segment(seg2);
            final String[] matches = new String[]{segment};
            if (!failedLookup && !new File(dir = new File(builder.toString()), matches[0]).exists() && (names = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.equalsIgnoreCase(segment)) {
                        matches[0] = name;
                        return true;
                    }
                    return false;
                }
            })).length == 0) {
                failedLookup = true;
            }
            builder.append(matches[0]);
            builder.append('/');
            ++seg2;
        }
        if (!path.hasTrailingSeparator() && builder.length() > 0 && builder.charAt(builder.length() - 1) == '/') {
            builder.setLength(builder.length() - 1);
        }
        return new Path(builder.toString());
    }

    public static boolean isCaseSensitive() {
        return HostOS.IS_UNIX;
    }
}

