/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.IArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.Type;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;

public class ArrayDimensionType
extends Type
implements IArrayDimensionType {
    private final OperandValue value;
    private final IArrayType arrayType;
    private IVariableLocation location;
    private int dimensionCount;

    public ArrayDimensionType(String name, OperandValue value, IArrayType arrayType, IVariableLocation location) {
        super(name, null, 0, null);
        this.value = value;
        this.arrayType = arrayType;
        this.location = location;
        this.dimensionCount = 1;
    }

    public OperandValue getOperandValue() {
        return this.value;
    }

    public IArrayType getArrayType() {
        return this.arrayType;
    }

    public IVariableLocation getLocation() {
        return this.location;
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public void addDimension(long subscript, long increase) {
        this.name = String.valueOf(this.name) + "[" + subscript + "]";
        this.location = this.location.addOffset(increase);
        ++this.dimensionCount;
    }

    public IType getType() {
        return null;
    }
}

