/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.core.runtime.CoreException;

public class GetValue {
    private static CoreException badType() {
        return EDCDebugger.newCoreException(ASTEvalMessages.GetValue_TypePromotionError);
    }

    public static boolean getBooleanValue(OperandValue op) throws CoreException {
        Number value = op.getValue();
        if (value instanceof BigInteger) {
            return ((BigInteger)value).signum() != 0;
        }
        return value.longValue() != 0L;
    }

    public static int getIntValue(OperandValue op) throws CoreException {
        Number value = op.getValue();
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return new Integer(((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return new Integer(((Byte)value).byteValue());
        }
        throw GetValue.badType();
    }

    public static long getLongValue(OperandValue op) throws CoreException {
        Number value = op.getValue();
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Short) {
            return new Long(((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return new Long(((Byte)value).byteValue());
        }
        throw GetValue.badType();
    }

    public static BigInteger getBigIntegerValue(OperandValue op) throws CoreException {
        Number value = op.getValue();
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Long) {
            return new BigInteger(((Long)value).toString());
        }
        if (value instanceof Integer) {
            return new BigInteger(((Integer)value).toString());
        }
        if (value instanceof Short) {
            return new BigInteger(((Short)value).toString());
        }
        if (value instanceof Byte) {
            return new BigInteger(new byte[]{(Byte)value});
        }
        throw GetValue.badType();
    }

    public static float getFloatValue(OperandValue op) throws CoreException {
        Number value = op.getValue();
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Long) {
            return new Float(((Long)value).longValue()).floatValue();
        }
        if (value instanceof Integer) {
            return new Float(((Integer)value).intValue()).floatValue();
        }
        if (value instanceof Short) {
            return new Float(((Short)value).shortValue()).floatValue();
        }
        if (value instanceof Byte) {
            return new Float(((Byte)value).byteValue()).floatValue();
        }
        if (value instanceof BigInteger) {
            return new Float(((BigInteger)value).floatValue()).floatValue();
        }
        throw GetValue.badType();
    }

    public static double getDoubleValue(OperandValue op) throws CoreException {
        Number value = op.getValue();
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return new Double(((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return new Double(((Long)value).longValue());
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof Short) {
            return new Double(((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return new Double(((Byte)value).byteValue());
        }
        if (value instanceof BigInteger) {
            return new Double(((BigInteger)value).doubleValue());
        }
        throw GetValue.badType();
    }

    public static String getStringValue(OperandValue value) throws CoreException {
        if (value.getStringValue() != null) {
            return value.getStringValue();
        }
        return "\"" + (char)value.getValue().longValue() + "\"";
    }
}

