/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.BinaryOperator;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Instruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Interpreter;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.core.runtime.CoreException;

public class OperatorMinus
extends BinaryOperator {
    public OperatorMinus(int start) {
        this(0, false, start);
    }

    protected OperatorMinus(int resultId, boolean isAssignmentOperator, int start) {
        super(resultId, isAssignmentOperator, start);
    }

    protected boolean customHandleOperation(Interpreter fInterpreter, OperandValue left, OperandValue right) throws CoreException {
        IType rightType = null;
        IType leftType = null;
        boolean isLeftPointer = false;
        leftType = TypeUtils.getStrippedType(left.getValueType());
        isLeftPointer = leftType instanceof IPointerType || leftType instanceof IArrayType;
        boolean isRightPointer = false;
        rightType = TypeUtils.getStrippedType(right.getValueType());
        boolean bl = isRightPointer = rightType instanceof IPointerType || rightType instanceof IArrayType;
        if (!isLeftPointer && !isRightPointer) {
            return false;
        }
        if (!isLeftPointer && isRightPointer) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorMinus_NonPtrMinusPtr);
        }
        if (this.getValueType(left) == 11 && this.getValueType(right) == 11) {
            return false;
        }
        BigInteger bigIntAddress = left.getBigIntValue();
        BigInteger aggregateSize = leftType instanceof IPointerType ? BigInteger.valueOf(leftType.getByteSize()) : BigInteger.valueOf(TypeUtils.getStrippedType(leftType.getType()).getByteSize());
        if (!isRightPointer) {
            right = this.convertForPromotion(right);
        }
        BigInteger subtractAmount = right.getBigIntValue();
        if (!isRightPointer) {
            subtractAmount = subtractAmount.multiply(aggregateSize);
        }
        bigIntAddress = bigIntAddress.subtract(subtractAmount);
        if (isRightPointer && aggregateSize.longValue() != 0L) {
            bigIntAddress = bigIntAddress.divide(aggregateSize);
        }
        if (isRightPointer) {
            this.pushNewValue(left.getValueType(), bigIntAddress);
        } else {
            this.pushNewValue(fInterpreter.getTypeEngine().getPointerSizeType(), bigIntAddress);
        }
        return true;
    }

    protected int getIntResult(int leftOperand, int rightOperand) throws CoreException {
        return leftOperand - rightOperand;
    }

    protected long getLongResult(long leftOperand, long rightOperand) throws CoreException {
        return leftOperand - rightOperand;
    }

    protected BigInteger getBigIntegerResult(BigInteger leftOperand, BigInteger rightOperand, int length) throws CoreException {
        return leftOperand.subtract(rightOperand).and(Instruction.Mask8Bytes);
    }

    protected float getFloatResult(float leftOperand, float rightOperand) {
        return leftOperand - rightOperand;
    }

    protected double getDoubleResult(double leftOperand, double rightOperand) {
        return leftOperand - rightOperand;
    }

    protected boolean getBooleanResult(boolean leftOperand, boolean rightOperand) {
        return false;
    }
}

