/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.SimpleInstruction;

public class PushDouble
extends SimpleInstruction {
    private double fValue;
    private boolean isLong;

    public PushDouble(double value) {
        this.fValue = value;
    }

    public PushDouble(String value) throws NumberFormatException {
        if (value.toLowerCase().endsWith("l")) {
            this.isLong = true;
            value = value.substring(0, value.length() - 1);
        }
        this.fValue = Double.valueOf(value);
    }

    public void execute() {
        if (this.isLong) {
            int size = this.fInterpreter.getTypeEngine().getTypeSize(16);
            this.pushNewValue(this.fInterpreter.getTypeEngine().getBasicType(5, 1, size), this.fValue);
        } else {
            int size = this.fInterpreter.getTypeEngine().getTypeSize(14);
            this.pushNewValue(this.fInterpreter.getTypeEngine().getBasicType(5, 0, size), this.fValue);
        }
    }

    public String toString() {
        return Double.toString(this.fValue);
    }
}

