/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.cdt.debug.edc.formatter.AbstractVariableConverter;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.CoreException;

public class QHashNodeFormatter
implements IVariableFormatProvider {
    private static final String TYPE_NAME = "QHashNode";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, true);
        }
        return null;
    }

    public static class FormatProvider
    extends AbstractVariableConverter {
        private static final int KEY_CHILD_INDEX = 2;
        private static final int VALUE_CHILD_INDEX = 3;
        private static final String QHASH_DETAIL_FMT = "{0} : {1}";

        public FormatProvider(IType type, boolean forDetails) {
            super(type, forDetails);
        }

        protected String getDetailsValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            return this.getSummaryValue(variable);
        }

        protected String getSummaryValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            String templateTypeName = FormatUtils.getTemplateTypeName(QHashNodeFormatter.TYPE_NAME, this.type);
            List<IExpressions.IExpressionDMContext> children = FormatUtils.getAllChildExpressions(variable);
            IEDCExpression keyExpression = (IEDCExpression)children.get(2);
            String key = FormatUtils.getFormattedValue(keyExpression);
            if (templateTypeName.endsWith("QHashDummyValue")) {
                return key;
            }
            IEDCExpression valueExpression = (IEDCExpression)children.get(3);
            String value = FormatUtils.getFormattedValue(valueExpression);
            return MessageFormat.format(QHASH_DETAIL_FMT, key, value);
        }
    }
}

