/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.formatter.AbstractCompositeFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.core.runtime.CoreException;

public class QLinkedListFormatter
implements IVariableFormatProvider {
    private static final String TYPE_NAME = "QLinkedList";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, true);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatProvider
    extends AbstractCompositeFormatProvider {
        private static final String SIZE_NAME = "size";
        private static final String SIZE_PATH = "$unnamed$1.d->size";
        private static final String HEAD_NAME = "head";
        private static final String HEAD_PATH = "$unnamed$1.e";
        private static final int SIZE_CHILD_INDEX = 0;
        private static final int HEAD_CHILD_INDEX = 1;
        private static final int NODE_NEXT_CHILD_INDEX = 0;
        private static final int NODE_ELEMENT_CHILD_INDEX = 2;
        private static final String NODE_CAST_FMT = "reinterpret_cast<QLinkedListNode<{0}>*>({1})";
        private static final String DETAIL_SIZE_FMT = "size={0}";
        private static final String DETAIL_FMT = "size={0} {1}";
        private static final int STOP_LENGTH = 300;
        private static Map<String, String> nameToFieldPathMap = new LinkedHashMap<String, String>();

        static {
            nameToFieldPathMap.put(SIZE_NAME, SIZE_PATH);
            nameToFieldPathMap.put(HEAD_NAME, HEAD_PATH);
        }

        public FormatProvider(IType type, boolean forDetails) {
            super(type, forDetails, FormatProvider.getNameToFieldPaths());
        }

        private static List<AbstractCompositeFormatProvider.NameToFieldPath> getNameToFieldPaths() {
            ArrayList<AbstractCompositeFormatProvider.NameToFieldPath> nameToFieldPaths = new ArrayList<AbstractCompositeFormatProvider.NameToFieldPath>();
            for (Map.Entry<String, String> entry : nameToFieldPathMap.entrySet()) {
                nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(entry.getKey(), entry.getValue()));
            }
            return nameToFieldPaths;
        }

        @Override
        public int getChildCount(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> childContexts = super.getChildren(variable);
            IEDCExpression sizeChild = (IEDCExpression)childContexts.get(0);
            FormatUtils.evaluateExpression(sizeChild);
            int size = sizeChild.getEvaluatedValue().intValue();
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            return size;
        }

        @Override
        protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            List<IExpressions.IExpressionDMContext> childContexts = super.getChildren(variable);
            IEDCExpression sizeChild = (IEDCExpression)childContexts.get(0);
            FormatUtils.evaluateExpression(sizeChild);
            children.add(sizeChild);
            int size = sizeChild.getEvaluatedValue().intValue();
            if (size < 0 || size > 0x1000000) {
                throw EDCDebugger.newCoreException("Uninitialized");
            }
            if (size > 0) {
                IEDCExpressions expressions = sizeChild.getExpressionsService();
                children.addAll(this.getElementsFromListHead((IExpressions)expressions, (IEDCExpression)childContexts.get(1)));
            }
            return children;
        }

        private List<IEDCExpression> getElementsFromListHead(IExpressions expressions, IEDCExpression listHead) throws CoreException {
            FormatUtils.evaluateExpression(listHead);
            int listHeadValue = listHead.getEvaluatedValue().intValue();
            IStack.IFrameDMContext frame = listHead.getFrame();
            String templateTypeName = FormatUtils.getTemplateTypeName(QLinkedListFormatter.TYPE_NAME, this.type);
            ArrayList<IEDCExpression> elements = new ArrayList<IEDCExpression>();
            IEDCExpression nextNode = this.getNextNode(expressions, frame, templateTypeName, listHead);
            while (nextNode.getEvaluatedValue().intValue() != listHeadValue) {
                List<IExpressions.IExpressionDMContext> nodeChildren = FormatUtils.getAllChildExpressions(nextNode);
                IEDCExpression elementChild = (IEDCExpression)nodeChildren.get(2);
                IEDCExpression copy = (IEDCExpression)expressions.createExpression((IDMContext)frame, elementChild.getExpression());
                copy.setName("" + (elements.size() + 1));
                elements.add(copy);
                nextNode = this.getNextNode(expressions, frame, templateTypeName, nextNode);
                if (elements.size() < FormatUtils.getMaxNumberOfChildren()) continue;
                IEDCExpression moreExpression = (IEDCExpression)expressions.createExpression((IDMContext)frame, "0");
                moreExpression.setName("more...");
                elements.add(moreExpression);
                break;
            }
            return elements;
        }

        private IEDCExpression getNextNode(IExpressions expressions, IStack.IFrameDMContext frame, String templateTypeName, IExpressions.IExpressionDMContext node) throws CoreException {
            FormatUtils.evaluateExpression((IEDCExpression)node);
            List<IExpressions.IExpressionDMContext> nodeFields = FormatUtils.getAllChildExpressions(node);
            IEDCExpression nextNode = (IEDCExpression)nodeFields.get(0);
            FormatUtils.evaluateExpression(nextNode);
            String expression = MessageFormat.format(NODE_CAST_FMT, templateTypeName, "0x" + Integer.toHexString(nextNode.getEvaluatedValue().intValue()));
            nextNode = (IEDCExpression)expressions.createExpression((IDMContext)frame, expression);
            FormatUtils.evaluateExpression(nextNode);
            return nextNode;
        }

        @Override
        public String getValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            int count = this.getChildCount(variable);
            return MessageFormat.format(DETAIL_SIZE_FMT, count);
        }

        protected String getFullStringValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
            IEDCExpression sizeExp = (IEDCExpression)children.get(0);
            StringBuilder sb = new StringBuilder("[");
            int i = 1;
            while (i < children.size()) {
                String elementString;
                IEDCExpression elementChild = (IEDCExpression)children.get(i);
                if (i > 1) {
                    sb.append(", ");
                }
                if ((elementString = FormatUtils.getFormattedValue(elementChild)) != null) {
                    sb.append('{');
                    sb.append(elementString);
                    sb.append('}');
                }
                if (sb.length() > 300) {
                    if (children.get(children.size() - 1).equals(elementChild)) break;
                    sb.append(", ...");
                    break;
                }
                ++i;
            }
            return MessageFormat.format(DETAIL_FMT, FormatUtils.getVariableValue(sizeExp), sb.append(']').toString());
        }
    }
}

