/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCSymbols;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils {
    private static Map<String, String> contextsInSessions = new HashMap<String, String>();

    public static void addContext(String sessionID, String contextID) {
        contextsInSessions.put(contextID, sessionID);
    }

    public static String getSessionForContext(String contextID) {
        return contextsInSessions.get(contextID);
    }

    protected static DsfServicesTracker getDsfServicesTracker(DsfSession session) {
        return new DsfServicesTracker(EDCDebugger.getBundleContext(), session.getId());
    }

    public static List<RunControl.ExecutionDMC> getContexts(String sessionId) throws Exception {
        final ArrayList<RunControl.ExecutionDMC> contexts = new ArrayList<RunControl.ExecutionDMC>();
        final DsfSession session = DsfSession.getSession((String)sessionId);
        session.getExecutor().submit((Runnable)new DsfRunnable(){

            public void run() {
                RunControl.RootExecutionDMC rootDMC;
                DsfServicesTracker servicesTracker = DOMUtils.getDsfServicesTracker(session);
                RunControl runControlService = (RunControl)servicesTracker.getService(RunControl.class);
                if (runControlService != null && (rootDMC = runControlService.getRootDMC()) != null) {
                    RunControl.ExecutionDMC[] children;
                    RunControl.ExecutionDMC[] executionDMCArray = children = rootDMC.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RunControl.ExecutionDMC executionDMC = executionDMCArray[n2];
                        DOMUtils.addContextRecursive(executionDMC, contexts);
                        ++n2;
                    }
                }
            }
        }).get();
        return contexts;
    }

    public static List<RunControl.ExecutionDMC> getSuspendedContexts(String sessionId) throws Exception {
        ArrayList<RunControl.ExecutionDMC> suspendedContexts = new ArrayList<RunControl.ExecutionDMC>();
        for (RunControl.ExecutionDMC context : DOMUtils.getContexts(sessionId)) {
            if (!context.isSuspended()) continue;
            suspendedContexts.add(context);
        }
        return suspendedContexts;
    }

    public static List<RunControl.ExecutionDMC> getSuspendedThreads(String sessionId) throws Exception {
        ArrayList<RunControl.ExecutionDMC> threadList = new ArrayList<RunControl.ExecutionDMC>();
        for (RunControl.ExecutionDMC context : DOMUtils.getSuspendedContexts(sessionId)) {
            String message;
            String parentId = (String)context.getProperties().get("ParentID");
            if (parentId == null || "root".equals(parentId) || (message = (String)context.getProperties().get("Message")) == null || "Shared Library".equals(message)) continue;
            threadList.add(context);
        }
        return threadList;
    }

    private static void addContextRecursive(RunControl.ExecutionDMC executionDMC, List<RunControl.ExecutionDMC> contexts) {
        RunControl.ExecutionDMC[] children;
        DOMUtils.addContext(executionDMC, contexts);
        RunControl.ExecutionDMC[] executionDMCArray = children = executionDMC.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            RunControl.ExecutionDMC childDMC = executionDMCArray[n2];
            DOMUtils.addContextRecursive(childDMC, contexts);
            ++n2;
        }
    }

    private static void addContext(RunControl.ExecutionDMC executionDMC, List<RunControl.ExecutionDMC> contexts) {
        contexts.add(executionDMC);
        DOMUtils.addContext(executionDMC.getSessionId(), executionDMC.getID());
    }

    public static List<Stack.StackFrameDMC> getStackFrames(final String contextId) throws Exception {
        final ArrayList<Stack.StackFrameDMC> frames = new ArrayList<Stack.StackFrameDMC>();
        final DsfSession session = DsfSession.getSession((String)DOMUtils.getSessionForContext(contextId));
        session.getExecutor().submit((Runnable)new DsfRunnable(){

            public void run() {
                DsfServicesTracker servicesTracker = DOMUtils.getDsfServicesTracker(session);
                Stack stackService = (Stack)servicesTracker.getService(Stack.class);
                RunControl runControlService = (RunControl)servicesTracker.getService(RunControl.class);
                if (runControlService != null && stackService != null) {
                    try {
                        IStack.IFrameDMContext[] serviceFrames;
                        IStack.IFrameDMContext[] iFrameDMContextArray = serviceFrames = stackService.getFramesForDMC(runControlService.getContext(contextId), 0, -1);
                        int n = serviceFrames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStack.IFrameDMContext serviceFrame = iFrameDMContextArray[n2];
                            frames.add((Stack.StackFrameDMC)serviceFrame);
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).get();
        return frames;
    }

    public static Map<String, Object>[] getDMContextProperties(List<? extends DMContext> contexts) {
        ArrayList<Map<String, Object>> contextPropsList = new ArrayList<Map<String, Object>>();
        for (IEDCDMContext iEDCDMContext : contexts) {
            contextPropsList.add(iEDCDMContext.getProperties());
        }
        return contextPropsList.toArray(new Map[contextPropsList.size()]);
    }

    public static IFunctionScope getFunctionAtAddress(String sessionId, String runtimeAddressIdentifier) throws Exception {
        final IFunctionScope[] result = new IFunctionScope[1];
        Addr64 runtimeAddress = new Addr64(runtimeAddressIdentifier, 16);
        for (final RunControl.ExecutionDMC context : DOMUtils.getContexts(sessionId)) {
            if (context instanceof IModules.ISymbolDMContext) {
                final DsfSession session = DsfSession.getSession((String)sessionId);
                session.getExecutor().submit((Runnable)new DsfRunnable((IAddress)runtimeAddress){
                    private final /* synthetic */ IAddress val$runtimeAddress;
                    {
                        this.val$runtimeAddress = iAddress;
                    }

                    public void run() {
                        DsfServicesTracker servicesTracker = DOMUtils.getDsfServicesTracker(session);
                        IEDCSymbols edcSymbols = (IEDCSymbols)servicesTracker.getService(IEDCSymbols.class);
                        if (edcSymbols != null) {
                            result[0] = edcSymbols.getFunctionAtAddress((IModules.ISymbolDMContext)context, this.val$runtimeAddress);
                        }
                    }
                }).get();
            }
            if (result[0] != null) break;
        }
        return result[0];
    }

    public static IEDCSymbolReader getSymbolReader(IPath modulePath) {
        return Symbols.getSymbolReader(modulePath);
    }
}

