/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugEventListener
implements DsfSession.SessionStartedListener {
    private Map<String, List<Map<String, String>>> clientEvents = Collections.synchronizedMap(new HashMap());
    private Map<String, SessionListener> sessionListeners = Collections.synchronizedMap(new HashMap());
    private static DebugEventListener listener;

    public static DebugEventListener getListener() {
        if (listener == null) {
            listener = new DebugEventListener();
        }
        return listener;
    }

    public DebugEventListener() {
        DsfSession.addSessionStartedListener((DsfSession.SessionStartedListener)this);
    }

    public void shutDown() {
        DsfSession.removeSessionStartedListener((DsfSession.SessionStartedListener)this);
        listener = null;
    }

    public void sessionStarted(DsfSession session) {
        new SessionListener(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> listenForEvents(String clientID) throws InterruptedException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("clientID", clientID);
        List<Map<String, String>> events = null;
        Object object = this.clientEvents;
        synchronized (object) {
            events = this.clientEvents.get(clientID);
            if (events == null) {
                events = new ArrayList<Map<String, String>>();
                this.clientEvents.put(clientID, events);
            }
        }
        object = events;
        synchronized (object) {
            while (events.size() == 0) {
                events.wait();
            }
            result.put("events", new ArrayList<Map<String, String>>(events));
            events.clear();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SessionListener {
        private String sessionID;

        public SessionListener(DsfSession session) {
            this.sessionID = session.getId();
            DebugEventListener.this.sessionListeners.put(this.sessionID, this);
            HashMap<String, String> eventProps = new HashMap<String, String>();
            eventProps.put("event", "sessionStarted");
            eventProps.put("id", session.getId());
            this.postEvent(eventProps);
            session.addServiceEventListener((Object)this, null);
        }

        public String getSessionID() {
            return this.sessionID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postEvent(Map<String, String> eventProps) {
            eventProps.put("session", this.getSessionID());
            Map map = DebugEventListener.this.clientEvents;
            synchronized (map) {
                Collection eventLists = DebugEventListener.this.clientEvents.values();
                Iterator iterator = eventLists.iterator();
                while (iterator.hasNext()) {
                    List list;
                    List list2 = list = (List)iterator.next();
                    synchronized (list2) {
                        list.add(eventProps);
                        list.notifyAll();
                    }
                }
            }
        }

        @DsfServiceEventHandler
        public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
            HashMap<String, String> eventProps = new HashMap<String, String>();
            eventProps.put("event", "contextSuspended");
            eventProps.put("context", ((IEDCDMContext)e.getDMContext()).getID());
            this.postEvent(eventProps);
        }
    }
}

