/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.MemoryUtils;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.Addr64Factory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.util.TCFTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCache
implements ISnapshotContributor {
    private final int TIMEOUT = 6000;
    private int minimumBlockSize = 0;
    private final Map<String, IMemory.MemoryContext> tcfMemoryContexts = Collections.synchronizedMap(new HashMap());
    private final SortedMemoryBlockList memoryBlockList = new SortedMemoryBlockList();
    private static final String MEMORY_CACHE = "memory_cache";
    private static final String MEMORY_BLOCK = "memory_block";
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_LENGTH = "length";
    private static final String ATTR_VALUE = "value";

    public MemoryCache(int minimumBlockSize) {
        this.minimumBlockSize = minimumBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        SortedMemoryBlockList sortedMemoryBlockList = this.memoryBlockList;
        synchronized (sortedMemoryBlockList) {
            this.memoryBlockList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<MemoryBlock> getListOfMissingBlocks(IAddress reqBlockStart, int count) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{reqBlockStart.toHexAddressString(), count}));
        }
        LinkedList<MemoryBlock> list = new LinkedList<MemoryBlock>();
        SortedMemoryBlockList sortedMemoryBlockList = this.memoryBlockList;
        synchronized (sortedMemoryBlockList) {
            ListIterator it = this.memoryBlockList.listIterator();
            while (it.hasNext() && count > 0) {
                MemoryBlock cachedBlock = (MemoryBlock)it.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLength);
                if (reqBlockStart.distanceTo(cachedBlockStart).longValue() >= 0L) {
                    int length = (int)Math.min(reqBlockStart.distanceTo(cachedBlockStart).longValue(), (long)count);
                    if (length > 0) {
                        IAddress blockAddress;
                        Addr64Factory f;
                        if (reqBlockStart instanceof Addr64) {
                            f = new Addr64Factory();
                            blockAddress = f.createAddress(reqBlockStart.getValue());
                        } else {
                            f = new Addr32Factory();
                            blockAddress = f.createAddress(reqBlockStart.getValue());
                        }
                        MemoryBlock newBlock = new MemoryBlock(blockAddress, length, new MemoryByte[0]);
                        list.add(newBlock);
                    }
                    reqBlockStart = cachedBlockEnd;
                    count = (int)((long)count - ((long)length + cachedBlock.fLength));
                    continue;
                }
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() <= 0L || reqBlockStart.distanceTo(cachedBlockEnd).longValue() < 0L) continue;
                count = (int)((long)count - reqBlockStart.distanceTo(cachedBlockEnd).longValue());
                reqBlockStart = cachedBlockEnd;
            }
            if (count > 0) {
                IAddress blockAddress;
                Addr64Factory f;
                if (reqBlockStart instanceof Addr64) {
                    f = new Addr64Factory();
                    blockAddress = f.createAddress(reqBlockStart.getValue());
                } else {
                    f = new Addr32Factory();
                    blockAddress = f.createAddress(reqBlockStart.getValue());
                }
                MemoryBlock newBlock = new MemoryBlock(blockAddress, count, new MemoryByte[0]);
                list.add(newBlock);
            }
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(list));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryByte[] getMemoryBlockFromCache(IAddress reqBlockStart, int count) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{reqBlockStart.toHexAddressString(), count}));
        }
        Object[] resultBlock = new MemoryByte[count];
        SortedMemoryBlockList sortedMemoryBlockList = this.memoryBlockList;
        synchronized (sortedMemoryBlockList) {
            IAddress reqBlockEnd = reqBlockStart.add((long)count);
            ListIterator iter = this.memoryBlockList.listIterator();
            while (iter.hasNext()) {
                int length;
                int pos;
                MemoryBlock cachedBlock = (MemoryBlock)iter.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLength);
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() >= 0L && reqBlockEnd.distanceTo(cachedBlockEnd).longValue() >= 0L) {
                    pos = (int)cachedBlockStart.distanceTo(reqBlockStart).longValue();
                    System.arraycopy(cachedBlock.fBlock, pos, resultBlock, 0, count);
                    continue;
                }
                if (reqBlockStart.distanceTo(cachedBlockStart).longValue() >= 0L && cachedBlockStart.distanceTo(reqBlockEnd).longValue() > 0L) {
                    pos = (int)reqBlockStart.distanceTo(cachedBlockStart).longValue();
                    length = (int)Math.min(cachedBlock.fLength, (long)(count - pos));
                    System.arraycopy(cachedBlock.fBlock, 0, resultBlock, pos, length);
                    continue;
                }
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() < 0L || reqBlockStart.distanceTo(cachedBlockEnd).longValue() <= 0L) continue;
                pos = (int)cachedBlockStart.distanceTo(reqBlockStart).longValue();
                length = (int)Math.min(cachedBlock.fLength - (long)pos, (long)count);
                System.arraycopy(cachedBlock.fBlock, pos, resultBlock, 0, length);
            }
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArgs(resultBlock));
        }
        return resultBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMemoryCache(IAddress modBlockStart, int count, MemoryByte[] modBlock) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{modBlockStart.toHexAddressString(), count}));
        }
        SortedMemoryBlockList sortedMemoryBlockList = this.memoryBlockList;
        synchronized (sortedMemoryBlockList) {
            IAddress modBlockEnd = modBlockStart.add((long)count);
            ListIterator iter = this.memoryBlockList.listIterator();
            while (iter.hasNext()) {
                int length;
                int pos;
                MemoryBlock cachedBlock = (MemoryBlock)iter.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLength);
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockEnd.distanceTo(cachedBlockEnd).longValue() >= 0L) {
                    pos = (int)cachedBlockStart.distanceTo(modBlockStart).longValue();
                    System.arraycopy(modBlock, 0, cachedBlock.fBlock, pos, count);
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockStart.distanceTo(cachedBlockEnd).longValue() > 0L) {
                    pos = (int)cachedBlockStart.distanceTo(modBlockStart).longValue();
                    length = (int)cachedBlockStart.distanceTo(modBlockEnd).longValue();
                    System.arraycopy(modBlock, 0, cachedBlock.fBlock, pos, length);
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockEnd).longValue() <= 0L || modBlockEnd.distanceTo(cachedBlockEnd).longValue() < 0L) continue;
                pos = (int)modBlockStart.distanceTo(cachedBlockStart).longValue();
                length = (int)cachedBlockStart.distanceTo(modBlockEnd).longValue();
                System.arraycopy(modBlock, pos, cachedBlock.fBlock, 0, length);
            }
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public MemoryByte[] getMemory(IMemory tcfMemoryService, IMemory.IMemoryDMContext context, IAddress address, int word_size, int count, long timeOutLimit) throws CoreException {
        LinkedList<MemoryBlock> missingBlocks;
        int numberOfRequests;
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{context, address.toHexAddressString(), word_size, count}));
        }
        if ((numberOfRequests = (missingBlocks = this.getListOfMissingBlocks(address, count)).size()) > 0 && tcfMemoryService == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", "Fail to read memory."));
        }
        int i = 0;
        while (i < numberOfRequests) {
            MemoryBlock block = missingBlocks.get(i);
            IAddress blockAddress = block.fAddress;
            int blockLength = (int)block.fLength;
            if (blockLength < this.minimumBlockSize) {
                blockLength = this.minimumBlockSize;
            }
            try {
                MemoryByte[] result = this.readBlock(tcfMemoryService, context, blockAddress, word_size, blockLength, timeOutLimit);
                MemoryBlock newBlock = new MemoryBlock(blockAddress, blockLength, result);
                this.memoryBlockList.add(newBlock);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Fail to read memory.", e.getCause()));
            }
            ++i;
        }
        MemoryByte[] result = this.getMemoryBlockFromCache(address, count);
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
        return result;
    }

    private IMemory.MemoryContext getTCFMemoryContext(final IMemory tcfMemoryService, final String contextID, long timeOutLimit) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        IMemory.MemoryContext ret = this.tcfMemoryContexts.get(contextID);
        if (ret != null) {
            return ret;
        }
        TCFTask<IMemory.MemoryContext> tcfTask = new TCFTask<IMemory.MemoryContext>(6000L){

            public void run() {
                tcfMemoryService.getContext(contextID, new IMemory.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
                        if (error == null) {
                            this.done(context);
                        } else {
                            this.error(error);
                        }
                    }
                });
            }
        };
        ret = (IMemory.MemoryContext)tcfTask.get(timeOutLimit, TimeUnit.MILLISECONDS);
        if (ret != null) {
            this.tcfMemoryContexts.put(contextID, ret);
        }
        return ret;
    }

    private MemoryByte[] readBlock(IMemory tcfMemoryService, IMemory.IMemoryDMContext context, final IAddress address, final int word_size, final int count, long timeOutLimit) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{context, address.toHexAddressString(), word_size, count}));
        }
        final IMemory.MemoryContext tcfMC = this.getTCFMemoryContext(tcfMemoryService, ((IEDCDMContext)context).getID(), timeOutLimit);
        MemoryByte[] result = null;
        TCFTask<MemoryByte[]> tcfTask = new TCFTask<MemoryByte[]>(6000L){

            public void run() {
                BigInteger tcfAddress = address.getValue();
                final byte[] buffer = new byte[word_size * count];
                tcfMC.get((Number)tcfAddress, word_size, buffer, 0, count * word_size, 0, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (error == null) {
                            MemoryByte[] res = new MemoryByte[buffer.length];
                            int i = 0;
                            while (i < buffer.length) {
                                res[i] = new MemoryByte(buffer[i]);
                                ++i;
                            }
                            this.done(res);
                        } else if (error instanceof IMemory.ErrorOffset) {
                            boolean someStatusKnown = false;
                            IMemory.ErrorOffset errorOffset = (IMemory.ErrorOffset)error;
                            MemoryByte[] res = new MemoryByte[buffer.length];
                            int i = 0;
                            while (i < buffer.length) {
                                byte flags = 35;
                                int st = errorOffset.getStatus(i);
                                if ((st & 1) != 0) {
                                    flags = 0;
                                } else {
                                    someStatusKnown = true;
                                    if ((st & 2) != 0) {
                                        flags = (byte)(flags & 0xFFFFFFFC);
                                    } else {
                                        if ((st & 4) != 0) {
                                            flags = (byte)(flags & 0xFFFFFFFD);
                                        }
                                        if ((st & 8) != 0) {
                                            flags = (byte)(flags & 0xFFFFFFFE);
                                        }
                                    }
                                }
                                res[i] = new MemoryByte(buffer[i], flags);
                                ++i;
                            }
                            if (someStatusKnown) {
                                this.done(res);
                            } else {
                                this.error((Throwable)error);
                            }
                        } else {
                            this.error((Throwable)error);
                        }
                    }
                });
            }
        };
        result = (MemoryByte[])tcfTask.get(timeOutLimit, TimeUnit.MILLISECONDS);
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
        return result;
    }

    public void setMemory(IMemory tcfMemoryService, IMemory.IMemoryDMContext context, IAddress address, long offset, int word_size, int count, byte[] buffer, long timeOutLimit) throws CoreException {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{context, address.toHexAddressString(), offset, word_size, count}));
        }
        try {
            this.writeBlock(tcfMemoryService, context, address, offset, word_size, count, buffer, timeOutLimit);
            if (this.blockIsCached(address.add(offset), word_size * count)) {
                MemoryByte[] update = this.readBlock(tcfMemoryService, context, address.add(offset), word_size, count, timeOutLimit);
                this.updateMemoryCache(address.add(offset), update.length, update);
            }
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", "Fail to write memory."));
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockIsCached(IAddress modBlockStart, int count) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{modBlockStart.toHexAddressString(), count}));
        }
        boolean cacheFound = false;
        SortedMemoryBlockList sortedMemoryBlockList = this.memoryBlockList;
        synchronized (sortedMemoryBlockList) {
            IAddress modBlockEnd = modBlockStart.add((long)count);
            ListIterator iter = this.memoryBlockList.listIterator();
            while (iter.hasNext()) {
                MemoryBlock cachedBlock = (MemoryBlock)iter.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLength);
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockEnd.distanceTo(cachedBlockEnd).longValue() >= 0L) {
                    cacheFound = true;
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockStart.distanceTo(cachedBlockEnd).longValue() > 0L) {
                    cacheFound = true;
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockEnd).longValue() <= 0L || modBlockEnd.distanceTo(cachedBlockEnd).longValue() < 0L) continue;
                cacheFound = true;
            }
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(cacheFound));
        }
        return cacheFound;
    }

    private void writeBlock(final IMemory tcfMemoryService, final IMemory.IMemoryDMContext context, final IAddress address, final long offset, final int word_size, final int count, final byte[] buffer, long timeOutLimit) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{context, address.toHexAddressString(), offset, word_size, count}));
        }
        TCFTask<MemoryByte[]> tcfTask = new TCFTask<MemoryByte[]>(6000L){

            public void run() {
                final 3 task = this;
                String memoryContextID = ((IEDCDMContext)context).getID();
                tcfMemoryService.getContext(memoryContextID, new IMemory.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
                        if (error == null) {
                            BigInteger tcfAddress = address.add(offset).getValue();
                            context.set((Number)tcfAddress, word_size, buffer, 0, count * word_size, 0, new IMemory.DoneMemory(){

                                public void doneMemory(IToken token, IMemory.MemoryError error) {
                                    if (error == null) {
                                        task.done(null);
                                    } else {
                                        task.error((Throwable)error);
                                    }
                                }
                            });
                        } else {
                            task.error((Throwable)error);
                        }
                    }
                });
            }
        };
        tcfTask.get(timeOutLimit, TimeUnit.MILLISECONDS);
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public boolean refreshMemory(IMemory tcfMemoryService, IMemory.IMemoryDMContext context, IAddress address, int offset, int word_size, int count, RequestMonitor rm, long timeOutLimit) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{context, address.toHexAddressString(), offset, count}));
        }
        boolean modified = false;
        LinkedList<MemoryBlock> list = this.getListOfMissingBlocks(address, count);
        int sizeToRead = 0;
        for (MemoryBlock block : list) {
            sizeToRead = (int)((long)sizeToRead + block.fLength);
        }
        if (sizeToRead == count) {
            rm.done();
            return false;
        }
        try {
            MemoryByte[] newBlock = this.readBlock(tcfMemoryService, context, address, word_size, count, timeOutLimit);
            MemoryByte[] oldBlock = this.getMemoryBlockFromCache(address, count);
            boolean blocksDiffer = false;
            int i = 0;
            while (i < oldBlock.length) {
                if (oldBlock[i].getValue() != newBlock[i].getValue()) {
                    blocksDiffer = true;
                    break;
                }
                ++i;
            }
            if (blocksDiffer) {
                this.updateMemoryCache(address, count, newBlock);
                modified = true;
            }
        }
        catch (Exception e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error Writing Memory", (Throwable)e));
        }
        rm.done();
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
        return modified;
    }

    @Override
    public void loadSnapshot(Element element) throws Exception {
        this.reset();
        NodeList blockElements = element.getElementsByTagName(MEMORY_BLOCK);
        int numBlocks = blockElements.getLength();
        int i = 0;
        while (i < numBlocks) {
            Element blockElement = (Element)blockElements.item(i);
            String blockAddress = blockElement.getAttribute(ATTR_ADDRESS);
            String blockLength = blockElement.getAttribute(ATTR_LENGTH);
            String blockValue = blockElement.getAttribute(ATTR_VALUE);
            MemoryByte[] blockBytes = MemoryUtils.convertHexStringToMemoryBytes(blockValue, blockValue.length() / 2, 2);
            MemoryBlock newBlock = new MemoryBlock((IAddress)new Addr64(blockAddress), Long.parseLong(blockLength), blockBytes);
            this.memoryBlockList.add(newBlock);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) {
        SortedMemoryBlockList sortedMemoryBlockList = this.memoryBlockList;
        synchronized (sortedMemoryBlockList) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.memoryBlockList.size());
            progress.subTask("Memory");
            Element memoryCacheElement = document.createElement(MEMORY_CACHE);
            ListIterator iter = this.memoryBlockList.listIterator();
            while (iter.hasNext()) {
                MemoryBlock block = (MemoryBlock)iter.next();
                Element blockElement = document.createElement(MEMORY_BLOCK);
                blockElement.setAttribute(ATTR_ADDRESS, block.fAddress.toHexAddressString());
                blockElement.setAttribute(ATTR_LENGTH, Long.toString(block.fLength));
                blockElement.setAttribute(ATTR_VALUE, MemoryUtils.convertMemoryBytesToHexString(block.fBlock));
                memoryCacheElement.appendChild(blockElement);
                progress.worked(1);
            }
            return memoryCacheElement;
        }
    }

    private class MemoryBlock {
        public IAddress fAddress;
        public long fLength;
        public MemoryByte[] fBlock;

        public MemoryBlock(IAddress fAddress, long fLength, MemoryByte[] fBlock) {
            this.fAddress = fAddress;
            this.fLength = fLength;
            this.fBlock = fBlock;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedMemoryBlockList
    extends LinkedList<MemoryBlock> {
        @Override
        public synchronized boolean add(MemoryBlock block) {
            if (EDCTrace.MEMORY_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{block.fAddress.toHexAddressString(), block.fLength}));
            }
            if (this.isEmpty()) {
                this.addFirst(block);
                return true;
            }
            ListIterator it = this.listIterator();
            while (it.hasNext()) {
                int index = it.nextIndex();
                MemoryBlock item = (MemoryBlock)it.next();
                if (block.fAddress.compareTo((Object)item.fAddress) >= 0) continue;
                this.add(index, block);
                this.compact(index);
                return true;
            }
            this.addLast(block);
            this.compact(this.size() - 1);
            if (EDCTrace.MEMORY_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
            return true;
        }

        private void compact(int index) {
            int lastIndex;
            if (EDCTrace.MEMORY_TRACE_ON) {
                EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{index}));
            }
            MemoryBlock newBlock = (MemoryBlock)this.get(index);
            if (index > 0) {
                long newLength;
                MemoryBlock prevBlock = (MemoryBlock)this.get(index - 1);
                IAddress endOfPreviousBlock = prevBlock.fAddress.add(prevBlock.fLength);
                if (endOfPreviousBlock.distanceTo(newBlock.fAddress).longValue() == 0L && (newLength = prevBlock.fLength + newBlock.fLength) <= Integer.MAX_VALUE) {
                    MemoryByte[] block = new MemoryByte[(int)newLength];
                    System.arraycopy(prevBlock.fBlock, 0, block, 0, (int)prevBlock.fLength);
                    System.arraycopy(newBlock.fBlock, 0, block, (int)prevBlock.fLength, (int)newBlock.fLength);
                    newBlock = new MemoryBlock(prevBlock.fAddress, newLength, block);
                    this.remove(index);
                    this.set(--index, newBlock);
                }
            }
            if (index < (lastIndex = this.size() - 1)) {
                long newLength;
                MemoryBlock nextBlock = (MemoryBlock)this.get(index + 1);
                IAddress endOfNewBlock = newBlock.fAddress.add(newBlock.fLength);
                if (endOfNewBlock.distanceTo(nextBlock.fAddress).longValue() == 0L && (newLength = newBlock.fLength + nextBlock.fLength) <= Integer.MAX_VALUE) {
                    MemoryByte[] block = new MemoryByte[(int)newLength];
                    System.arraycopy(newBlock.fBlock, 0, block, 0, (int)newBlock.fLength);
                    System.arraycopy(nextBlock.fBlock, 0, block, (int)newBlock.fLength, (int)nextBlock.fLength);
                    newBlock = new MemoryBlock(newBlock.fAddress, newLength, block);
                    this.set(index, newBlock);
                    this.remove(index + 1);
                }
            }
            if (EDCTrace.MEMORY_TRACE_ON) {
                EDCTrace.getTrace().traceExit(null);
            }
        }
    }
}

