/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.Scope;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompileUnitScope
extends Scope
implements ICompileUnitScope {
    protected IPath filePath;
    protected Collection<ILineEntry> lineEntries;

    public CompileUnitScope(IPath filePath, IModuleScope parent, IAddress lowAddress, IAddress highAddress) {
        super(filePath != null ? filePath.lastSegment() : "", lowAddress, highAddress, parent);
        this.filePath = filePath;
    }

    @Override
    public IPath getFilePath() {
        return this.filePath;
    }

    @Override
    public IFunctionScope getFunctionAtAddress(IAddress linkAddress) {
        IScope scope = this.getScopeAtAddress(linkAddress);
        while (scope != null && !(scope instanceof IFunctionScope)) {
            scope = scope.getParent();
        }
        return (IFunctionScope)scope;
    }

    @Override
    public Collection<IFunctionScope> getFunctions() {
        ArrayList<IFunctionScope> functions = new ArrayList<IFunctionScope>(this.children.size());
        for (IScope scope : this.getChildren()) {
            if (!(scope instanceof IFunctionScope)) continue;
            functions.add((IFunctionScope)scope);
        }
        return Collections.unmodifiableCollection(functions);
    }

    protected abstract Collection<ILineEntry> parseLineTable();

    @Override
    public Collection<ILineEntry> getLineEntries() {
        if (this.lineEntries == null) {
            this.lineEntries = this.parseLineTable();
        }
        return Collections.unmodifiableCollection(this.lineEntries);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompileUnitScope [");
        builder.append("lowAddress=");
        builder.append(this.lowAddress);
        builder.append(", highAddress=");
        builder.append(this.highAddress);
        builder.append(", ");
        if (this.filePath != null) {
            builder.append("path=");
            builder.append(this.filePath.toOSString());
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }
}

