/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.RegisterVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.SymbolsMessages;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.symbols.IRegisterOffsetVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.CoreException;

public class RegisterOffsetVariableLocation
extends RegisterVariableLocation
implements IRegisterOffsetVariableLocation {
    protected final long offset;
    private int addressSize;

    public RegisterOffsetVariableLocation(EDCServicesTracker tracker, IDMContext context, String name, int id, long offset) {
        super(tracker, context, name, id);
        this.offset = offset;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " + " + this.getOffset();
    }

    public long getOffset() {
        return this.offset;
    }

    public BigInteger readValue(int bytes) throws CoreException {
        BigInteger regval = super.readValue(bytes);
        return regval.add(BigInteger.valueOf(this.offset));
    }

    public IVariableLocation addOffset(long offset) {
        return new RegisterOffsetVariableLocation(this.tracker, this.context, this.name, this.id, offset + this.offset);
    }

    public String getLocationName() {
        try {
            if (this.addressSize == 0) {
                this.addressSize = 4;
                ITargetEnvironment targetEnvironment = this.tracker.getService(ITargetEnvironment.class);
                if (targetEnvironment != null) {
                    this.addressSize = targetEnvironment.getPointerSize();
                }
            }
            BigInteger regval = super.readValue(this.addressSize);
            regval = regval.add(BigInteger.valueOf(this.offset));
            return String.valueOf(SymbolsMessages.RegisterOffsetVariableLocation_Hex) + Long.toHexString(regval.longValue());
        }
        catch (CoreException coreException) {
            return String.valueOf(super.getLocationName()) + (this.offset < 0L ? SymbolsMessages.RegisterOffsetVariableLocation_Positive : SymbolsMessages.RegisterOffsetVariableLocation_Negative) + Math.abs(this.offset);
        }
    }

    public IAddress getAddress() {
        return null;
    }
}

