/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.SymbolsMessages;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.symbols.IValueVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.CoreException;

public class ValueVariableLocation
implements IValueVariableLocation {
    private BigInteger value;

    public ValueVariableLocation(BigInteger value) {
        this.value = value;
    }

    public String toString() {
        return "0x" + Long.toHexString(this.value.longValue());
    }

    public BigInteger readValue(int bytes) throws CoreException {
        if (this.value == null) {
            throw EDCDebugger.newCoreException(SymbolsMessages.ValueVariableLocation_NoValueAvailable);
        }
        return this.value;
    }

    public IVariableLocation addOffset(long offset) {
        return new ValueVariableLocation(this.value.add(BigInteger.valueOf(offset)));
    }

    public String getLocationName() {
        return "";
    }

    public IAddress getAddress() {
        return null;
    }

    public void writeValue(int bytes, BigInteger value) throws CoreException {
        throw EDCDebugger.newCoreException(SymbolsMessages.ValueVariableLocation_CannotModifyDerivedValue);
    }

    public IDMContext getContext() {
        return null;
    }

    public EDCServicesTracker getServicesTracker() {
        return null;
    }
}

