/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.services.IEDCService;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.debug.edc.services.Messages;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEDCService
extends AbstractDsfService
implements IEDCService {
    private final String[] classNames;
    private ITargetEnvironment targetEnvironmentService = null;
    private final boolean snapshot;
    private EDCServicesTracker fEDCTracker;

    public AbstractEDCService(DsfSession session, String[] classNames) {
        super(session);
        this.classNames = classNames;
        this.snapshot = Album.isSnapshotSession(session.getId());
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public EDCServicesTracker getEDCServicesTracker() {
        return this.fEDCTracker;
    }

    public <V> V getService(Class<V> serviceClass) {
        if (IEDCService.class.isAssignableFrom(serviceClass)) {
            return this.fEDCTracker.getService(serviceClass);
        }
        return (V)this.getServicesTracker().getService(serviceClass);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        this.fEDCTracker = new EDCServicesTracker(this.getBundleContext(), this.getSession().getId());
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleSuccess() {
                AbstractEDCService.this.doInitialize(requestMonitor);
            }
        });
    }

    public void shutdown(RequestMonitor rm) {
        this.fEDCTracker.dispose();
        this.fEDCTracker = null;
        super.shutdown(rm);
    }

    protected void doInitialize(RequestMonitor requestMonitor) {
        this.register(this.classNames, new Hashtable());
        if (this.targetEnvironmentService == null) {
            this.targetEnvironmentService = (ITargetEnvironment)this.getServicesTracker().getService(ITargetEnvironment.class);
        }
        requestMonitor.done();
    }

    protected BundleContext getBundleContext() {
        return EDCDebugger.getBundleContext();
    }

    public ITargetEnvironment getTargetEnvironmentService() {
        return this.targetEnvironmentService;
    }

    static String[] massageClassNames(String[] classNames, String[] implicitClassNames) {
        ArrayList<String> newClassNames = new ArrayList<String>(Arrays.asList(implicitClassNames));
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            if (!newClassNames.contains(className)) {
                newClassNames.add(className);
            }
            ++n2;
        }
        return newClassNames.toArray(new String[newClassNames.size()]);
    }

    protected void asyncExec(Runnable runnable, RequestMonitor rm) {
        try {
            ExecutorService executor = EDCLaunch.getThreadPool(this.getSession().getId());
            if (executor.isShutdown()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", "Session has been shutdown.", null));
                rm.done();
            } else {
                executor.execute(new SafeRunner(runnable, rm));
            }
        }
        catch (RejectedExecutionException exc) {
            String msg = Messages.AbstractEDCService_0;
            EDCDebugger.getMessageLogger().log(2, msg, exc);
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", msg, (Throwable)exc));
            rm.done();
            throw exc;
        }
    }

    private class SafeRunner
    implements Runnable {
        private Runnable fCode;
        private RequestMonitor fRm;

        SafeRunner(Runnable code, RequestMonitor rm) {
            this.fCode = code;
            this.fRm = rm;
            Assert.isNotNull((Object)code);
        }

        public void run() {
            try {
                this.fCode.run();
            }
            catch (Exception e) {
                this.handleException(this.fCode, e);
            }
            catch (LinkageError e) {
                this.handleException(this.fCode, e);
            }
            catch (AssertionError e) {
                this.handleException(this.fCode, (Throwable)((Object)e));
            }
        }

        private void handleException(Runnable code, Throwable e) {
            Status status;
            if (!(e instanceof OperationCanceledException)) {
                if (e instanceof CoreException) {
                    status = new MultiStatus("org.eclipse.cdt.debug.edc", -1, Messages.AbstractEDCService_1, e);
                    ((MultiStatus)status).merge(((CoreException)e).getStatus());
                } else {
                    status = new Status(4, "org.eclipse.cdt.debug.edc", -1, Messages.AbstractEDCService_2, e);
                }
                EDCDebugger.getMessageLogger().log((IStatus)status);
            } else {
                status = new Status(4, "org.eclipse.cdt.debug.edc", -1, Messages.AbstractEDCService_3, e);
            }
            if (this.fRm != null) {
                this.fRm.setStatus((IStatus)status);
                this.fRm.done();
            }
        }
    }
}

