/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.IDsfService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DMContext
extends AbstractDMContext
implements IEDCDMContext {
    protected Map<String, Object> properties = Collections.synchronizedMap(new HashMap());
    private String id;

    public DMContext(IDsfService service, IDMContext[] parents, String name, String id) {
        super(service, parents);
        this.properties.put("Name", name);
        this.properties.put("ID", id);
        this.id = id;
    }

    public DMContext(String sessionId, IDMContext[] parents, String id) {
        super(sessionId, parents);
        this.properties.put("Name", id);
        this.properties.put("ID", id);
        this.id = id;
    }

    public DMContext(IDsfService service, IDMContext[] parents, String id, Map<String, Object> props) {
        super(service, parents);
        if (props != null) {
            this.properties.putAll(props);
            this.id = id;
            this.properties.put("ID", id);
        }
    }

    public DMContext(String sessionId, IDMContext[] parents, Map<String, Object> props) {
        super(sessionId, parents);
        if (props != null) {
            this.properties.putAll(props);
            this.id = (String)this.properties.get("ID");
        }
    }

    public DMContext(IDsfService service, IDMContext[] parents, Map<String, Object> props) {
        super(service, parents);
        if (props != null) {
            this.properties.putAll(props);
            this.id = (String)this.properties.get("ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String key) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = this.properties;
        synchronized (map) {
            result.putAll(this.properties);
        }
        return result;
    }

    @Override
    public String getName() {
        return (String)this.getProperty("Name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.put("Name", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, Object object) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.put(name, object);
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DMContext) {
            return super.baseEquals(obj) && this.getID().equals(((IEDCDMContext)obj).getID());
        }
        return false;
    }

    public int hashCode() {
        return super.baseHashCode() ^ this.getID().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DMContext [");
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.properties != null) {
            builder.append("properties=");
            builder.append(this.properties);
        }
        builder.append("]");
        return builder.toString();
    }
}

