/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.testplugin;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class CDebugHelper {
    public static ICDISession createSession(String exe) throws IOException, MIException {
        String os = System.getProperty("os.name");
        MIPlugin mi = MIPlugin.getDefault();
        String exename = Platform.getPlugin((String)"org.eclipse.cdt.debug.ui.tests").find((IPath)new Path("/")).getFile();
        exename = String.valueOf(exename) + "core/org/eclipse/cdt/debug/core/tests/resources/";
        if ((os = os.toLowerCase()).indexOf("windows") != -1) {
            exename = String.valueOf(exename) + "win/" + exe + ".exe";
        } else if (os.indexOf("qnx") != -1) {
            exename = String.valueOf(exename) + "qnx/" + exe;
        } else if (os.indexOf("linux") != -1) {
            exename = String.valueOf(exename) + "linux/" + exe;
        } else if (os.indexOf("sol") != -1) {
            exename = String.valueOf(exename) + "sol/" + exe;
        } else {
            return null;
        }
        Session session = mi.createCSession(null, "mi1", new File(exename), new File("."), null, null);
        return session;
    }

    public static ICDISession createSession(String exe, ICProject project) throws IOException, MIException, CModelException {
        String workspacePath = Platform.getLocation().toOSString();
        MIPlugin mi = MIPlugin.getDefault();
        try {
            project.getProject().refreshLocal(2, null);
        }
        catch (Exception exception) {}
        IBinary[] bins = project.getBinaryContainer().getBinaries();
        if (bins.length != 1) {
            return null;
        }
        Session session = mi.createCSession(null, "mi1", new File(String.valueOf(workspacePath) + bins[0].getPath().toOSString()), new File("."), null, null);
        return session;
    }
}

