/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.testplugin.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.debug.testplugin.util.ExpectedStrings;

public class ExpectedStringsTests
extends TestCase {
    public ExpectedStringsTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static TestSuite suite() {
        return new TestSuite(ExpectedStringsTests.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ExpectedStringsTests.suite());
    }

    public void testGotAll() {
        String[] strings = new String[]{"stringOne", "stringTwo", "stringThree"};
        ExpectedStrings myExp = new ExpectedStrings(strings);
        ExpectedStringsTests.assertTrue((String)"No found strings", (!myExp.gotAll() ? 1 : 0) != 0);
        myExp.foundString("stringOne");
        ExpectedStringsTests.assertTrue((String)"1 found strings", (!myExp.gotAll() ? 1 : 0) != 0);
        myExp.foundString("stringTwo");
        ExpectedStringsTests.assertTrue((String)"2 found strings", (!myExp.gotAll() ? 1 : 0) != 0);
        myExp.foundString("stringThree");
        ExpectedStringsTests.assertTrue((String)"All found strings", (boolean)myExp.gotAll());
    }

    public void testGotExtra() {
        String[] strings = new String[]{"stringOne", "stringTwo", "stringThree"};
        ExpectedStrings myExp = new ExpectedStrings(strings);
        ExpectedStringsTests.assertTrue((String)"No found strings", (!myExp.gotExtra() ? 1 : 0) != 0);
        myExp.foundString("stringOne");
        ExpectedStringsTests.assertTrue((String)"1 found strings", (!myExp.gotExtra() ? 1 : 0) != 0);
        myExp.foundString("stringTwo");
        ExpectedStringsTests.assertTrue((String)"2 found strings", (!myExp.gotExtra() ? 1 : 0) != 0);
        myExp.foundString("stringThree");
        ExpectedStringsTests.assertTrue((String)"All found strings", (!myExp.gotExtra() ? 1 : 0) != 0);
        myExp.foundString("Somerandomestring");
        ExpectedStringsTests.assertTrue((String)"Extra String", (boolean)myExp.gotExtra());
    }

    public void testGetMissingString() {
        String[] strings = new String[]{"stringOne", "stringTwo", "stringThree"};
        ExpectedStrings myExp = new ExpectedStrings(strings);
        ExpectedStringsTests.assertNotNull((Object)myExp.getMissingString());
        myExp.foundString("stringOne");
        ExpectedStringsTests.assertNotNull((Object)myExp.getMissingString());
        myExp.foundString("stringTwo");
        ExpectedStringsTests.assertNotNull((Object)myExp.getMissingString());
        myExp.foundString("stringThree");
        ExpectedStringsTests.assertNotNull((Object)myExp.getMissingString());
    }

    public void testGetExtraString() {
        String[] strings = new String[]{"stringOne", "stringTwo", "stringThree"};
        ExpectedStrings myExp = new ExpectedStrings(strings);
        ExpectedStringsTests.assertNotNull((Object)myExp.getExtraString());
        myExp.foundString("stringOnenot");
        ExpectedStringsTests.assertNotNull((Object)myExp.getMissingString());
        myExp.foundString("stringTwonot");
        ExpectedStringsTests.assertNotNull((Object)myExp.getMissingString());
    }
}

