/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpointactions.IBreakpointActionPage;
import org.eclipse.cdt.debug.ui.breakpointactions.SoundAction;
import org.eclipse.cdt.debug.ui.breakpointactions.SoundActionComposite;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class SoundActionPage
extends PlatformObject
implements IBreakpointActionPage {
    private static final String SOUND_ACTION_RECENT = "SoundBehaviorDialog.recentSounds";
    private SoundActionComposite editor = null;
    private String mediaPath = "";
    private ArrayList recentSounds = new ArrayList();
    private SoundAction soundAction;

    private static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("win");
    }

    private static boolean isMacOS() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("mac");
    }

    public SoundActionPage() {
        if (SoundActionPage.isWindows()) {
            this.mediaPath = "C:\\WINNT\\Media\\";
        }
        if (SoundActionPage.isMacOS()) {
            this.mediaPath = "/System/Library/Sounds";
        }
        this.loadRecentSounds();
    }

    public void actionDialogCanceled() {
    }

    public void actionDialogOK() {
        this.saveRecentSounds();
        this.soundAction.setSoundFile(this.editor.getSoundFile());
    }

    public void addRecentSound(File soundFile) {
        String soundFilePath = soundFile.getAbsolutePath();
        int removeIndex = -1;
        int fileCount = 0;
        Iterator iter = this.recentSounds.iterator();
        while (iter.hasNext() && removeIndex < 0) {
            File element = (File)iter.next();
            if (element.getAbsolutePath().equals(soundFilePath)) {
                removeIndex = fileCount;
            }
            ++fileCount;
        }
        if (removeIndex >= 0) {
            this.recentSounds.remove(removeIndex);
        }
        this.recentSounds.add(soundFile);
        if (this.recentSounds.size() > 10) {
            this.recentSounds.remove(0);
        }
    }

    public Composite createComposite(IBreakpointAction action, Composite composite, int style) {
        this.soundAction = (SoundAction)action;
        this.loadRecentSounds();
        if (this.soundAction.getSoundFile() == null && this.recentSounds.size() > 0) {
            this.soundAction.setSoundFile((File)this.recentSounds.get(0));
        }
        this.editor = new SoundActionComposite(composite, style, this);
        return this.editor;
    }

    public String getMediaPath() {
        return this.mediaPath;
    }

    public ArrayList getRecentSounds() {
        return this.recentSounds;
    }

    public String getSummary() {
        if (this.soundAction.getSoundFile() == null) {
            return "";
        }
        return this.soundAction.getSoundFile().getAbsolutePath();
    }

    private void initializeRecentSounds() {
        if (SoundActionPage.isWindows()) {
            String[] defaultSounds = new String[]{"chimes.wav", "chord.wav", "ding.wav", "notify.wav", "tada.wav"};
            int i = 0;
            while (i < defaultSounds.length) {
                File soundFile = new File(String.valueOf(this.mediaPath) + defaultSounds[i]);
                if (soundFile.exists()) {
                    this.recentSounds.add(soundFile);
                }
                ++i;
            }
        }
        if (SoundActionPage.isMacOS()) {
            File macSounds = new File(this.mediaPath);
            File[] soundFiles = macSounds.listFiles();
            int i = 0;
            while (i < soundFiles.length) {
                String fileExtension = new Path(soundFiles[i].getAbsolutePath()).getFileExtension();
                if (fileExtension.equalsIgnoreCase("aiff") || fileExtension.equalsIgnoreCase("wav")) {
                    this.recentSounds.add(soundFiles[i]);
                }
                ++i;
            }
        }
        this.saveRecentSounds();
    }

    private void loadRecentSounds() {
        String recentSoundData = CDebugUIPlugin.getDefault().getPreferenceStore().getString(SOUND_ACTION_RECENT);
        if (recentSoundData == null || recentSoundData.length() == 0) {
            this.initializeRecentSounds();
            return;
        }
        this.recentSounds = new ArrayList();
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(recentSoundData))).getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int entryCount = nodeList.getLength();
            int i = 0;
            while (i < entryCount) {
                Element subElement;
                String nodeName;
                Node node = nodeList.item(i);
                short type = node.getNodeType();
                if (type == 1 && (nodeName = (subElement = (Element)node).getNodeName()).equalsIgnoreCase("soundFileName")) {
                    String value = subElement.getAttribute("name");
                    if (value == null) {
                        throw new Exception();
                    }
                    File soundFile = new File(value);
                    if (soundFile.exists()) {
                        this.recentSounds.add(soundFile);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.recentSounds.size() == 0) {
            this.initializeRecentSounds();
        }
    }

    public void saveRecentSounds() {
        String recentSoundData = "";
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("recentSounds");
            doc.appendChild(rootElement);
            for (File soundFile : this.recentSounds) {
                Element element = doc.createElement("soundFileName");
                element.setAttribute("name", soundFile.getAbsolutePath());
                rootElement.appendChild(element);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            recentSoundData = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CDebugUIPlugin.getDefault().getPreferenceStore().setValue(SOUND_ACTION_RECENT, recentSoundData);
    }

    public SoundAction getSoundAction() {
        return this.soundAction;
    }
}

