/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractContainerVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbPinProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.GdbExecutionContextLabelText;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.MessagesForGdbLaunchVM;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMDelegatingPropertiesUpdate;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.IMemento;

public class ContainerVMNode
extends AbstractContainerVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private final String MEMENTO_NAME = "CONTAINER_MEMENTO_NAME";

    public ContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "ContainerVMNode(" + this.getSession().getId() + ")";
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new GdbExecutionContextLabelText(MessagesForGdbLaunchVM.ContainerVMNode_No_columns__text_format, new String[]{"name_known", "name", "id_known", "id", "cores_id_known", "cores_id"}), new LabelText(MessagesForGdbLaunchVM.ContainerVMNode_No_columns__Error__label, new String[0]), new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.FALSE.equals(properties.get("is_suspended"));
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_SUSPENDED"))}));
        return provider;
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        ICommandControlService controlService = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        if (processService == null || controlService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        processService.getProcessesBeingDebugged((IDMContext)controlService.getContext(), (DataRequestMonitor)new ViewerDataRequestMonitor<IDMContext[]>(this.getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    ContainerVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                if (this.getData() != null) {
                    ContainerVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                }
                update.done();
            }
        });
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] parentUpdates = new IPropertiesUpdate[updates.length];
        int i = 0;
        while (i < updates.length) {
            final IPropertiesUpdate update = updates[i];
            final ViewerCountingRequestMonitor countringRm = new ViewerCountingRequestMonitor(ImmediateExecutor.getInstance(), (IViewerUpdate)updates[i]);
            int count = 0;
            parentUpdates[i] = new VMDelegatingPropertiesUpdate(updates[i], (RequestMonitor)countringRm);
            ++count;
            IDMContext dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IDMContext.class);
            IPinProvider.IPinElementColorDescriptor colorDesc = PinCloneUtils.getPinElementColorDescriptor(GdbPinProvider.getPinnedHandles(), (Object)dmc);
            updates[i].setProperty("pin_color", colorDesc != null ? Integer.valueOf(colorDesc.getOverlayColor()) : null);
            updates[i].setProperty("pinned_context", (Object)PinCloneUtils.isPinnedTo(GdbPinProvider.getPinnedHandles(), (Object)dmc));
            if (update.getProperties().contains("name") || update.getProperties().contains("id") || update.getProperties().contains("cores_id")) {
                IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
                IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IProcessDMContext.class);
                if (processService == null || procDmc == null) {
                    update.setStatus(DsfUIPlugin.newErrorStatus((int)10002, (String)"Service or handle invalid", null));
                } else {
                    processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>(this.getExecutor(), (IViewerUpdate)update){

                        public void handleCompleted() {
                            if (this.isSuccess()) {
                                ContainerVMNode.this.fillThreadDataProperties(update, (IProcesses.IThreadDMData)this.getData());
                            } else {
                                update.setStatus(this.getStatus());
                            }
                            countringRm.done();
                        }
                    });
                    ++count;
                }
            }
            countringRm.setDoneCount(count);
            ++i;
        }
        super.updatePropertiesInSessionThread(parentUpdates);
    }

    protected void fillThreadDataProperties(IPropertiesUpdate update, IProcesses.IThreadDMData data) {
        String[] cores;
        update.setProperty("name", (Object)data.getName());
        update.setProperty("id", (Object)data.getId());
        String coresStr = null;
        if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
            StringBuffer str = new StringBuffer();
            String[] stringArray = cores;
            int n = cores.length;
            int n2 = 0;
            while (n2 < n) {
                String core = stringArray[n2];
                str.append(String.valueOf(core) + ",");
                ++n2;
            }
            if (str.length() > 0) {
                coresStr = str.substring(0, str.length() - 1);
            }
        }
        update.setProperty("cores_id", coresStr);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return 1024;
        }
        return super.getDeltaFlags(e);
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (!(e instanceof ICommandControlService.ICommandControlShutdownDMEvent)) {
            super.buildDelta(e, parentDelta, nodeOffset, requestMonitor);
            return;
        }
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        requestMonitor.done();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            final IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            String mementoName = memento.getString("CONTAINER_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            } else {
                request.done();
            }
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            final IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            } else {
                request.done();
            }
            ++n2;
        }
    }
}

