/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugNewProcessSequence
extends ReflectionSequence {
    private static final String INVALID = "invalid";
    private IGDBControl fCommandControl;
    private CommandFactory fCommandFactory;
    private IGDBBackend fBackend;
    private IGDBProcesses fProcService;
    private DsfServicesTracker fTracker;
    private IDMContext fContext;
    private String fBinaryName;
    private Map<String, Object> fAttributes;
    private IMIContainerDMContext fContainerCtx;
    private DataRequestMonitor<IDMContext> fDataRequestMonitor;

    protected IMIContainerDMContext getContainerContext() {
        return this.fContainerCtx;
    }

    protected void setContainerContext(IMIContainerDMContext ctx) {
        this.fContainerCtx = ctx;
    }

    public DebugNewProcessSequence(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        super(executor, rm);
        this.fContext = dmc;
        this.fBinaryName = file;
        this.fAttributes = attributes;
        this.fDataRequestMonitor = rm;
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            return new String[]{"stepInitializeBaseSequence", "stepSetEnvironmentVariables", "stepSetExecutable", "stepSetArguments", "stepRemoteConnection", "stepSpecifyCoreFile", "stepStartTrackingBreakpoints", "stepStartExecution", "stepCleanupBaseSequence"};
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeBaseSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fContext.getSessionId());
        this.fBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.fTracker.getService(IMICommandControl.class)).getCommandFactory();
        this.fProcService = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        if (this.fBackend == null || this.fCommandControl == null || this.fCommandFactory == null || this.fProcService == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Cannot obtain service", null));
            rm.done();
            return;
        }
        this.setContainerContext(this.fProcService.createContainerContextFromGroupId(this.fCommandControl.getContext(), ""));
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeBaseSequence")
    public void rollBackInitializeBaseSequence(RequestMonitor rm) {
        if (this.fTracker != null) {
            this.fTracker.dispose();
        }
        this.fTracker = null;
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepSetEnvironmentVariables(RequestMonitor rm) {
        boolean clear = false;
        Properties properties = new Properties();
        try {
            clear = this.fBackend.getClearEnvironment();
            properties = this.fBackend.getEnvironmentVariables();
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Cannot get environment information", (Throwable)e));
            rm.done();
            return;
        }
        if (clear || properties.size() > 0) {
            this.fCommandControl.setEnvironment(properties, clear, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetExecutable(RequestMonitor rm) {
        boolean noFileCommand = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.USE_SOLIB_SYMBOLS_FOR_APP", (Object)false);
        if (!noFileCommand && this.fBinaryName != null && this.fBinaryName.length() > 0) {
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIFileExecAndSymbols(this.getContainerContext(), this.fBinaryName), new DataRequestMonitor(ImmediateExecutor.getInstance(), rm));
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetArguments(RequestMonitor rm) {
        try {
            String args = this.fBackend.getProgramArguments();
            if (args != null) {
                String[] argArray = args.replaceAll("\n", " ").split(" ");
                this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetArgs(this.getContainerContext(), argArray), new DataRequestMonitor(ImmediateExecutor.getInstance(), rm));
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Cannot get inferior arguments", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepRemoteConnection(RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.REMOTE && !this.fBackend.getIsAttachSession()) {
            boolean isTcpConnection = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.REMOTE_TCP", (Object)false);
            if (isTcpConnection) {
                String remoteTcpHost = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.HOST", (Object)INVALID);
                String remoteTcpPort = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.PORT", (Object)INVALID);
                this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetSelect((IDMContext)this.fCommandControl.getContext(), remoteTcpHost, remoteTcpPort, false), new DataRequestMonitor(ImmediateExecutor.getInstance(), rm));
            } else {
                String serialDevice = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.DEV", (Object)INVALID);
                this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetSelect((IDMContext)this.fCommandControl.getContext(), serialDevice, false), new DataRequestMonitor(ImmediateExecutor.getInstance(), rm));
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSpecifyCoreFile(final RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            String coreFile = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.launch.COREFILE_PATH", (Object)"");
            final String coreType = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", (Object)"CORE_FILE");
            if (coreFile.length() == 0) {
                new PromptForCoreJob("Prompt for post mortem file", new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

                    protected void handleCancel() {
                        rm.cancel();
                        rm.done();
                    }

                    protected void handleSuccess() {
                        String newCoreFile = (String)this.getData();
                        if (newCoreFile == null || newCoreFile.length() == 0) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get post mortem file path", null));
                            rm.done();
                        } else if (coreType.equals("CORE_FILE")) {
                            DebugNewProcessSequence.this.fCommandControl.queueCommand(DebugNewProcessSequence.this.fCommandFactory.createMITargetSelectCore((IDMContext)DebugNewProcessSequence.this.fCommandControl.getContext(), newCoreFile), new DataRequestMonitor((Executor)DebugNewProcessSequence.this.getExecutor(), rm));
                        } else if (coreType.equals("TRACE_FILE")) {
                            IGDBTraceControl traceControl = (IGDBTraceControl)DebugNewProcessSequence.this.fTracker.getService(IGDBTraceControl.class);
                            if (traceControl != null) {
                                IGDBTraceControl.ITraceTargetDMContext targetDmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)DebugNewProcessSequence.this.fCommandControl.getContext(), IGDBTraceControl.ITraceTargetDMContext.class);
                                traceControl.loadTraceData(targetDmc, newCoreFile, rm);
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Tracing not supported", null));
                                rm.done();
                            }
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Invalid post-mortem type", null));
                            rm.done();
                        }
                    }
                }).schedule();
            } else if (coreType.equals("CORE_FILE")) {
                this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetSelectCore((IDMContext)this.fCommandControl.getContext(), coreFile), new DataRequestMonitor((Executor)this.getExecutor(), rm));
            } else if (coreType.equals("TRACE_FILE")) {
                IGDBTraceControl traceControl = (IGDBTraceControl)this.fTracker.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    IGDBTraceControl.ITraceTargetDMContext targetDmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fCommandControl.getContext(), IGDBTraceControl.ITraceTargetDMContext.class);
                    traceControl.loadTraceData(targetDmc, coreFile, rm);
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Tracing not supported", null));
                    rm.done();
                }
            } else {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Invalid post-mortem type", null));
                rm.done();
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBreakpoints(RequestMonitor rm) {
        if (this.fBackend.getSessionType() != SessionType.CORE) {
            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)this.fTracker.getService(MIBreakpointsManager.class));
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContainerContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            bpmService.startTrackingBreakpoints(bpTargetDmc, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepStartExecution(final RequestMonitor rm) {
        if (this.fBackend.getSessionType() != SessionType.CORE) {
            this.fAttributes.put("org.eclipse.cdt.launch.PROGRAM_NAME", this.fBinaryName);
            this.fProcService.start(this.getContainerContext(), this.fAttributes, new DataRequestMonitor<IRunControl.IContainerDMContext>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    if (!$assertionsDisabled && !(this.getData() instanceof IMIContainerDMContext)) {
                        throw new AssertionError();
                    }
                    DebugNewProcessSequence.this.setContainerContext((IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMContext)this.getData()), IMIContainerDMContext.class));
                    DebugNewProcessSequence.this.fDataRequestMonitor.setData((Object)DebugNewProcessSequence.this.getContainerContext());
                    rm.done();
                }
            });
        } else {
            this.fDataRequestMonitor.setData((Object)this.getContainerContext());
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepCleanupBaseSequence(RequestMonitor rm) {
        this.fTracker.dispose();
        this.fTracker = null;
        rm.done();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PromptForCoreJob
    extends Job {
        protected DataRequestMonitor<String> fRequestMonitor;

        public PromptForCoreJob(String name, DataRequestMonitor<String> rm) {
            super(name);
            this.fRequestMonitor = rm;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Status promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
            Status filePrompt = new Status(1, "org.eclipse.cdt.dsf.gdb.ui", 1001, "", null);
            IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)promptStatus);
            Status NO_CORE_STATUS = new Status(4, "org.eclipse.cdt.dsf.gdb", -1, LaunchMessages.getString("LocalCDILaunchDelegate.6"), null);
            if (prompter == null) {
                this.fRequestMonitor.setStatus((IStatus)NO_CORE_STATUS);
                this.fRequestMonitor.done();
                return Status.OK_STATUS;
            }
            try {
                Object result = prompter.handleStatus((IStatus)filePrompt, null);
                if (result == null) {
                    this.fRequestMonitor.cancel();
                } else if (result instanceof String) {
                    this.fRequestMonitor.setData((Object)((String)result));
                } else {
                    this.fRequestMonitor.setStatus((IStatus)NO_CORE_STATUS);
                }
            }
            catch (CoreException coreException) {
                this.fRequestMonitor.setStatus((IStatus)NO_CORE_STATUS);
            }
            this.fRequestMonitor.done();
            return Status.OK_STATUS;
        }
    }
}

