/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.service.command.events.MITracepointSelectedEvent;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MICatchpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIErrorEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIRunningEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISharedLibEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadCreatedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBRunControl_7_0_NS
extends AbstractDsfService
implements IMIRunControl,
ICachingService {
    private ICommandControlService fConnection;
    private CommandFactory fCommandFactory;
    private IProcesses fProcessService;
    private boolean fTerminated = false;
    protected Map<IMIExecutionDMContext, MIThreadRunState> fThreadRunStates = new HashMap<IMIExecutionDMContext, MIThreadRunState>();
    private RunToLineActiveOperation fRunToLineActiveOperation = null;
    private Set<IMIExecutionDMContext> fDisableNextRunningEventDmcSet = new HashSet<IMIExecutionDMContext>();
    private Set<IMIExecutionDMContext> fDisableNextSignalEventDmcSet = new HashSet<IMIExecutionDMContext>();
    private Map<IMIExecutionDMContext, MIStoppedEvent> fSilencedSignalEventMap = new HashMap<IMIExecutionDMContext, MIStoppedEvent>();
    private boolean fRunControlOperationsEnabled = true;
    private Set<IMIExecutionDMContext> fExecutionDmcToSuspendSet = new HashSet<IMIExecutionDMContext>();
    private boolean fOngoingOperation;
    private boolean fCurrentlyExecutingSteps;
    private MultiRequestMonitor<RequestMonitor> fExecuteQueuedOpsStepMonitor;
    private int fNumStepsStillExecuting;
    private LinkedList<TargetAvailableOperationInfo> fOperationsPending = new LinkedList();

    protected RunToLineActiveOperation getRunToLineActiveOperation() {
        return this.fRunToLineActiveOperation;
    }

    protected void setRunToLineActiveOperation(RunToLineActiveOperation operation) {
        this.fRunToLineActiveOperation = operation;
    }

    public GDBRunControl_7_0_NS(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), rm){

            protected void handleSuccess() {
                GDBRunControl_7_0_NS.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.register(new String[]{IRunControl.class.getName(), IRunControl2.class.getName(), IMIRunControl.class.getName()}, new Hashtable());
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fProcessService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        this.getSession().addServiceEventListener((Object)this, null);
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(rm);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public boolean isSuspended(IRunControl.IExecutionDMContext context) {
        if (context instanceof IMIExecutionDMContext) {
            MIThreadRunState threadState = this.fThreadRunStates.get(context);
            return threadState == null ? false : !this.fTerminated && threadState.fSuspended;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            boolean hasThread = false;
            for (IMIExecutionDMContext threadContext : this.fThreadRunStates.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)threadContext, (IDMContext)context)) continue;
                hasThread = true;
                if (!this.isSuspended(threadContext)) continue;
                return true;
            }
            if (!hasThread) {
                return true;
            }
        }
        return false;
    }

    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (!this.fRunControlOperationsEnabled) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (context instanceof IMIExecutionDMContext) {
            rm.setData((Object)this.doCanSuspend(context));
            rm.done();
            return;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            boolean canSuspend = false;
            for (IMIExecutionDMContext threadContext : this.fThreadRunStates.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)threadContext, (IDMContext)context)) continue;
                canSuspend |= this.doCanSuspend(threadContext);
            }
            rm.setData((Object)canSuspend);
            rm.done();
            return;
        }
        rm.setData((Object)false);
        rm.done();
    }

    private boolean doCanSuspend(IRunControl.IExecutionDMContext context) {
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        return threadState == null ? false : !this.fTerminated && !threadState.fSuspended;
    }

    public void suspend(IRunControl.IExecutionDMContext context, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext thread = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (thread != null) {
            this.doSuspendThread(thread, rm);
            return;
        }
        IMIContainerDMContext container = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIContainerDMContext.class);
        if (container != null) {
            this.doSuspendContainer(container, rm);
            return;
        }
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Invalid context type.", null));
        rm.done();
    }

    private void doSuspendThread(IMIExecutionDMContext context, RequestMonitor rm) {
        if (!this.doCanSuspend(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + ", is already suspended.", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createMIExecInterrupt(context), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    private void doSuspendContainer(IMIContainerDMContext context, RequestMonitor rm) {
        String groupId = context.getGroupId();
        this.fConnection.queueCommand(this.fCommandFactory.createMIExecInterrupt((IRunControl.IExecutionDMContext)context, groupId), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (!this.fRunControlOperationsEnabled) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (context instanceof IMIExecutionDMContext) {
            rm.setData((Object)this.doCanResume(context));
            rm.done();
            return;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            boolean canSuspend = false;
            for (IMIExecutionDMContext threadContext : this.fThreadRunStates.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)threadContext, (IDMContext)context)) continue;
                canSuspend |= this.doCanResume(threadContext);
            }
            rm.setData((Object)canSuspend);
            rm.done();
            return;
        }
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Invalid context type.", null));
        rm.done();
    }

    private boolean doCanResume(IRunControl.IExecutionDMContext context) {
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        return threadState == null ? false : !this.fTerminated && threadState.fSuspended && !threadState.fResumePending;
    }

    public void resume(IRunControl.IExecutionDMContext context, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext thread = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (thread != null) {
            this.doResumeThread(thread, rm);
            return;
        }
        IMIContainerDMContext container = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIContainerDMContext.class);
        if (container != null) {
            this.doResumeContainer(container, rm);
            return;
        }
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Invalid context type.", null));
        rm.done();
    }

    private void doResumeThread(IMIExecutionDMContext context, RequestMonitor rm) {
        if (!this.doCanResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + ", is already running.", null));
            rm.done();
            return;
        }
        final MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + " can't be found.", null));
            rm.done();
            return;
        }
        threadState.fResumePending = true;
        this.fConnection.queueCommand(this.fCommandFactory.createMIExecContinue(context), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleFailure() {
                threadState.fResumePending = false;
                super.handleFailure();
            }
        });
    }

    private void doResumeContainer(IMIContainerDMContext context, RequestMonitor rm) {
        String groupId = context.getGroupId();
        this.fConnection.queueCommand(this.fCommandFactory.createMIExecContinue((IRunControl.IExecutionDMContext)context, groupId), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    public boolean isStepping(IRunControl.IExecutionDMContext context) {
        if (context instanceof IMIExecutionDMContext) {
            MIThreadRunState threadState = this.fThreadRunStates.get(context);
            return threadState == null ? false : !this.fTerminated && threadState.fStepping;
        }
        return false;
    }

    public void canStep(final IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, final DataRequestMonitor<Boolean> rm) {
        if (!this.fRunControlOperationsEnabled) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (context instanceof IMIExecutionDMContext) {
            MIStack stackService;
            if (stepType == IRunControl.StepType.STEP_RETURN && (stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class))) != null) {
                stackService.getStackDepth((IDMContext)context, 2, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

                    public void handleCompleted() {
                        if (this.isSuccess() && (Integer)this.getData() == 1) {
                            rm.setData((Object)false);
                            rm.done();
                        } else {
                            GDBRunControl_7_0_NS.this.canResume(context, (DataRequestMonitor<Boolean>)rm);
                        }
                    }
                });
                return;
            }
            this.canResume(context, rm);
            return;
        }
        rm.setData((Object)false);
        rm.done();
    }

    public void step(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        if (!this.doCanResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        final MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + " can't be found.", null));
            rm.done();
            return;
        }
        ICommand<MIInfo> cmd = null;
        switch (stepType) {
            case STEP_INTO: {
                cmd = this.fCommandFactory.createMIExecStep(dmc);
                break;
            }
            case STEP_OVER: {
                cmd = this.fCommandFactory.createMIExecNext(dmc);
                break;
            }
            case STEP_RETURN: {
                MIStack stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class));
                if (stackService != null) {
                    IStack.IFrameDMContext topFrameDmc = stackService.createFrameDMContext(dmc, 0);
                    cmd = this.fCommandFactory.createMIExecFinish(topFrameDmc);
                    break;
                }
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot create context for command, stack service not available.", null));
                rm.done();
                return;
            }
            case INSTRUCTION_STEP_INTO: {
                cmd = this.fCommandFactory.createMIExecStepInstruction(dmc);
                break;
            }
            case INSTRUCTION_STEP_OVER: {
                cmd = this.fCommandFactory.createMIExecNextInstruction(dmc);
                break;
            }
            default: {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given step type not supported", null));
                rm.done();
                return;
            }
        }
        threadState.fResumePending = true;
        threadState.fStepping = true;
        this.fConnection.queueCommand(cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleFailure() {
                threadState.fResumePending = false;
                threadState.fStepping = false;
                super.handleFailure();
            }
        });
    }

    private void runToLocation(IRunControl.IExecutionDMContext context, final String location, final boolean skipBreakpoints, final RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        if (!this.doCanResume(dmc)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        MIThreadRunState threadState = this.fThreadRunStates.get(dmc);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + " can't be found.", null));
            rm.done();
            return;
        }
        IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)context, IBreakpoints.IBreakpointsTargetDMContext.class);
        this.fConnection.queueCommand(this.fCommandFactory.createMIBreakInsert(bpDmc, true, false, null, 0, location, dmc.getThreadId()), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), rm){

            public void handleSuccess() {
                int bpId = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getNumber();
                String addr = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getAddress();
                GDBRunControl_7_0_NS.this.fRunToLineActiveOperation = new RunToLineActiveOperation(dmc, bpId, location, addr, skipBreakpoints);
                GDBRunControl_7_0_NS.this.resume(dmc, new RequestMonitor((Executor)GDBRunControl_7_0_NS.this.getExecutor(), rm){

                    public void handleFailure() {
                        IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)GDBRunControl_7_0_NS.this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                        int bpId = GDBRunControl_7_0_NS.this.fRunToLineActiveOperation.getBreakointId();
                        GDBRunControl_7_0_NS.this.fConnection.queueCommand(GDBRunControl_7_0_NS.this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{bpId}), new DataRequestMonitor((Executor)GDBRunControl_7_0_NS.this.getExecutor(), null));
                        GDBRunControl_7_0_NS.this.fRunToLineActiveOperation = null;
                        super.handleFailure();
                    }
                });
            }
        });
    }

    private void resumeAtLocation(IRunControl.IExecutionDMContext context, String location, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        if (!this.doCanResume(dmc)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        final MIThreadRunState threadState = this.fThreadRunStates.get(dmc);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + " can't be found.", null));
            rm.done();
            return;
        }
        threadState.fResumePending = true;
        this.fConnection.queueCommand(this.fCommandFactory.createMIExecJump(dmc, location), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleFailure() {
                threadState.fResumePending = false;
                super.handleFailure();
            }
        });
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        IMIProcesses procService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        procService.getProcessesBeingDebugged((IDMContext)containerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (this.getData() instanceof IRunControl.IExecutionDMContext[]) {
                    rm.setData((Object)((IRunControl.IExecutionDMContext[])this.getData()));
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid contexts", null));
                }
                rm.done();
            }
        });
    }

    public void getExecutionData(IRunControl.IExecutionDMContext dmc, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        MIThreadRunState threadState = this.fThreadRunStates.get(dmc);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Given context: " + dmc + " is not a recognized execution context.", null));
            rm.done();
            return;
        }
        if (dmc instanceof IMIExecutionDMContext) {
            rm.setData((Object)new ExecutionData(threadState.fSuspended ? threadState.fStateChangeReason : null, threadState.fStateChangeDetails));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Given context: " + dmc + " is not a recognized execution context.", null));
        }
        rm.done();
    }

    private IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, String threadId) {
        IMIProcesses procService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)container, IProcesses.IProcessDMContext.class);
        IProcesses.IThreadDMContext threadDmc = null;
        if (procDmc != null) {
            threadDmc = procService.createThreadContext(procDmc, threadId);
        }
        return procService.createExecutionContext(container, threadDmc, threadId);
    }

    private void updateThreadState(IMIExecutionDMContext context, ResumedEvent event) {
        IRunControl.StateChangeReason reason = event.getReason();
        boolean isStepping = reason.equals((Object)IRunControl.StateChangeReason.STEP);
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            threadState = new MIThreadRunState();
            this.fThreadRunStates.put(context, threadState);
        }
        threadState.fSuspended = false;
        threadState.fResumePending = false;
        threadState.fStateChangeReason = reason;
        threadState.fStateChangeDetails = null;
        threadState.fStepping = isStepping;
    }

    private void updateThreadState(IMIExecutionDMContext context, SuspendedEvent event) {
        IRunControl.StateChangeReason reason = event.getReason();
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            threadState = new MIThreadRunState();
            this.fThreadRunStates.put(context, threadState);
        }
        threadState.fSuspended = true;
        threadState.fResumePending = false;
        threadState.fStepping = false;
        threadState.fStateChangeReason = reason;
        threadState.fStateChangeDetails = event.getDetails();
    }

    protected boolean isTargetAvailableOperationOngoing() {
        return this.fOngoingOperation;
    }

    protected void setTargetAvailableOperationOngoing(boolean ongoing) {
        this.fOngoingOperation = ongoing;
    }

    protected boolean isCurrentlyExecutingSteps() {
        return this.fCurrentlyExecutingSteps;
    }

    protected void setCurrentlyExecutingSteps(boolean executing) {
        this.fCurrentlyExecutingSteps = executing;
    }

    protected MultiRequestMonitor<RequestMonitor> getExecuteQueuedStepsRM() {
        return this.fExecuteQueuedOpsStepMonitor;
    }

    protected void setExecuteQueuedStepsRM(MultiRequestMonitor<RequestMonitor> rm) {
        this.fExecuteQueuedOpsStepMonitor = rm;
    }

    protected int getNumStepsStillExecuting() {
        return this.fNumStepsStillExecuting;
    }

    protected void setNumStepsStillExecuting(int num) {
        this.fNumStepsStillExecuting = num;
    }

    protected LinkedList<TargetAvailableOperationInfo> getOperationsPending() {
        return this.fOperationsPending;
    }

    protected void executeSteps(final TargetAvailableOperationInfo info) {
        ++this.fNumStepsStillExecuting;
        RequestMonitor stepsRm = new RequestMonitor(ImmediateExecutor.getInstance(), null){

            protected void handleCompleted() {
                info.rm.setStatus(this.getStatus());
                info.rm.done();
                GDBRunControl_7_0_NS.this.fExecuteQueuedOpsStepMonitor.requestMonitorDone((RequestMonitor)this);
                GDBRunControl_7_0_NS gDBRunControl_7_0_NS = GDBRunControl_7_0_NS.this;
                gDBRunControl_7_0_NS.fNumStepsStillExecuting = gDBRunControl_7_0_NS.fNumStepsStillExecuting - 1;
                if (GDBRunControl_7_0_NS.this.fNumStepsStillExecuting == 0) {
                    GDBRunControl_7_0_NS.this.fExecuteQueuedOpsStepMonitor.doneAdding();
                }
            }
        };
        this.fExecuteQueuedOpsStepMonitor.add(stepsRm);
        this.getExecutor().execute((Runnable)new Sequence(this.getExecutor(), stepsRm){

            public Sequence.Step[] getSteps() {
                return info.steps;
            }
        });
    }

    @Override
    public void executeWithTargetAvailable(IDMContext ctx, Sequence.Step[] steps, RequestMonitor rm) {
        if (!this.fOngoingOperation) {
            this.fOngoingOperation = true;
            this.fOperationsPending.add(new TargetAvailableOperationInfo(ctx, steps, rm));
            final Sequence.Step[] sequenceSteps = new Sequence.Step[]{new IsTargetAvailableStep(ctx), new MakeTargetAvailableStep(), new ExecuteQueuedOperationsStep(), new RestoreTargetStateStep()};
            RequestMonitor sequenceCompletedRm = new RequestMonitor((Executor)this.getExecutor(), null){

                protected void handleSuccess() {
                    GDBRunControl_7_0_NS.this.fOngoingOperation = false;
                    if (GDBRunControl_7_0_NS.this.fOperationsPending.size() > 0) {
                        TargetAvailableOperationInfo info = (TargetAvailableOperationInfo)GDBRunControl_7_0_NS.this.fOperationsPending.removeLast();
                        GDBRunControl_7_0_NS.this.executeWithTargetAvailable(info.ctx, info.steps, info.rm);
                    }
                }

                protected void handleFailure() {
                    GDBRunControl_7_0_NS.this.fOngoingOperation = false;
                    while (GDBRunControl_7_0_NS.this.fOperationsPending.size() > 0) {
                        RequestMonitor rm = ((TargetAvailableOperationInfo)((GDBRunControl_7_0_NS)GDBRunControl_7_0_NS.this).fOperationsPending.poll()).rm;
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                    super.handleFailure();
                }
            };
            this.getExecutor().execute((Runnable)new Sequence(this.getExecutor(), sequenceCompletedRm){

                public Sequence.Step[] getSteps() {
                    return sequenceSteps;
                }
            });
        } else if (this.fCurrentlyExecutingSteps) {
            this.executeSteps(new TargetAvailableOperationInfo(ctx, steps, rm));
        } else {
            this.fOperationsPending.add(new TargetAvailableOperationInfo(ctx, steps, rm));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIRunningEvent e) {
        if (this.fDisableNextRunningEventDmcSet.remove(e.getDMContext())) {
            return;
        }
        this.getSession().dispatchEvent((Object)new ResumedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        IMIExecutionDMContext threadDmc;
        if (this.fRunToLineActiveOperation != null) {
            threadDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IMIExecutionDMContext.class);
            if (this.fRunToLineActiveOperation.getThreadContext().equals(threadDmc)) {
                int bpId = 0;
                if (e instanceof MIBreakpointHitEvent) {
                    bpId = ((MIBreakpointHitEvent)e).getNumber();
                }
                String fileLocation = String.valueOf(e.getFrame().getFile()) + ":" + e.getFrame().getLine();
                String addrLocation = e.getFrame().getAddress();
                if (fileLocation.equals(this.fRunToLineActiveOperation.getFileLocation()) || addrLocation.equals(this.fRunToLineActiveOperation.getAddrLocation()) || bpId == this.fRunToLineActiveOperation.getBreakointId()) {
                    this.fRunToLineActiveOperation = null;
                } else {
                    if (this.fRunToLineActiveOperation.shouldSkipBreakpoints() && e instanceof MIBreakpointHitEvent) {
                        this.fConnection.queueCommand(this.fCommandFactory.createMIExecContinue(this.fRunToLineActiveOperation.getThreadContext()), new DataRequestMonitor((Executor)this.getExecutor(), null));
                        return;
                    }
                    IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                    this.fConnection.queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{this.fRunToLineActiveOperation.getBreakointId()}), new DataRequestMonitor((Executor)this.getExecutor(), null));
                    this.fRunToLineActiveOperation = null;
                }
            }
        }
        threadDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IMIExecutionDMContext.class);
        if (e instanceof MISignalEvent && this.fDisableNextSignalEventDmcSet.remove(threadDmc)) {
            this.fSilencedSignalEventMap.put(threadDmc, e);
            return;
        }
        SuspendedEvent event = null;
        MIBreakpoints.MIBreakpointDMContext bp = null;
        if (e instanceof MIBreakpointHitEvent) {
            int bpId = ((MIBreakpointHitEvent)e).getNumber();
            IBreakpoints.IBreakpointsTargetDMContext bpsTarget = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            if (bpsTarget != null && bpId >= 0) {
                bp = new MIBreakpoints.MIBreakpointDMContext(this.getSession().getId(), new IDMContext[]{bpsTarget}, bpId);
                event = new BreakpointHitEvent((IRunControl.IExecutionDMContext)e.getDMContext(), (MIBreakpointHitEvent)e, bp);
            }
        }
        if (event == null) {
            event = new SuspendedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e);
        }
        this.getSession().dispatchEvent(event, this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadCreatedEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        IMIExecutionDMContext executionCtx = null;
        if (e.getStrId() != null) {
            executionCtx = this.createMIExecutionContext(containerDmc, e.getStrId());
        }
        this.getSession().dispatchEvent((Object)new StartedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadExitEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        IMIExecutionDMContext executionCtx = null;
        if (e.getStrId() != null) {
            executionCtx = this.createMIExecutionContext(containerDmc, e.getStrId());
        }
        this.getSession().dispatchEvent((Object)new ExitedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ResumedEvent e) {
        IRunControl.IExecutionDMContext ctx = (IRunControl.IExecutionDMContext)e.getDMContext();
        if (ctx instanceof IMIExecutionDMContext) {
            this.updateThreadState((IMIExecutionDMContext)ctx, e);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(SuspendedEvent e) {
        IRunControl.IExecutionDMContext ctx = (IRunControl.IExecutionDMContext)e.getDMContext();
        if (ctx instanceof IMIExecutionDMContext) {
            this.updateThreadState((IMIExecutionDMContext)ctx, e);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(StartedDMEvent e) {
        IRunControl.IExecutionDMContext executionCtx = (IRunControl.IExecutionDMContext)e.getDMContext();
        if (executionCtx instanceof IMIExecutionDMContext && this.fThreadRunStates.get(executionCtx) == null) {
            this.fThreadRunStates.put((IMIExecutionDMContext)executionCtx, new MIThreadRunState());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ExitedDMEvent e) {
        this.fThreadRunStates.remove(e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.fTerminated = true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIInferiorExitEvent e) {
        if (this.fRunToLineActiveOperation != null) {
            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            int bpId = this.fRunToLineActiveOperation.getBreakointId();
            this.fConnection.queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new int[]{bpId}), new DataRequestMonitor((Executor)this.getExecutor(), null));
            this.fRunToLineActiveOperation = null;
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        this.fRunControlOperationsEnabled = !e.isVisualizationModeEnabled();
    }

    public void flushCache(IDMContext context) {
    }

    private void moveToLocation(final IRunControl.IExecutionDMContext context, final String location, Map<String, Object> bpAttributes, final RequestMonitor rm) {
        IBreakpoints bpService = (IBreakpoints)this.getServicesTracker().getService(IBreakpoints.class);
        IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)context, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (bpService != null && bpDmc != null) {
            bpService.insertBreakpoint(bpDmc, bpAttributes, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    GDBRunControl_7_0_NS.this.resumeAtLocation(context, location, rm);
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Unable to set breakpoint", null));
            rm.done();
        }
    }

    public void canRunToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void runToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean skipBreakpoints, RequestMonitor rm) {
        sourceFile = GDBRunControl_7_0_NS.adjustDebuggerPath(sourceFile);
        this.runToLocation(context, String.valueOf(sourceFile) + ":" + Integer.toString(lineNumber), skipBreakpoints, rm);
    }

    public void canRunToAddress(IRunControl.IExecutionDMContext context, IAddress address, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void runToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean skipBreakpoints, RequestMonitor rm) {
        this.runToLocation(context, "*0x" + address.toString(16), skipBreakpoints, rm);
    }

    public void canMoveToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean resume, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void moveToLine(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, boolean resume, RequestMonitor rm) {
        IMIExecutionDMContext threadExecDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (threadExecDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Invalid thread context", null));
            rm.done();
        } else {
            String location = String.valueOf(sourceFile) + ":" + lineNumber;
            if (resume) {
                this.resumeAtLocation(context, location, rm);
            } else {
                HashMap<String, Object> attr = new HashMap<String, Object>();
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "breakpoint");
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.fileName", sourceFile);
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber", lineNumber);
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", true);
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", Integer.toString(threadExecDmc.getThreadId()));
                this.moveToLocation(context, location, attr, rm);
            }
        }
    }

    public void canMoveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void moveToAddress(IRunControl.IExecutionDMContext context, IAddress address, boolean resume, RequestMonitor rm) {
        IMIExecutionDMContext threadExecDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (threadExecDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Invalid thread context", null));
            rm.done();
        } else {
            String location = "*0x" + address.toString(16);
            if (resume) {
                this.resumeAtLocation(context, location, rm);
            } else {
                HashMap<String, Object> attr = new HashMap<String, Object>();
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "breakpoint");
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.address", "0x" + address.toString(16));
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", true);
                attr.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", Integer.toString(threadExecDmc.getThreadId()));
                this.moveToLocation(context, location, attr, rm);
            }
        }
    }

    @Override
    public IMIRunControl.IRunMode getRunMode() {
        return IMIRunControl.MIRunMode.NON_STOP;
    }

    @Override
    public boolean isTargetAcceptingCommands() {
        return true;
    }

    private static String adjustDebuggerPath(String path) {
        String result = path;
        if (Platform.getOS().startsWith("win") && !path.startsWith("/")) {
            path = path.replace('\\', '/');
            result = path.substring(path.lastIndexOf(47) + 1);
        }
        return result;
    }

    @Immutable
    protected static class BreakpointHitEvent
    extends SuspendedEvent
    implements IBreakpointsExtension.IBreakpointHitDMEvent {
        private final IBreakpoints.IBreakpointDMContext[] fBreakpoints;

        BreakpointHitEvent(IRunControl.IExecutionDMContext ctx, MIBreakpointHitEvent miInfo, IBreakpoints.IBreakpointDMContext bpCtx) {
            super(ctx, miInfo);
            this.fBreakpoints = new IBreakpoints.IBreakpointDMContext[]{bpCtx};
        }

        public IBreakpoints.IBreakpointDMContext[] getBreakpoints() {
            return this.fBreakpoints;
        }
    }

    protected class ExecuteQueuedOperationsStep
    extends Sequence.Step {
        protected ExecuteQueuedOperationsStep() {
        }

        public void execute(final RequestMonitor rm) {
            GDBRunControl_7_0_NS.this.fCurrentlyExecutingSteps = true;
            GDBRunControl_7_0_NS.this.fExecuteQueuedOpsStepMonitor = (MultiRequestMonitor)new MultiRequestMonitor<RequestMonitor>(ImmediateExecutor.getInstance(), rm){

                protected void handleCompleted() {
                    if (!$assertionsDisabled && GDBRunControl_7_0_NS.this.fOperationsPending.size() != 0) {
                        throw new AssertionError();
                    }
                    GDBRunControl_7_0_NS.this.fCurrentlyExecutingSteps = false;
                    rm.done();
                }
            };
            GDBRunControl_7_0_NS.this.fExecuteQueuedOpsStepMonitor.requireDoneAdding();
            while (GDBRunControl_7_0_NS.this.fOperationsPending.size() > 0) {
                GDBRunControl_7_0_NS.this.executeSteps((TargetAvailableOperationInfo)GDBRunControl_7_0_NS.this.fOperationsPending.poll());
            }
        }
    }

    @Immutable
    private static class ExecutionData
    implements IRunControl.IExecutionDMData2 {
        private final IRunControl.StateChangeReason fReason;
        private final String fDetails;

        ExecutionData(IRunControl.StateChangeReason reason, String details) {
            this.fReason = reason;
            this.fDetails = details;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.fReason;
        }

        public String getDetails() {
            return this.fDetails;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class ExitedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadExitEvent>
    implements IRunControl.IExitedDMEvent {
        ExitedDMEvent(IMIExecutionDMContext executionDmc, MIThreadExitEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    protected class IsTargetAvailableStep
    extends Sequence.Step {
        final IDMContext fCtx;

        public IsTargetAvailableStep(IDMContext ctx) {
            this.fCtx = ctx;
        }

        private void getThreadToSuspend(IRunControl.IContainerDMContext containerDmc, final RequestMonitor rm) {
            GDBRunControl_7_0_NS.this.fProcessService.getProcessesBeingDebugged((IDMContext)containerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    IDMContext[] threads = (IDMContext[])this.getData();
                    if (threads != null && threads.length > 0) {
                        GDBRunControl_7_0_NS.this.fExecutionDmcToSuspendSet.add((IMIExecutionDMContext)threads[0]);
                    }
                    rm.done();
                }
            });
        }

        public void execute(final RequestMonitor rm) {
            GDBRunControl_7_0_NS.this.fExecutionDmcToSuspendSet.clear();
            GDBRunControl_7_0_NS.this.fProcessService.getProcessesBeingDebugged((IDMContext)GDBRunControl_7_0_NS.this.fConnection.getContext(), (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    if (!$assertionsDisabled && this.getData() == null) {
                        throw new AssertionError();
                    }
                    if (((IDMContext[])this.getData()).length == 0) {
                        rm.done();
                    } else {
                        CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
                        int numThreadsToSuspend = 0;
                        IDMContext[] iDMContextArray = (IDMContext[])this.getData();
                        int n = iDMContextArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDMContext dmc = iDMContextArray[n2];
                            IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)dmc;
                            if (!GDBRunControl_7_0_NS.this.isSuspended((IRunControl.IExecutionDMContext)containerDmc)) {
                                ++numThreadsToSuspend;
                                IsTargetAvailableStep.this.getThreadToSuspend(containerDmc, (RequestMonitor)crm);
                            }
                            ++n2;
                        }
                        crm.setDoneCount(numThreadsToSuspend);
                    }
                }
            });
        }
    }

    protected class MIThreadRunState {
        boolean fSuspended = false;
        boolean fResumePending = false;
        boolean fStepping = false;
        IRunControl.StateChangeReason fStateChangeReason;
        String fStateChangeDetails;

        protected MIThreadRunState() {
        }
    }

    protected class MakeTargetAvailableStep
    extends Sequence.Step {
        protected MakeTargetAvailableStep() {
        }

        public void execute(RequestMonitor rm) {
            CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
            crm.setDoneCount(GDBRunControl_7_0_NS.this.fExecutionDmcToSuspendSet.size());
            for (final IMIExecutionDMContext thread : GDBRunControl_7_0_NS.this.fExecutionDmcToSuspendSet) {
                assert (!GDBRunControl_7_0_NS.this.fDisableNextRunningEventDmcSet.contains(thread));
                assert (!GDBRunControl_7_0_NS.this.fDisableNextSignalEventDmcSet.contains(thread));
                GDBRunControl_7_0_NS.this.fDisableNextSignalEventDmcSet.add(thread);
                GDBRunControl_7_0_NS.this.suspend(thread, new RequestMonitor(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                    protected void handleFailure() {
                        GDBRunControl_7_0_NS.this.fDisableNextSignalEventDmcSet.remove(thread);
                        super.handleFailure();
                    }
                });
            }
        }

        public void rollBack(RequestMonitor rm) {
            RestoreTargetStateStep restoreStep = new RestoreTargetStateStep();
            restoreStep.execute(rm);
        }
    }

    protected class RestoreTargetStateStep
    extends Sequence.Step {
        protected RestoreTargetStateStep() {
        }

        public void execute(RequestMonitor rm) {
            CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
            crm.setDoneCount(GDBRunControl_7_0_NS.this.fExecutionDmcToSuspendSet.size());
            for (final IMIExecutionDMContext thread : GDBRunControl_7_0_NS.this.fExecutionDmcToSuspendSet) {
                assert (!GDBRunControl_7_0_NS.this.fDisableNextRunningEventDmcSet.contains(thread));
                GDBRunControl_7_0_NS.this.fDisableNextRunningEventDmcSet.add(thread);
                GDBRunControl_7_0_NS.this.fConnection.queueCommand(GDBRunControl_7_0_NS.this.fCommandFactory.createMIExecContinue(thread), (DataRequestMonitor)new DataRequestMonitor<MIInfo>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                    protected void handleSuccess() {
                        GDBRunControl_7_0_NS.this.fSilencedSignalEventMap.remove(thread);
                        super.handleSuccess();
                    }

                    protected void handleFailure() {
                        GDBRunControl_7_0_NS.this.fDisableNextRunningEventDmcSet.remove(thread);
                        MIStoppedEvent event = (MIStoppedEvent)((Object)GDBRunControl_7_0_NS.this.fSilencedSignalEventMap.remove(thread));
                        if (event != null) {
                            GDBRunControl_7_0_NS.this.eventDispatched(event);
                        } else {
                            GDBRunControl_7_0_NS.this.fDisableNextSignalEventDmcSet.remove(thread);
                        }
                        super.handleFailure();
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class ResumedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIRunningEvent>
    implements IRunControl.IResumedDMEvent {
        ResumedEvent(IRunControl.IExecutionDMContext ctx, MIRunningEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            switch (((MIRunningEvent)((Object)this.getMIEvent())).getType()) {
                case 0: {
                    return IRunControl.StateChangeReason.USER_REQUEST;
                }
                case 1: 
                case 2: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 3: 
                case 4: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 5: {
                    return IRunControl.StateChangeReason.STEP;
                }
            }
            return IRunControl.StateChangeReason.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static class RunControlEvent<V extends IDMContext, T extends MIEvent<? extends IDMContext>>
    extends AbstractDMEvent<V>
    implements IDMEvent<V>,
    IMIDMEvent {
        private final T fMIInfo;

        public RunControlEvent(V dmc, T miInfo) {
            super(dmc);
            this.fMIInfo = miInfo;
        }

        public T getMIEvent() {
            return this.fMIInfo;
        }
    }

    protected static class RunToLineActiveOperation {
        private IMIExecutionDMContext fThreadContext;
        private int fBpId;
        private String fFileLocation;
        private String fAddrLocation;
        private boolean fSkipBreakpoints;

        public RunToLineActiveOperation(IMIExecutionDMContext threadContext, int bpId, String fileLoc, String addr, boolean skipBreakpoints) {
            this.fThreadContext = threadContext;
            this.fBpId = bpId;
            this.fFileLocation = fileLoc;
            this.fAddrLocation = addr;
            this.fSkipBreakpoints = skipBreakpoints;
        }

        public IMIExecutionDMContext getThreadContext() {
            return this.fThreadContext;
        }

        public int getBreakointId() {
            return this.fBpId;
        }

        public String getFileLocation() {
            return this.fFileLocation;
        }

        public String getAddrLocation() {
            return this.fAddrLocation;
        }

        public boolean shouldSkipBreakpoints() {
            return this.fSkipBreakpoints;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class StartedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadCreatedEvent>
    implements IRunControl.IStartedDMEvent {
        StartedDMEvent(IMIExecutionDMContext executionDmc, MIThreadCreatedEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class SuspendedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIStoppedEvent>
    implements IRunControl.ISuspendedDMEvent {
        SuspendedEvent(IRunControl.IExecutionDMContext ctx, MIStoppedEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            if (this.getMIEvent() instanceof MICatchpointHitEvent) {
                return IRunControl.StateChangeReason.EVENT_BREAKPOINT;
            }
            if (this.getMIEvent() instanceof MITracepointSelectedEvent) {
                return IRunControl.StateChangeReason.UNKNOWN;
            }
            if (this.getMIEvent() instanceof MIBreakpointHitEvent) {
                return IRunControl.StateChangeReason.BREAKPOINT;
            }
            if (this.getMIEvent() instanceof MISteppingRangeEvent) {
                return IRunControl.StateChangeReason.STEP;
            }
            if (this.getMIEvent() instanceof MISharedLibEvent) {
                return IRunControl.StateChangeReason.SHAREDLIB;
            }
            if (this.getMIEvent() instanceof MISignalEvent) {
                return IRunControl.StateChangeReason.SIGNAL;
            }
            if (this.getMIEvent() instanceof MIWatchpointTriggerEvent) {
                return IRunControl.StateChangeReason.WATCHPOINT;
            }
            if (this.getMIEvent() instanceof MIErrorEvent) {
                return IRunControl.StateChangeReason.ERROR;
            }
            return IRunControl.StateChangeReason.USER_REQUEST;
        }

        public String getDetails() {
            MIStoppedEvent event = (MIStoppedEvent)((Object)this.getMIEvent());
            if (event instanceof MICatchpointHitEvent) {
                return ((MICatchpointHitEvent)event).getReason();
            }
            if (event instanceof MITracepointSelectedEvent) {
                return ((MITracepointSelectedEvent)event).getReason();
            }
            if (event instanceof MISharedLibEvent) {
                return ((MISharedLibEvent)event).getLibrary();
            }
            if (event instanceof MISignalEvent) {
                return String.valueOf(((MISignalEvent)event).getName()) + ':' + ((MISignalEvent)event).getMeaning();
            }
            if (event instanceof MIWatchpointTriggerEvent) {
                return ((MIWatchpointTriggerEvent)event).getExpression();
            }
            if (event instanceof MIErrorEvent) {
                return ((MIErrorEvent)event).getMessage();
            }
            return null;
        }
    }

    protected static class TargetAvailableOperationInfo {
        public IDMContext ctx;
        public Sequence.Step[] steps;
        public RequestMonitor rm;

        public TargetAvailableOperationInfo(IDMContext ctx, Sequence.Step[] steps, RequestMonitor rm) {
            this.ctx = ctx;
            this.steps = steps;
            this.rm = rm;
        }
    }
}

