/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.DsfMultiStatus;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.MessagesForProperties;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUpdateStatus
extends DsfMultiStatus {
    private final Map<String, IStatus> fPropertiesStatus = new HashMap<String, IStatus>(1);
    private boolean fFirstStatusSet;

    public PropertiesUpdateStatus() {
        super("org.eclipse.cdt.dsf.ui", 0, "", null);
    }

    public Set<String> getProperties() {
        return this.fPropertiesStatus.keySet();
    }

    public IStatus getStatus(String property) {
        return this.fPropertiesStatus.get(property);
    }

    public void setStatus(String property, IStatus status) {
        IStatus child = this.findEquivalentChild(status);
        if (child != null) {
            status = child;
        } else {
            this.add(status);
        }
        this.fPropertiesStatus.put(property, status);
    }

    public void setStatus(String[] properties, IStatus status) {
        IStatus child = this.findEquivalentChild(status);
        if (child != null) {
            status = child;
        } else {
            this.add(status);
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            this.fPropertiesStatus.put(property, status);
            ++n2;
        }
    }

    public static PropertiesUpdateStatus mergePropertiesStatus(PropertiesUpdateStatus baseStatus, PropertiesUpdateStatus newStatus, Set<String> properties) {
        PropertiesUpdateStatus mergedStatus = new PropertiesUpdateStatus();
        mergedStatus.fPropertiesStatus.putAll(baseStatus.fPropertiesStatus);
        for (String property : properties) {
            IStatus propertyStatus = newStatus.getStatus(property);
            if (propertyStatus != null) {
                mergedStatus.fPropertiesStatus.put(property, propertyStatus);
                continue;
            }
            mergedStatus.fPropertiesStatus.remove(property);
        }
        HashSet<IStatus> children = new HashSet<IStatus>((baseStatus.getChildren().length + newStatus.getChildren().length) * 4 / 3);
        children.addAll(mergedStatus.fPropertiesStatus.values());
        for (IStatus child : children) {
            mergedStatus.add(child);
        }
        return mergedStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IStatus status) {
        boolean firstSet;
        if (this.findEquivalentChild(status) != null) {
            return;
        }
        super.add(status);
        PropertiesUpdateStatus propertiesUpdateStatus = this;
        synchronized (propertiesUpdateStatus) {
            firstSet = this.fFirstStatusSet;
            this.fFirstStatusSet = true;
        }
        if (!firstSet) {
            this.setMessage(status.getMessage());
        } else {
            this.setMessage(MessagesForProperties.PropertiesUpdateStatus_message);
        }
    }

    private IStatus findEquivalentChild(IStatus status) {
        if (this.getChildren().length != 0) {
            IStatus[] iStatusArray = this.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                if (this.areEquivalent(child, status)) {
                    return child;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean areEquivalent(IStatus s1, IStatus s2) {
        if (s1 == null && s2 != null || s1 != null && s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.getSeverity() != s2.getSeverity() || !s1.getPlugin().equals(s2.getPlugin()) || s1.getCode() != s2.getCode()) {
            return false;
        }
        if (s1.getException() == null && s1.getException() != null || s1.getException() != null && s1.getException() == null || s1.getException() != null && !s1.getException().equals(s2.getException())) {
            return false;
        }
        return s1.getMessage().equals(s2.getMessage());
    }

    public static PropertiesUpdateStatus getPropertiesStatus(IPropertiesUpdate update) {
        IStatus updateStatus = update.getStatus();
        if (updateStatus instanceof PropertiesUpdateStatus) {
            return (PropertiesUpdateStatus)updateStatus;
        }
        PropertiesUpdateStatus propertiesStatus = new PropertiesUpdateStatus();
        update.setStatus((IStatus)propertiesStatus);
        if (!updateStatus.isOK()) {
            propertiesStatus.add(updateStatus);
        }
        return propertiesStatus;
    }

    public static PropertiesUpdateStatus makePropertiesStatus(IStatus updateStatus) {
        if (updateStatus instanceof PropertiesUpdateStatus) {
            return (PropertiesUpdateStatus)updateStatus;
        }
        PropertiesUpdateStatus propertiesStatus = new PropertiesUpdateStatus();
        if (!updateStatus.isOK()) {
            propertiesStatus.add(updateStatus);
        }
        return propertiesStatus;
    }
}

