/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetListener;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeTargetEvent;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class MakeContentProvider
implements ITreeContentProvider,
IMakeTargetListener,
IResourceChangeListener,
ICProjectDescriptionListener,
IEclipsePreferences.IPreferenceChangeListener {
    protected boolean bFlatten;
    protected StructuredViewer viewer;

    public MakeContentProvider() {
        this(false);
    }

    public MakeContentProvider(boolean flat) {
        this.bFlatten = flat;
    }

    public Object[] getChildren(Object obj) {
        block18: {
            if (obj instanceof IWorkspaceRoot) {
                try {
                    return MakeCorePlugin.getDefault().getTargetManager().getTargetBuilderProjects();
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((Throwable)e);
                    break block18;
                }
            }
            if (obj instanceof IContainer) {
                int n;
                boolean isAddingSourceRoots;
                IContainer container = (IContainer)obj;
                ArrayList<TargetSourceContainer> children = new ArrayList<TargetSourceContainer>();
                boolean bl = isAddingSourceRoots = !this.bFlatten && container instanceof IProject && CCorePlugin.showSourceRootsAtTopOfProject();
                if (isAddingSourceRoots) {
                    ICSourceEntry[] srcEntries;
                    IProject project = (IProject)container;
                    ICSourceEntry[] iCSourceEntryArray = srcEntries = MakeContentProvider.getSourceEntries(project);
                    int n2 = srcEntries.length;
                    n = 0;
                    while (n < n2) {
                        ICSourceEntry srcEntry = iCSourceEntryArray[n];
                        if (!srcEntry.getFullPath().equals((Object)project.getFullPath())) {
                            children.add(new TargetSourceContainer(srcEntry));
                        }
                        ++n;
                    }
                }
                try {
                    IResource[] resources;
                    IResource[] iResourceArray = resources = container.members();
                    n = resources.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IResource rc = iResourceArray[n3];
                        if (!(!(rc instanceof IContainer) || isAddingSourceRoots && MakeContentProvider.isSourceEntry(rc))) {
                            children.add((TargetSourceContainer)rc);
                        }
                        ++n3;
                    }
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((Throwable)e);
                }
                try {
                    IMakeTarget[] targets = MakeCorePlugin.getDefault().getTargetManager().getTargets(container);
                    children.addAll(Arrays.asList(targets));
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((Throwable)e);
                }
                return children.toArray();
            }
            if (obj instanceof TargetSourceContainer) {
                ArrayList<Object> children = new ArrayList<Object>();
                try {
                    IResource[] resources;
                    IContainer container = ((TargetSourceContainer)obj).getContainer();
                    IResource[] iResourceArray = resources = container.members();
                    int n = resources.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IResource rc = iResourceArray[n4];
                        if (rc instanceof IContainer) {
                            children.add(rc);
                        }
                        ++n4;
                    }
                    children.addAll(Arrays.asList(MakeCorePlugin.getDefault().getTargetManager().getTargets(container)));
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((Throwable)e);
                }
                return children.toArray();
            }
        }
        return new Object[0];
    }

    public Object getParent(Object obj) {
        if (obj instanceof IMakeTarget) {
            return ((IMakeTarget)obj).getContainer();
        }
        if (obj instanceof IContainer) {
            return ((IContainer)obj).getParent();
        }
        if (obj instanceof TargetSourceContainer) {
            IContainer container = ((TargetSourceContainer)obj).getContainer();
            return container.getProject();
        }
        return null;
    }

    public boolean hasChildren(Object obj) {
        return this.getChildren(obj).length > 0;
    }

    public Object[] getElements(Object obj) {
        if (this.bFlatten) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] children = this.getChildren(obj);
            int i = 0;
            while (i < children.length) {
                list.add(children[i]);
                list.addAll(Arrays.asList(this.getElements(children[i])));
                ++i;
            }
            return list.toArray();
        }
        return this.getChildren(obj);
    }

    public void dispose() {
        if (this.viewer != null) {
            MakeCorePlugin.getDefault().getTargetManager().removeListener((IMakeTargetListener)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer == null) {
            MakeCorePlugin.getDefault().getTargetManager().addListener((IMakeTargetListener)this);
        }
        this.viewer = (StructuredViewer)viewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        } else if (oldInput instanceof TargetSourceContainer) {
            oldWorkspace = ((TargetSourceContainer)oldInput).getContainer().getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        } else if (newInput instanceof TargetSourceContainer) {
            newWorkspace = ((TargetSourceContainer)newInput).getContainer().getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            if (oldWorkspace != null) {
                InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                mngr.removeCProjectDescriptionListener((ICProjectDescriptionListener)this);
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
                mngr.addCProjectDescriptionListener((ICProjectDescriptionListener)this, 4);
                InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
        }
    }

    public void targetChanged(final MakeTargetEvent event) {
        final Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            switch (event.getType()) {
                case 4: 
                case 5: {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!ctrl.isDisposed()) {
                                MakeContentProvider.this.viewer.refresh();
                            }
                        }
                    });
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!ctrl.isDisposed()) {
                                if (MakeContentProvider.this.bFlatten) {
                                    MakeContentProvider.this.viewer.refresh();
                                } else {
                                    IMakeTarget[] targets;
                                    HashSet<IContainer> containers = new HashSet<IContainer>();
                                    IMakeTarget[] iMakeTargetArray = targets = event.getTargets();
                                    int n = targets.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IMakeTarget target = iMakeTargetArray[n2];
                                        IContainer container = target.getContainer();
                                        while (!(container instanceof IProject) && container.getParent() != null) {
                                            container = container.getParent();
                                        }
                                        containers.add(container);
                                        ++n2;
                                    }
                                    for (IContainer container : containers) {
                                        MakeContentProvider.this.viewer.refresh((Object)container);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private void processDelta(IResourceDelta delta) {
        int i;
        ArrayList<IResource> affected;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed() || delta == null) {
            return;
        }
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                return;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < affectedChildren.length) {
            this.processDelta(affectedChildren[i2]);
            ++i2;
        }
        final IResource resource = delta.getResource();
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            affected = new ArrayList<IResource>(affectedChildren.length);
            i = 0;
            while (i < affectedChildren.length) {
                if (affectedChildren[i].getResource().getType() == 2) {
                    affected.add(affectedChildren[i].getResource());
                }
                ++i;
            }
            if (!affected.isEmpty()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (MakeContentProvider.this.viewer == null || MakeContentProvider.this.viewer.getControl() == null || MakeContentProvider.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if (MakeContentProvider.this.viewer instanceof AbstractTreeViewer) {
                            ((AbstractTreeViewer)MakeContentProvider.this.viewer).remove(affected.toArray());
                        } else {
                            MakeContentProvider.this.viewer.refresh((Object)resource);
                        }
                    }
                });
            }
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            affected = new ArrayList(affectedChildren.length);
            i = 0;
            while (i < affectedChildren.length) {
                if (affectedChildren[i].getResource().getType() == 2) {
                    affected.add(affectedChildren[i].getResource());
                }
                ++i;
            }
            if (!affected.isEmpty()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (MakeContentProvider.this.viewer == null || MakeContentProvider.this.viewer.getControl() == null || MakeContentProvider.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if (MakeContentProvider.this.viewer instanceof AbstractTreeViewer) {
                            ((AbstractTreeViewer)MakeContentProvider.this.viewer).add((Object)resource, affected.toArray());
                        } else {
                            MakeContentProvider.this.viewer.refresh((Object)resource);
                        }
                    }
                });
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.processDelta(delta);
        }
    }

    public void handleEvent(final CProjectDescriptionEvent event) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                ICDescriptionDelta delta = event.getDefaultSettingCfgDelta();
                if (delta == null) {
                    return;
                }
                int flags = delta.getChangeFlags();
                if ((flags & 0x2000) != 0 || (flags & 0x4000) != 0) {
                    IProject project = null;
                    ICSettingObject setting = delta.getOldSetting();
                    if (setting == null) {
                        setting = delta.getNewSetting();
                    }
                    if (setting instanceof ICConfigurationDescription) {
                        project = ((ICConfigurationDescription)setting).getProjectDescription().getProject();
                    }
                    if (project != null) {
                        MakeContentProvider.this.viewer.refresh((Object)project);
                    } else {
                        MakeContentProvider.this.viewer.refresh();
                    }
                }
            }
        });
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.cdt.core.showSourceRootsAtTopLevelOfProject")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MakeContentProvider.this.viewer.refresh();
                }
            });
        }
    }

    private static ICSourceEntry[] getSourceEntries(IProject project) {
        ICConfigurationDescription cfgDescription;
        ICProjectDescriptionManager mgr = CCorePlugin.getDefault().getProjectDescriptionManager();
        ICProjectDescription prjDescription = mgr.getProjectDescription(project, false);
        if (prjDescription != null && (cfgDescription = prjDescription.getDefaultSettingConfiguration()) != null) {
            ICSourceEntry[] srcEntries = cfgDescription.getResolvedSourceEntries();
            return srcEntries;
        }
        return new ICSourceEntry[0];
    }

    public static boolean isSourceEntry(IResource rc) {
        ICSourceEntry[] srcEntries;
        IProject project = rc.getProject();
        ICSourceEntry[] iCSourceEntryArray = srcEntries = MakeContentProvider.getSourceEntries(project);
        int n = srcEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry srcEntry = iCSourceEntryArray[n2];
            if (srcEntry.getFullPath().equals((Object)rc.getFullPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

