/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.tests.CustomOptionCommandGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ManagedCommandLineGeneratorTest
extends TestCase {
    private static String[] testCommandLinePatterns;
    private static String COMMAND_VAL;
    private static String FLAGS_VAL;
    private static String[] FLAGS_ARRAY_VAL;
    private static String OUTPUT_FLAG_VAL;
    private static String OUTPUT_PREFIX_VAL;
    private static String OUTPUT_VAL;
    private static String INPUTS_VAL;
    private static String[] INPUTS_ARRAY_VAL;
    private static String[] commandLineEtalonesForPatterns;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "${COMMAND}";
        stringArray[2] = "${COMMAND} ${FLAGS}";
        stringArray[3] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}";
        stringArray[4] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}";
        stringArray[5] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT}";
        stringArray[6] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG} ${OUTPUT_PREFIX}${OUTPUT}";
        stringArray[7] = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
        stringArray[8] = "${command} ${flags} ${output_flag}${output_prefix}${output} ${WRONG_VAR_NAME}";
        testCommandLinePatterns = stringArray;
        COMMAND_VAL = "[command]";
        FLAGS_VAL = "[flags]";
        FLAGS_ARRAY_VAL = FLAGS_VAL.split("\\s");
        OUTPUT_FLAG_VAL = "[outputFlag]";
        OUTPUT_PREFIX_VAL = "[outputPrefix]";
        OUTPUT_VAL = "[output]";
        INPUTS_VAL = "[inputs]";
        INPUTS_ARRAY_VAL = INPUTS_VAL.split("\\s");
        commandLineEtalonesForPatterns = new String[]{String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + " " + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\"", COMMAND_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL, String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"", String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + " " + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"", String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\"", String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "${WRONG_VAR_NAME}"};
    }

    public ManagedCommandLineGeneratorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ManagedCommandLineGeneratorTest.class);
    }

    public final void testGetCommandLineGenerator() {
        ManagedCommandLineGenerator gen = ManagedCommandLineGenerator.getCommandLineGenerator();
        ManagedCommandLineGeneratorTest.assertNotNull((Object)gen);
    }

    public final void testGenerateCommandLineInfoPatterns() {
        ManagedCommandLineGenerator gen = ManagedCommandLineGenerator.getCommandLineGenerator();
        IManagedCommandLineInfo info = null;
        int i = 0;
        while (i < testCommandLinePatterns.length) {
            info = gen.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, testCommandLinePatterns[i]);
            ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
            if (i < commandLineEtalonesForPatterns.length) {
                ManagedCommandLineGeneratorTest.assertEquals((String)("i=" + i), (String)commandLineEtalonesForPatterns[i], (String)info.getCommandLine());
            }
            ++i;
        }
    }

    public final void testGenerateCommandLineInfoDoublePattern() {
        ManagedCommandLineGenerator gen = ManagedCommandLineGenerator.getCommandLineGenerator();
        IManagedCommandLineInfo info = gen.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, "${OUTPUT_FLAG} ${OUTPUT_FLAG}");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(OUTPUT_FLAG_VAL) + " " + OUTPUT_FLAG_VAL), (String)info.getCommandLine());
    }

    public final void testGenerateCommandLineInfoParameters() {
        ManagedCommandLineGenerator gen = ManagedCommandLineGenerator.getCommandLineGenerator();
        IManagedCommandLineInfo info = gen.generateCommandLineInfo(null, "", FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(FLAGS_VAL) + " " + OUTPUT_FLAG_VAL + " " + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\""), (String)info.getCommandLine());
        info = gen.generateCommandLineInfo(null, COMMAND_VAL, new String[0], OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(COMMAND_VAL) + "  " + OUTPUT_FLAG_VAL + " " + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\""), (String)info.getCommandLine());
        info = gen.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, "", OUTPUT_PREFIX_VAL, OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + "  " + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\""), (String)info.getCommandLine());
        info = gen.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, "", OUTPUT_VAL, INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + " " + "\"" + OUTPUT_VAL + "\"" + " " + "\"" + INPUTS_VAL + "\""), (String)info.getCommandLine());
        info = gen.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, "", INPUTS_ARRAY_VAL, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + " " + OUTPUT_PREFIX_VAL + " " + "\"" + INPUTS_VAL + "\""), (String)info.getCommandLine());
        info = gen.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, new String[0], null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + " " + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\""), (String)info.getCommandLine());
        info = gen.generateCommandLineInfo(null, COMMAND_VAL, FLAGS_ARRAY_VAL, OUTPUT_FLAG_VAL, OUTPUT_PREFIX_VAL, OUTPUT_VAL, null, null);
        ManagedCommandLineGeneratorTest.assertNotNull((Object)info);
        ManagedCommandLineGeneratorTest.assertEquals((String)(String.valueOf(COMMAND_VAL) + " " + FLAGS_VAL + " " + OUTPUT_FLAG_VAL + " " + OUTPUT_PREFIX_VAL + "\"" + OUTPUT_VAL + "\""), (String)info.getCommandLine());
    }

    public final void testCustomGenerator() {
        IProjectType proj = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.test.java.attrs");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)proj);
        IConfiguration[] configs = proj.getConfigurations();
        ManagedCommandLineGeneratorTest.assertEquals((int)1, (int)configs.length);
        IConfiguration config = proj.getConfiguration("cdt.managedbuild.test.java.attrs.config");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)config);
        ITool[] tools = config.getTools();
        ManagedCommandLineGeneratorTest.assertEquals((int)1, (int)tools.length);
        ITool tool = config.getTool("cdt.managedbuild.test.java.attrs.tool");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)tool);
        IOption[] options = tool.getOptions();
        ManagedCommandLineGeneratorTest.assertEquals((int)20, (int)options.length);
        IOption option = tool.getOption("testgnu.c.compiler.option.preprocessor.def.symbols.test");
        ManagedCommandLineGeneratorTest.assertNotNull((Object)option);
        Object val = option.getValue();
        ManagedCommandLineGeneratorTest.assertTrue((boolean)(val instanceof ArrayList));
        ArrayList list = (ArrayList)val;
        ManagedCommandLineGeneratorTest.assertEquals((String)"foo", (String)((String)list.get(0)));
        ManagedCommandLineGeneratorTest.assertEquals((String)"bar", (String)((String)list.get(1)));
        IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
        String[] flags = new String[]{"-a", "-b", "-c"};
        String[] inputs = new String[]{"xy.cpp", "ab.cpp", "lt.cpp", "c.cpp"};
        IManagedCommandLineInfo info = gen.generateCommandLineInfo(tool, "MyName", flags, "-of", "opre", "TheOutput.exe", inputs, "[COMMAND] [FLAGS]");
        ManagedCommandLineGeneratorTest.assertEquals((String)"compiler.gnu.cMyName", (String)info.getCommandName());
        ManagedCommandLineGeneratorTest.assertEquals((String)"-c -b -a", (String)info.getFlags());
        ManagedCommandLineGeneratorTest.assertEquals((String)"ab.cpp c.cpp foo.cpp lt.cpp xy.cpp", (String)info.getInputs());
        ManagedCommandLineGeneratorTest.assertEquals((String)"-0h", (String)info.getOutputFlag());
        ManagedCommandLineGeneratorTest.assertEquals((String)"", (String)info.getOutputPrefix());
        ManagedCommandLineGeneratorTest.assertEquals((String)"Testme", (String)info.getOutput());
        ManagedCommandLineGeneratorTest.assertEquals((String)"[COMMAND] [FLAGS]", (String)info.getCommandLinePattern());
        ManagedCommandLineGeneratorTest.assertEquals((String)"This is a test command line", (String)info.getCommandLine());
        IManagedBuilderMakefileGenerator makeGen = ManagedBuildManager.getBuildfileGenerator((IConfiguration)config);
        String name = makeGen.getMakefileName();
        ManagedCommandLineGeneratorTest.assertEquals((String)"TestBuildFile.mak", (String)name);
    }

    public final void testCustomOptionCommandGenerator() {
        try {
            IProject project = ManagedBuildTestHelper.createProject("COCG", null, null, "cdt.test.customOptionCommand.ProjectType");
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            IConfiguration config = info.getDefaultConfiguration();
            ITool[] tools = config.getToolsBySuperClassId("cdt.test.customOptionCommand.Tool");
            ManagedCommandLineGeneratorTest.assertEquals((int)tools.length, (int)1);
            ITool tool = tools[0];
            IOption option1 = tool.getOptionBySuperClassId("cdt.test.customOptionCommand.option1");
            IOption option2 = tool.getOptionBySuperClassId("cdt.test.customOptionCommand.option2");
            IOption option3 = tool.getOptionBySuperClassId("cdt.test.customOptionCommand.option3");
            IOption option4 = tool.getOptionBySuperClassId("cdt.test.customOptionCommand.option4");
            ManagedCommandLineGeneratorTest.assertTrue((boolean)(option1.getCommandGenerator() instanceof CustomOptionCommandGenerator));
            ManagedCommandLineGeneratorTest.assertTrue((boolean)(option2.getCommandGenerator() instanceof CustomOptionCommandGenerator));
            ManagedCommandLineGeneratorTest.assertTrue((boolean)(option3.getCommandGenerator() instanceof CustomOptionCommandGenerator));
            ManagedCommandLineGeneratorTest.assertNull((Object)option4.getCommandGenerator());
            option1 = config.setOption((IHoldsOptions)tool, option1, new String[]{"val1", "val2", "${ProjName}"});
            option2 = config.setOption((IHoldsOptions)tool, option2, "${ProjName}");
            option3 = config.setOption((IHoldsOptions)tool, option3, "${ProjName}");
            option4 = config.setOption((IHoldsOptions)tool, option4, "${ProjName}");
            String command = tool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt1=\"val1;val2;COCG;\" -opt2=COCG -opt3 COCG -opt4=COCG", (String)command);
            ManagedBuildTestHelper.removeProject("COCG");
        }
        catch (Exception e) {
            ManagedCommandLineGeneratorTest.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
    }

    public final void testDollarValue() {
        try {
            IProject project = ManagedBuildTestHelper.createProject("CDV", null, null, "cdt.test.dollarValue.ProjectType");
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            IConfiguration config = info.getDefaultConfiguration();
            ITool[] tools = config.getToolsBySuperClassId("cdt.test.dollarValue.Tool");
            ManagedCommandLineGeneratorTest.assertEquals((int)tools.length, (int)1);
            ITool tool = tools[0];
            IOption option1 = tool.getOptionBySuperClassId("cdt.test.dollarValue.option1");
            IOption option2 = tool.getOptionBySuperClassId("cdt.test.dollarValue.option2");
            IOption option3 = tool.getOptionBySuperClassId("cdt.test.dollarValue.option3");
            IOption option4 = tool.getOptionBySuperClassId("cdt.test.dollarValue.option4");
            IOption option5 = tool.getOptionBySuperClassId("cdt.test.dollarValue.option5");
            IOption option6 = tool.getOptionBySuperClassId("cdt.test.dollarValue.option6");
            option1 = config.setOption((IHoldsOptions)tool, option1, "OPT1VALUE");
            option2 = config.setOption((IHoldsOptions)tool, option2, "");
            option3 = config.setOption((IHoldsOptions)tool, option3, "X");
            option4 = config.setOption((IHoldsOptions)tool, option4, "opt4");
            String command = tool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt1 OPT1VALUE X ${opt4}", (String)command);
            option1 = config.setOption((IHoldsOptions)tool, option1, "");
            option2 = config.setOption((IHoldsOptions)tool, option2, "Opt2");
            option3 = config.setOption((IHoldsOptions)tool, option3, "All work and no play...");
            option4 = config.setOption((IHoldsOptions)tool, option4, "123456789");
            option5 = config.setOption((IHoldsOptions)tool, option5, "DollarValue");
            command = tool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt2Opt2suffix All work and no play... ${123456789} DollarValueDollarValue", (String)command);
            option1 = config.setOption((IHoldsOptions)tool, option1, "0");
            option2 = config.setOption((IHoldsOptions)tool, option2, "LongValue");
            option3 = config.setOption((IHoldsOptions)tool, option3, "");
            option4 = config.setOption((IHoldsOptions)tool, option4, "");
            option5 = config.setOption((IHoldsOptions)tool, option5, "$");
            option6 = config.setOption((IHoldsOptions)tool, option6, "%%");
            command = tool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt1 0 -opt2LongValuesuffix $$ x%%yy%%z", (String)command);
            option1 = config.setOption((IHoldsOptions)tool, option1, "1");
            option2 = config.setOption((IHoldsOptions)tool, option2, "2");
            option3 = config.setOption((IHoldsOptions)tool, option3, "3");
            option4 = config.setOption((IHoldsOptions)tool, option4, "4");
            option5 = config.setOption((IHoldsOptions)tool, option5, "");
            option6 = config.setOption((IHoldsOptions)tool, option6, "");
            command = tool.getToolCommandFlagsString(null, null);
            ManagedCommandLineGeneratorTest.assertEquals((String)"-opt1 1 -opt22suffix 3 ${4}", (String)command);
            ManagedBuildTestHelper.removeProject("CDV");
        }
        catch (Exception e) {
            ManagedCommandLineGeneratorTest.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
    }
}

