/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class OptionCategoryEnablementTests
extends TestCase {
    private static final String testName = "optcaten";
    private static boolean fHandleValueCalled;

    public static Test suite() {
        return new TestSuite(OptionCategoryEnablementTests.class);
    }

    private void resetValueHandler() {
        fHandleValueCalled = false;
    }

    public void testEnablement() {
        this.resetValueHandler();
        IProject project = ManagedBuildTestHelper.createProject(testName, "cdt.managedbuild.target.enablement.exe");
        IFolder folder = ManagedBuildTestHelper.createFolder(project, "Folder");
        IFile aFile = ManagedBuildTestHelper.createFile(project, "a.c");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration cfg = info.getManagedProject().getConfigurations()[0];
        OptionCategoryEnablementTests.assertFalse((boolean)fHandleValueCalled);
        this.doTestEnablement((IBuildObject)cfg, folder, aFile);
        ManagedBuildTestHelper.removeProject(testName);
    }

    private void doTestEnablement(IBuildObject cfg, IFolder folder, IFile file) {
        try {
            ITool tool = this.getTool(cfg, "enablement.this");
            IOption option = tool.getOptionBySuperClassId("enablement.trigger");
            OptionCategoryEnablementTests.assertEquals((boolean)option.getBooleanValue(), (boolean)false);
            IOptionCategory optionCategory = tool.getOptionCategory("enablement.category");
            OptionCategoryEnablementTests.assertFalse((boolean)optionCategory.getApplicabilityCalculator().isOptionCategoryVisible(cfg, (IHoldsOptions)tool, optionCategory));
            ((IConfiguration)cfg).setOption((IHoldsOptions)tool, option, true);
            OptionCategoryEnablementTests.assertTrue((boolean)optionCategory.getApplicabilityCalculator().isOptionCategoryVisible(cfg, (IHoldsOptions)tool, optionCategory));
            IResourceInfo folderInfo = ((IConfiguration)cfg).getResourceInfo(folder.getFullPath(), false);
            OptionCategoryEnablementTests.assertNotNull((Object)folderInfo);
            option = this.getOptionForFolder((IFolderInfo)folderInfo, "enablement.this", "enablement.trigger");
            OptionCategoryEnablementTests.assertNotNull((Object)option);
            folderInfo.setOption((IHoldsOptions)tool, option, false);
            optionCategory = this.getOptionCategoryForFolder((IFolderInfo)folderInfo, "enablement.category");
            OptionCategoryEnablementTests.assertNotNull((Object)optionCategory);
            OptionCategoryEnablementTests.assertFalse((boolean)optionCategory.getApplicabilityCalculator().isOptionCategoryVisible(cfg, (IHoldsOptions)tool, optionCategory));
            folderInfo.setOption((IHoldsOptions)tool, option, true);
            OptionCategoryEnablementTests.assertTrue((boolean)optionCategory.getApplicabilityCalculator().isOptionCategoryVisible(cfg, (IHoldsOptions)tool, optionCategory));
            IResourceConfiguration fileInfo = ((IConfiguration)cfg).getResourceConfiguration(file.getFullPath().toString());
            if (fileInfo == null) {
                fileInfo = ((IConfiguration)cfg).createResourceConfiguration(file);
            }
            option = this.getOptionForFile((IFileInfo)fileInfo, "enablement.trigger");
            OptionCategoryEnablementTests.assertNotNull((Object)option);
            fileInfo.setOption((IHoldsOptions)tool, option, false);
            optionCategory = this.getOptionCategoryForFile((IFileInfo)fileInfo, "enablement.category");
            OptionCategoryEnablementTests.assertNotNull((Object)optionCategory);
            OptionCategoryEnablementTests.assertFalse((boolean)optionCategory.getApplicabilityCalculator().isOptionCategoryVisible(cfg, (IHoldsOptions)tool, optionCategory));
            fileInfo.setOption((IHoldsOptions)tool, option, true);
            OptionCategoryEnablementTests.assertTrue((boolean)optionCategory.getApplicabilityCalculator().isOptionCategoryVisible(cfg, (IHoldsOptions)tool, optionCategory));
        }
        catch (BuildException e) {
            OptionCategoryEnablementTests.fail((String)e.getLocalizedMessage());
        }
    }

    private ITool getTool(IBuildObject cfgBo, String id) {
        IResourceConfiguration rcCfg = null;
        IConfiguration cfg = null;
        ITool tool = null;
        if (cfgBo instanceof IResourceConfiguration) {
            rcCfg = (IResourceConfiguration)cfgBo;
            cfg = rcCfg.getParent();
            ITool[] tools = rcCfg.getTools();
            int i = 0;
            while (i < tools.length) {
                ITool tmp = tools[i];
                while (tmp != null) {
                    if (tmp.getId().equals(id)) {
                        tool = tools[i];
                        break;
                    }
                    tmp = tmp.getSuperClass();
                }
                ++i;
            }
        } else if (cfgBo instanceof IConfiguration) {
            cfg = (IConfiguration)cfgBo;
            tool = cfg.getToolsBySuperClassId(id)[0];
        } else {
            OptionCategoryEnablementTests.fail((String)"wrong argument");
        }
        return tool;
    }

    private IOption getOptionForFolder(IFolderInfo rcInfo, String toolId, String optionId) {
        ITool[] tools = null;
        tools = rcInfo.getToolsBySuperClassId(toolId);
        OptionCategoryEnablementTests.assertNotNull((Object)tools);
        ITool tool = tools[0];
        OptionCategoryEnablementTests.assertNotNull((Object)tool);
        IOption option = tool.getOptionBySuperClassId(optionId);
        return option;
    }

    private IOption getOptionForFile(IFileInfo rcInfo, String optionId) {
        ITool[] tools = null;
        tools = rcInfo.getTools();
        OptionCategoryEnablementTests.assertNotNull((Object)tools);
        ITool tool = tools[0];
        OptionCategoryEnablementTests.assertNotNull((Object)tool);
        IOption option = tool.getOptionBySuperClassId(optionId);
        return option;
    }

    private IOptionCategory getOptionCategoryForFolder(IFolderInfo rcInfo, String categoryId) {
        ITool[] tools = rcInfo.getTools();
        tools = rcInfo.getTools();
        OptionCategoryEnablementTests.assertNotNull((Object)tools);
        ITool tool = tools[0];
        OptionCategoryEnablementTests.assertNotNull((Object)tool);
        IOptionCategory optionCategory = tool.getOptionCategory(categoryId);
        return optionCategory;
    }

    private IOptionCategory getOptionCategoryForFile(IFileInfo rcInfo, String categoryId) {
        ITool[] tools = rcInfo.getTools();
        tools = rcInfo.getTools();
        OptionCategoryEnablementTests.assertNotNull((Object)tools);
        ITool tool = tools[0];
        OptionCategoryEnablementTests.assertNotNull((Object)tool);
        IOptionCategory optionCategory = tool.getOptionCategory(categoryId);
        return optionCategory;
    }
}

