/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.projectmodel.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.testplugin.BuildSystemTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionStringListValueTests
extends TestCase {
    private static final String PROJ_NAME_PREFIX = "OptionStringListValueTests_";

    public static Test suite() {
        return new TestSuite(OptionStringListValueTests.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testCfgDesEntries() throws Exception {
        String projName = "OptionStringListValueTests_1";
        IProject project = BuildSystemTestHelper.createProject(projName, null, "cdt.managedbuild.target.gnu30.exe");
        CoreModel model = CoreModel.getDefault();
        ICProjectDescriptionManager mngr = model.getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project);
        ICConfigurationDescription cfgDes = des.getConfigurations()[0];
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDes);
        ICFolderDescription fDes = cfgDes.getRootFolderDescription();
        cfg.getRootFolderInfo();
        ICLanguageSetting ls = fDes.getLanguageSettingForFile("a.c");
        ArrayList<CIncludePathEntry> list = new ArrayList<CIncludePathEntry>();
        list.add(new CIncludePathEntry("a", 0));
        list.add(new CIncludePathEntry("b", 0));
        list.addAll(ls.getSettingEntriesList(1));
        ls.setSettingEntries(1, list);
        List returned = ls.getSettingEntriesList(1);
        OptionStringListValueTests.assertEquals((int)list.size(), (int)returned.size());
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(list.toArray(), returned.toArray()));
        mngr.setProjectDescription(project, des);
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wsp.getRoot();
        project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        project = root.getProject(projName);
        des = mngr.getProjectDescription(project);
        OptionStringListValueTests.assertNull((String)"project description is not null for removed project", (Object)des);
        project = BuildSystemTestHelper.createProject(projName);
        des = mngr.getProjectDescription(project);
        OptionStringListValueTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        OptionStringListValueTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        cfgDes = des.getConfigurations()[0];
        fDes = cfgDes.getRootFolderDescription();
        ls = fDes.getLanguageSettingForFile("a.c");
        returned = ls.getSettingEntriesList(1);
        OptionStringListValueTests.assertEquals((int)list.size(), (int)returned.size());
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(list.toArray(), returned.toArray()));
    }

    public void testLibFiles() throws Exception {
        String projName = "OptionStringListValueTests_2";
        IProject project = BuildSystemTestHelper.createProject(projName, null, "lv.tests.ptype");
        CoreModel model = CoreModel.getDefault();
        ICProjectDescriptionManager mngr = model.getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project);
        ICConfigurationDescription cfgDes = des.getConfigurations()[0];
        ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDes);
        ICFolderDescription fDes = cfgDes.getRootFolderDescription();
        ICLanguageSetting ls = fDes.getLanguageSettingForFile("a.c");
        ArrayList<ICLanguageSettingEntry> list = new ArrayList<ICLanguageSettingEntry>();
        list.add((ICLanguageSettingEntry)new CLibraryFileEntry("usr_a", 0, (IPath)new Path("ap"), (IPath)new Path("arp"), (IPath)new Path("apx")));
        list.add((ICLanguageSettingEntry)new CLibraryFileEntry("usr_b", 0, (IPath)new Path("bp"), null, null));
        list.add((ICLanguageSettingEntry)new CLibraryFileEntry("usr_c", 0, (IPath)new Path("cp"), (IPath)new Path("crp"), null));
        list.add((ICLanguageSettingEntry)new CLibraryFileEntry("usr_d", 0, (IPath)new Path("dp"), null, (IPath)new Path("dpx")));
        list.addAll(ls.getSettingEntriesList(32));
        ls.setSettingEntries(32, list);
        ICLanguageSettingEntry[] resolved = ls.getResolvedSettingEntries(32);
        OptionStringListValueTests.assertEquals((int)list.size(), (int)resolved.length);
        int i = 0;
        while (i < resolved.length) {
            ICLibraryFileEntry other = (ICLibraryFileEntry)list.get(i);
            ICLibraryFileEntry r = (ICLibraryFileEntry)resolved[i];
            OptionStringListValueTests.assertEquals((String)other.getName(), (String)r.getName());
            OptionStringListValueTests.assertEquals((Object)other.getSourceAttachmentPath(), (Object)r.getSourceAttachmentPath());
            OptionStringListValueTests.assertEquals((Object)other.getSourceAttachmentRootPath(), (Object)r.getSourceAttachmentRootPath());
            OptionStringListValueTests.assertEquals((Object)other.getSourceAttachmentPrefixMapping(), (Object)r.getSourceAttachmentPrefixMapping());
            ++i;
        }
        List returned = ls.getSettingEntriesList(32);
        OptionStringListValueTests.assertEquals((int)list.size(), (int)returned.size());
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(list.toArray(), returned.toArray()));
        mngr.setProjectDescription(project, des);
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wsp.getRoot();
        project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        project = root.getProject(projName);
        des = mngr.getProjectDescription(project);
        OptionStringListValueTests.assertNull((String)"project description is not null for removed project", (Object)des);
        project = BuildSystemTestHelper.createProject(projName);
        des = mngr.getProjectDescription(project);
        OptionStringListValueTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        OptionStringListValueTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        cfgDes = des.getConfigurations()[0];
        fDes = cfgDes.getRootFolderDescription();
        ls = fDes.getLanguageSettingForFile("a.c");
        returned = ls.getSettingEntriesList(32);
        this.checkEntriesMatch(list, returned);
        OptionStringListValueTests.assertEquals((int)list.size(), (int)returned.size());
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(list.toArray(), returned.toArray()));
    }

    private void checkEntriesMatch(List<ICLanguageSettingEntry> list1, List<ICLanguageSettingEntry> list2) {
        LinkedHashSet<ICLanguageSettingEntry> set1 = new LinkedHashSet<ICLanguageSettingEntry>(list1);
        set1.removeAll(list2);
        LinkedHashSet<ICLanguageSettingEntry> set2 = new LinkedHashSet<ICLanguageSettingEntry>(list2);
        set2.removeAll(list1);
        if (set1.size() != 0 || set2.size() != 0) {
            OptionStringListValueTests.fail((String)"entries diff");
        }
    }

    private static String[] toValues(OptionStringValue[] ves) {
        String[] values = new String[ves.length];
        int i = 0;
        while (i < ves.length) {
            values[i] = ves[i].getValue();
            ++i;
        }
        return values;
    }

    private static void checkOptionValues(IOption option) throws Exception {
        List list = (List)option.getValue();
        Object[] values = list.toArray(new String[list.size()]);
        Object[] values2 = option.getBasicStringListValue();
        OptionStringValue[] values3 = option.getBasicStringListValueElements();
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(values, values2));
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(values, OptionStringListValueTests.toValues(values3)));
    }

    public void testOptions() throws Exception {
        String projName = "OptionStringListValueTests_3";
        IProject project = BuildSystemTestHelper.createProject(projName, null, "lv.tests.ptype");
        CoreModel model = CoreModel.getDefault();
        ICProjectDescriptionManager mngr = model.getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project);
        ICConfigurationDescription cfgDes = des.getConfigurations()[0];
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDes);
        cfgDes.getRootFolderDescription();
        IFolderInfo fInfo = cfg.getRootFolderInfo();
        ITool tool = fInfo.getToolsBySuperClassId("lv.tests.tool")[0];
        IOption option = tool.getOptionBySuperClassId("lv.tests.libFiles.option");
        Object[] builtins = option.getBuiltIns();
        OptionStringListValueTests.assertEquals((int)1, (int)builtins.length);
        Object[] expectedBIs = new String[]{"lf_c"};
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(expectedBIs, builtins));
        OptionStringListValueTests.checkOptionValues(option);
        ArrayList<String> list = new ArrayList<String>();
        list.add("usr_1");
        list.add("usr_2");
        list.addAll(Arrays.asList(option.getBasicStringListValue()));
        Object[] updated = list.toArray(new String[0]);
        option = ManagedBuildManager.setOption((IResourceInfo)fInfo, (IHoldsOptions)tool, (IOption)option, (String[])updated);
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(updated, option.getBasicStringListValue()));
        OptionStringListValueTests.checkOptionValues(option);
        list = new ArrayList();
        list.add((String)new OptionStringValue("usr_3", false, "ap", "arp", "apx"));
        list.add((String)new OptionStringValue("usr_4", false, null, null, null));
        list.add((String)new OptionStringValue("usr_5", false, "cp", null, null));
        list.add((String)new OptionStringValue("usr_6", false, "dp", null, "dpx"));
        list.add((String)new OptionStringValue("usr_6", false, null, null, "epx"));
        list.addAll(Arrays.asList(option.getBasicStringListValueElements()));
        Object[] updatedves = list.toArray(new OptionStringValue[0]);
        IOption updatedOption = ManagedBuildManager.setOption((IResourceInfo)fInfo, (IHoldsOptions)tool, (IOption)option, (OptionStringValue[])updatedves);
        OptionStringListValueTests.assertTrue((option == updatedOption ? 1 : 0) != 0);
        Object[] ves = option.getBasicStringListValueElements();
        OptionStringListValueTests.assertEquals((int)updatedves.length, (int)ves.length);
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(updatedves, ves));
        OptionStringListValueTests.checkOptionValues(option);
        mngr.setProjectDescription(project, des);
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wsp.getRoot();
        project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        project = root.getProject(projName);
        des = mngr.getProjectDescription(project);
        OptionStringListValueTests.assertNull((String)"project description is not null for removed project", (Object)des);
        project = BuildSystemTestHelper.createProject(projName);
        des = mngr.getProjectDescription(project);
        OptionStringListValueTests.assertNotNull((String)"project description is null for re-created project", (Object)des);
        OptionStringListValueTests.assertTrue((String)"des should be valid for re-created project", (boolean)des.isValid());
        cfgDes = des.getConfigurations()[0];
        cfgDes.getRootFolderDescription();
        cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDes);
        fInfo = cfg.getRootFolderInfo();
        tool = fInfo.getToolsBySuperClassId("lv.tests.tool")[0];
        option = tool.getOptionBySuperClassId("lv.tests.libFiles.option");
        ves = option.getBasicStringListValueElements();
        OptionStringListValueTests.assertTrue((boolean)Arrays.equals(updatedves, ves));
        OptionStringListValueTests.checkOptionValues(option);
    }
}

