/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.mingw;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class MingwEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static boolean checked = false;
    private static IPath binDir = null;
    private IBuildEnvironmentVariable path;

    public static IPath getBinDir() {
        if (!checked) {
            binDir = MingwEnvironmentVariableSupplier.findBinDir();
            checked = true;
        }
        return binDir;
    }

    private static IPath findBinDir() {
        String mingwHome = System.getenv("MINGW_HOME");
        Path mingwBinDir = new Path(String.valueOf(mingwHome) + "\\bin");
        if (mingwBinDir.toFile().isDirectory()) {
            return mingwBinDir;
        }
        Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
        mingwBinDir = installPath.append("mingw\\bin");
        if (mingwBinDir.toFile().isDirectory()) {
            return mingwBinDir;
        }
        IPath gccLoc = PathUtil.findProgramLocation((String)"mingw32-gcc.exe");
        if (gccLoc != null) {
            return gccLoc.removeLastSegments(1);
        }
        mingwBinDir = new Path("C:\\MinGW\\bin");
        if (mingwBinDir.toFile().isDirectory()) {
            return mingwBinDir;
        }
        return null;
    }

    public static IPath getMsysBinDir() {
        Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
        IPath msysBinPath = installPath.append("msys\\bin");
        if (msysBinPath.toFile().isDirectory()) {
            return msysBinPath;
        }
        String mingwHome = System.getenv("MINGW_HOME");
        if (mingwHome != null && (msysBinPath = new Path(String.valueOf(mingwHome) + "\\msys\\1.0\\bin")).toFile().isDirectory()) {
            return msysBinPath;
        }
        msysBinPath = new Path("C:\\MinGW\\msys\\1.0\\bin");
        if (msysBinPath.toFile().isDirectory()) {
            return msysBinPath;
        }
        return null;
    }

    public MingwEnvironmentVariableSupplier() {
        IPath binPath = MingwEnvironmentVariableSupplier.getBinDir();
        if (binPath != null) {
            String pathStr = binPath.toOSString();
            IPath msysBinPath = MingwEnvironmentVariableSupplier.getMsysBinDir();
            if (msysBinPath != null) {
                pathStr = String.valueOf(pathStr) + ';' + msysBinPath.toOSString();
            }
            this.path = new MingwBuildEnvironmentVariable("PATH", pathStr, 3);
        }
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (this.path != null && variableName.equals(this.path.getName())) {
            return this.path;
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray;
        if (this.path != null) {
            IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = new IBuildEnvironmentVariable[1];
            iBuildEnvironmentVariableArray = iBuildEnvironmentVariableArray2;
            iBuildEnvironmentVariableArray2[0] = this.path;
        } else {
            iBuildEnvironmentVariableArray = new IBuildEnvironmentVariable[]{};
        }
        return iBuildEnvironmentVariableArray;
    }

    private static class MingwBuildEnvironmentVariable
    implements IBuildEnvironmentVariable {
        private final String name;
        private final String value;
        private final int operation;

        public MingwBuildEnvironmentVariable(String name, String value, int operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getDelimiter() {
            return ";";
        }
    }
}

