/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.eclipse.cdt.internal.p2.touchpoint.natives.actions.CleanupUntarAction;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;

public class UntarAction
extends ProvisioningAction {
    private static final String ACTION_NAME = "untar";
    private static final String PARM_COMPRESSION = "compression";
    private static final String VALUE_GZ = "gz";
    private static final String VALUE_BZ2 = "bz2";

    public IStatus execute(Map parameters) {
        try {
            return UntarAction.untar(parameters);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.cdt.p2", e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public IStatus undo(Map parameters) {
        try {
            return CleanupUntarAction.cleanup(parameters);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.cdt.p2", e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static IStatus untar(Map parameters) throws Exception {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createError((String)NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_NAME));
        }
        String originalSource = source;
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createError((String)NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_NAME));
        }
        String compressionStr = (String)parameters.get(PARM_COMPRESSION);
        if (compressionStr == null) {
            return Util.createError((String)NLS.bind((String)Messages.param_not_set, (Object)PARM_COMPRESSION, (Object)ACTION_NAME));
        }
        Compression compression = compressionStr.equals(VALUE_GZ) ? Compression.gz : (compressionStr.equals(VALUE_BZ2) ? Compression.bz2 : Compression.none);
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
        if (source.equals("@artifact")) {
            IFileArtifactRepository downloadCache;
            if (iu.getArtifacts() == null || iu.getArtifacts().size() == 0) {
                return Status.OK_STATUS;
            }
            IArtifactKey artifactKey = (IArtifactKey)iu.getArtifacts().iterator().next();
            try {
                downloadCache = Util.getDownloadCacheRepo((IProvisioningAgent)agent);
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
            File fileLocation = downloadCache.getArtifactFile(artifactKey);
            if (fileLocation == null || !fileLocation.exists()) {
                return Util.createError((String)NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = fileLocation.getAbsolutePath();
        }
        File[] unzippedFiles = UntarAction.untar(source, target, compression);
        StringBuffer unzippedFileNameBuffer = new StringBuffer();
        int i = 0;
        while (i < unzippedFiles.length) {
            unzippedFileNameBuffer.append(unzippedFiles[i].getAbsolutePath()).append("|");
            ++i;
        }
        profile.setInstallableUnitProperty(iu, "unzipped|" + originalSource + "|" + target, unzippedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    private static File[] untar(String source, String destination, Compression compression) throws Exception {
        FileInputStream fileIn;
        File zipFile = new File(source);
        if (!zipFile.exists()) {
            Util.log((String)(String.valueOf(UnzipAction.class.getName()) + " the files to be unzipped is not here"));
        }
        File target = new File(destination);
        InputStream compIn = fileIn = new FileInputStream(zipFile);
        if (compression.equals((Object)Compression.gz)) {
            compIn = new GZIPInputStream(fileIn);
        } else if (compression.equals((Object)Compression.bz2)) {
            fileIn.read(new byte[2]);
            compIn = new CBZip2InputStream((InputStream)fileIn);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        TarInputStream tarIn = new TarInputStream(compIn);
        TarEntry tarEntry = tarIn.getNextEntry();
        while (tarEntry != null) {
            File outFile = new File(target, tarEntry.getName());
            if (tarEntry.isDirectory()) {
                outFile.mkdirs();
            } else {
                if (outFile.exists()) {
                    outFile.delete();
                } else {
                    outFile.getParentFile().mkdirs();
                }
                FileOutputStream outStream = new FileOutputStream(outFile);
                tarIn.copyEntryContents((OutputStream)outStream);
                outStream.close();
                long lastModified = tarEntry.getModTime().getTime();
                outFile.setLastModified(lastModified);
                int mode = tarEntry.getMode();
                fileList.add(outFile);
            }
            tarEntry = tarIn.getNextEntry();
        }
        tarIn.close();
        return fileList.toArray(new File[fileList.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Compression {
        none,
        gz,
        bz2;

    }
}

